<?php 
session_start();
include('includes/head.php');

// Check if current admin has permission (only super_admin can manage admins)
$current_admin_role = $_SESSION['admin_role'] ?: 'support';
if ($current_admin_role != 'super_admin') {
    header('Location: dashboard.php?error=You do not have permission to access this page.');
    exit();
}

// PIN for confirmation
$admin_pin = "1234"; // Change this to a secure PIN

// Get current admin details for notifications
$current_admin_id = $_SESSION['admin_id'] ?: 1;
$current_admin_query = mysqli_query($conn, "SELECT name, email FROM admins WHERE id = '$current_admin_id'");
$current_admin_data = mysqli_fetch_assoc($current_admin_query);
$current_admin_name = $current_admin_data['name'] ?? 'Super Administrator';
$current_admin_email = $current_admin_data['email'] ?? 'admin@system.com';

// Handle actions
$action = isset($_GET['action']) ? $_GET['action'] : '';
$admin_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $submitted_pin = isset($_POST['admin_pin']) ? trim($_POST['admin_pin']) : '';
    $action_type = isset($_POST['action_type']) ? $_POST['action_type'] : '';
    $target_id = isset($_POST['admin_id']) ? intval($_POST['admin_id']) : 0;
    
    // Verify PIN
    if ($submitted_pin !== $admin_pin) {
        $error = "Invalid PIN. Action not authorized.";
    } else {
        switch ($action_type) {
            case 'add_admin':
                $name = mysqli_real_escape_string($conn, $_POST['name']);
                $email = mysqli_real_escape_string($conn, $_POST['email']);
                $password = mysqli_real_escape_string($conn, $_POST['password']);
                $role = mysqli_real_escape_string($conn, $_POST['role']);
                
                // Check if email already exists
                $check_sql = "SELECT id FROM admins WHERE email = '$email'";
                $check_result = mysqli_query($conn, $check_sql);
                if (mysqli_num_rows($check_result) > 0) {
                    $error = "Email already exists.";
                    break;
                }
                
                // Hash password (MD5 for compatibility with your existing admins table)
                $hashed_password = md5($password);
                
                $sql = "INSERT INTO admins (name, email, password, role, is_active, created_at) 
                        VALUES ('$name', '$email', '$hashed_password', '$role', 1, NOW())";
                
                if (mysqli_query($conn, $sql)) {
                    $new_admin_id = mysqli_insert_id($conn);
                    
                    // Log activity
                    logAdminActivity(
                        'Admin Added',
                        "Added new admin: $name ($email) with role: $role",
                        'Admin Management',
                        $new_admin_id,
                        'admins'
                    );
                    
                    // NOTIFICATION: New Admin Added (CURRENT ADMIN)
                    $mail_subject = "New Administrator Account Created";
                    $mail_message = "<!-- Content Section -->
                                    <div class='email-content'>
                                        <h2 class='greeting'>New Administrator Account Created</h2>
                                        
                                        <p class='message'>
                                            A new administrator account has been added to the system.
                                        </p>

                                        <!-- New Admin Details -->
                                        <div class='details-section'>
                                            <div class='detail-box'>
                                                <strong>New Admin ID:</strong> ADMIN-" . $new_admin_id . "<br>
                                                <strong>Admin Name:</strong> " . $name . "<br>
                                                <strong>Admin Email:</strong> " . $email . "<br>
                                                <strong>Admin Role:</strong> <span style='color: " . 
                                                    ($role == 'super_admin' ? '#dc3545' : 
                                                     ($role == 'admin' ? '#0d6efd' : '#198754')) . 
                                                    "; font-weight: bold;'>" . ucfirst(str_replace('_', ' ', $role)) . "</span><br>
                                                <strong>Account Status:</strong> <span style='color: #28a745; font-weight: bold;'>ACTIVE</span><br>
                                                <strong>Created By:</strong> " . $current_admin_name . " (ID: " . $current_admin_id . ")<br>
                                                <strong>Creation Date:</strong> " . date('F j, Y g:i A') . "<br>
                                                <strong>Initial Password:</strong> Provided during creation<br>
                                                <strong>Access Level:</strong> " . 
                                                    ($role == 'super_admin' ? 'Full System Access' : 
                                                     ($role == 'admin' ? 'Administrative Access' : 'Support Access')) . "
                                            </div>
                                        </div>

                                        <!-- Security Information -->
                                        <div style='background: #fff3cd; border: 1px solid #ffeaa7; border-radius: 8px; padding: 20px; margin: 25px 0;'>
                                            <h4 style='color: #856404;'>🔒 Security Information</h4>
                                            <p style='color: #856404;'>
                                                <strong>New Account Details:</strong><br>
                                                • Account created with temporary password<br>
                                                • Password must be changed on first login<br>
                                                • Recommend enabling Two-Factor Authentication<br>
                                                • Monitor initial login activities
                                            </p>
                                        </div>

                                        <!-- Admin Actions -->
                                        <div style='text-align: center; margin: 30px 0;'>
                                            <a href='" . $myUrl . "/admin/admins.php' class='verification-button' style='display: inline-block; padding: 12px 30px; background: #198754; color: white; text-decoration: none; border-radius: 6px; font-weight: 600; margin: 5px;'>
                                                View All Admins
                                            </a>
                                            <a href='" . $myUrl . "/admin/admin_activities.php' class='verification-button' style='display: inline-block; padding: 12px 30px; background: #0dcaf0; color: white; text-decoration: none; border-radius: 6px; font-weight: 600; margin: 5px;'>
                                                View Activity Logs
                                            </a>
                                        </div>

                                        <!-- System Information -->
                                        <div class='support-section'>
                                            <p class='support-text'>System Information:</p>
                                            <p style='color: #6c757d; font-size: 12px;'>
                                                <strong>Total Admins Now:</strong> " . (mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as count FROM admins"))['count'] ?? 0) . "<br>
                                                <strong>Super Admins:</strong> " . (mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as count FROM admins WHERE role = 'super_admin'"))['count'] ?? 0) . "<br>
                                                <strong>Action:</strong> Manual Admin Creation<br>
                                                <strong>Audit Trail:</strong> Logged in admin_activities
                                            </p>
                                        </div>
                                    </div>";

                    // Send admin notification
                    require_once("../proccess/admin_mailer.php");
                    
                    $success = "Admin added successfully!";
                } else {
                    $error = "Failed to add admin.";
                }
                break;
                
            case 'update_admin':
                $name = mysqli_real_escape_string($conn, $_POST['name']);
                $email = mysqli_real_escape_string($conn, $_POST['email']);
                $role = mysqli_real_escape_string($conn, $_POST['role']);
                $is_active = isset($_POST['is_active']) ? 1 : 0;
                
                // Get old admin data for comparison
                $old_sql = "SELECT name, email, role, is_active FROM admins WHERE id = $target_id";
                $old_result = mysqli_query($conn, $old_sql);
                $old_data = mysqli_fetch_assoc($old_result);
                $old_name = $old_data['name'] ?? '';
                $old_email = $old_data['email'] ?? '';
                $old_role = $old_data['role'] ?? '';
                $old_active = $old_data['is_active'] ?? 0;
                
                // Check if email already exists (excluding current admin)
                $check_sql = "SELECT id FROM admins WHERE email = '$email' AND id != $target_id";
                $check_result = mysqli_query($conn, $check_sql);
                if (mysqli_num_rows($check_result) > 0) {
                    $error = "Email already exists.";
                    break;
                }
                
                $sql = "UPDATE admins SET 
                        name = '$name',
                        email = '$email',
                        role = '$role',
                        is_active = $is_active,
                        updated_at = NOW()
                        WHERE id = $target_id";
                
                if (mysqli_query($conn, $sql)) {
                    // Log activity
                    logAdminActivity(
                        'Admin Updated',
                        "Updated admin ID $target_id: $name ($email)",
                        'Admin Management',
                        $target_id,
                        'admins'
                    );
                    
                    // NOTIFICATION: Admin Updated (CURRENT ADMIN)
                    $mail_subject = "Administrator Account Updated";
                    $mail_message = "<!-- Content Section -->
                                    <div class='email-content'>
                                        <h2 class='greeting'>Administrator Account Updated</h2>
                                        
                                        <p class='message'>
                                            An administrator account has been modified in the system.
                                        </p>

                                        <!-- Update Details -->
                                        <div class='details-section'>
                                            <div class='detail-box'>
                                                <strong>Admin ID:</strong> ADMIN-" . $target_id . "<br>
                                                <strong>Updated By:</strong> " . $current_admin_name . " (ID: " . $current_admin_id . ")<br>
                                                <strong>Update Date:</strong> " . date('F j, Y g:i A') . "<br>
                                                <strong>IP Address:</strong> " . $_SERVER['REMOTE_ADDR'] . "
                                            </div>
                                        </div>

                                        <!-- Changes Made -->
                                        <div class='changes-section'>
                                            <h3 style='color: #2c3e50;'>Changes Applied</h3>
                                            <table style='width: 100%; border-collapse: collapse; margin: 15px 0;'>
                                                <thead>
                                                    <tr style='background: #f8f9fa;'>
                                                        <th style='border: 1px solid #dee2e6; padding: 8px; text-align: left;'>Field</th>
                                                        <th style='border: 1px solid #dee2e6; padding: 8px; text-align: left;'>Old Value</th>
                                                        <th style='border: 1px solid #dee2e6; padding: 8px; text-align: left;'>New Value</th>
                                                        <th style='border: 1px solid #dee2e6; padding: 8px; text-align: left;'>Status</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td style='border: 1px solid #dee2e6; padding: 8px;'><strong>Name</strong></td>
                                                        <td style='border: 1px solid #dee2e6; padding: 8px;'>" . $old_name . "</td>
                                                        <td style='border: 1px solid #dee2e6; padding: 8px;'>" . $name . "</td>
                                                        <td style='border: 1px solid #dee2e6; padding: 8px;'>" . 
                                                            ($old_name != $name ? '<span style="color: #ffc107;">Changed</span>' : '<span style="color: #6c757d;">Unchanged</span>') . "
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style='border: 1px solid #dee2e6; padding: 8px;'><strong>Email</strong></td>
                                                        <td style='border: 1px solid #dee2e6; padding: 8px;'>" . $old_email . "</td>
                                                        <td style='border: 1px solid #dee2e6; padding: 8px;'>" . $email . "</td>
                                                        <td style='border: 1px solid #dee2e6; padding: 8px;'>" . 
                                                            ($old_email != $email ? '<span style="color: #ffc107;">Changed</span>' : '<span style="color: #6c757d;">Unchanged</span>') . "
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style='border: 1px solid #dee2e6; padding: 8px;'><strong>Role</strong></td>
                                                        <td style='border: 1px solid #dee2e6; padding: 8px;'><span style='color: " . 
                                                            ($old_role == 'super_admin' ? '#dc3545' : 
                                                             ($old_role == 'admin' ? '#0d6efd' : '#198754')) . 
                                                            ";'>" . ucfirst(str_replace('_', ' ', $old_role)) . "</span></td>
                                                        <td style='border: 1px solid #dee2e6; padding: 8px;'><span style='color: " . 
                                                            ($role == 'super_admin' ? '#dc3545' : 
                                                             ($role == 'admin' ? '#0d6efd' : '#198754')) . 
                                                            "; font-weight: bold;'>" . ucfirst(str_replace('_', ' ', $role)) . "</span></td>
                                                        <td style='border: 1px solid #dee2e6; padding: 8px;'>" . 
                                                            ($old_role != $role ? '<span style="color: #ffc107;">Changed</span>' : '<span style="color: #6c757d;">Unchanged</span>') . "
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style='border: 1px solid #dee2e6; padding: 8px;'><strong>Status</strong></td>
                                                        <td style='border: 1px solid #dee2e6; padding: 8px;'><span style='color: " . 
                                                            ($old_active == 1 ? '#28a745' : '#dc3545') . 
                                                            ";'>" . ($old_active == 1 ? 'Active' : 'Inactive') . "</span></td>
                                                        <td style='border: 1px solid #dee2e6; padding: 8px;'><span style='color: " . 
                                                            ($is_active == 1 ? '#28a745' : '#dc3545') . 
                                                            "; font-weight: bold;'>" . ($is_active == 1 ? 'Active' : 'Inactive') . "</span></td>
                                                        <td style='border: 1px solid #dee2e6; padding: 8px;'>" . 
                                                            ($old_active != $is_active ? '<span style="color: #ffc107;">Changed</span>' : '<span style="color: #6c757d;">Unchanged</span>') . "
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>

                                        <!-- Impact Analysis -->
                                        <div style='background: #e7f3ff; border: 1px solid #b3d7ff; border-radius: 8px; padding: 20px; margin: 25px 0;'>
                                            <h4 style='color: #0056b3;'>📊 Impact Analysis</h4>
                                            <p style='color: #0056b3;'>
                                                " . ($old_role != $role ? 
                                                "<strong>Role Change Impact:</strong> Access permissions have been modified. The admin may gain or lose certain system capabilities." : 
                                                "<strong>No Role Change:</strong> Access permissions remain unchanged.") . "<br>
                                                " . ($old_active != $is_active ? 
                                                "<strong>Status Change:</strong> Account " . ($is_active == 1 ? 'activated' : 'deactivated') . ". " . 
                                                ($is_active == 0 ? 'Admin can no longer access the system.' : 'Admin can now access the system.') : 
                                                "<strong>Status Unchanged:</strong> Account remains " . ($is_active == 1 ? 'active' : 'inactive') . ".") . "
                                            </p>
                                        </div>

                                        <!-- Admin Actions -->
                                        <div style='text-align: center; margin: 30px 0;'>
                                            <a href='" . $myUrl . "/admin/admins.php' class='verification-button' style='display: inline-block; padding: 12px 30px; background: #198754; color: white; text-decoration: none; border-radius: 6px; font-weight: 600; margin: 5px;'>
                                                Return to Admin Management
                                            </a>
                                        </div>

                                        <!-- System Information -->
                                        <div class='support-section'>
                                            <p class='support-text'>Security Audit Information:</p>
                                            <p style='color: #6c757d; font-size: 12px;'>
                                                <strong>Action:</strong> Manual Admin Update<br>
                                                <strong>Requester:</strong> " . $current_admin_name . "<br>
                                                <strong>Time:</strong> " . date('Y-m-d H:i:s') . "<br>
                                                <strong>Session ID:</strong> " . session_id() . "
                                            </p>
                                        </div>
                                    </div>";

                    // Send admin notification
                    require_once("../proccess/admin_mailer.php");
                    
                    $success = "Admin updated successfully!";
                } else {
                    $error = "Failed to update admin.";
                }
                break;
                
            case 'update_password':
                $new_password = mysqli_real_escape_string($conn, $_POST['new_password']);
                $confirm_password = mysqli_real_escape_string($conn, $_POST['confirm_password']);
                
                if ($new_password !== $confirm_password) {
                    $error = "Passwords do not match.";
                    break;
                }
                
                // Get admin details
                $admin_sql = "SELECT name, email FROM admins WHERE id = $target_id";
                $admin_result = mysqli_query($conn, $admin_sql);
                $admin_data = mysqli_fetch_assoc($admin_result);
                $target_admin_name = $admin_data['name'] ?? '';
                $target_admin_email = $admin_data['email'] ?? '';
                
                $hashed_password = md5($new_password);
                $sql = "UPDATE admins SET password = '$hashed_password', updated_at = NOW() WHERE id = $target_id";
                
                if (mysqli_query($conn, $sql)) {
                    // Log activity
                    logAdminActivity(
                        'Admin Password Updated',
                        "Updated password for admin ID $target_id",
                        'Admin Management',
                        $target_id,
                        'admins'
                    );
                    
                    // NOTIFICATION: Admin Password Updated (CURRENT ADMIN)
                    $mail_subject = "Administrator Password Reset";
                    $mail_message = "<!-- Content Section -->
                                    <div class='email-content'>
                                        <h2 class='greeting'>Administrator Password Reset</h2>
                                        
                                        <p class='message'>
                                            An administrator account password has been reset in the system.
                                        </p>

                                        <!-- Password Reset Details -->
                                        <div class='details-section'>
                                            <div class='detail-box'>
                                                <strong>Admin ID:</strong> ADMIN-" . $target_id . "<br>
                                                <strong>Admin Name:</strong> " . $target_admin_name . "<br>
                                                <strong>Admin Email:</strong> " . $target_admin_email . "<br>
                                                <strong>Reset By:</strong> " . $current_admin_name . " (ID: " . $current_admin_id . ")<br>
                                                <strong>Reset Date:</strong> " . date('F j, Y g:i A') . "<br>
                                                <strong>IP Address:</strong> " . $_SERVER['REMOTE_ADDR'] . "<br>
                                                <strong>Reset Type:</strong> Manual by Super Administrator<br>
                                                <strong>Password Status:</strong> <span style='color: #28a745; font-weight: bold;'>CHANGED</span>
                                            </div>
                                        </div>

                                        <!-- Security Implications -->
                                        <div style='background: #f8d7da; border: 1px solid #f5c6cb; border-radius: 8px; padding: 20px; margin: 25px 0;'>
                                            <h4 style='color: #721c24;'>⚠️ Security Alert</h4>
                                            <p style='color: #721c24;'>
                                                <strong>Important Security Notes:</strong><br>
                                                • The affected admin will need to use the new password immediately<br>
                                                • Any existing sessions for this admin may be invalidated<br>
                                                • Monitor for any suspicious login attempts<br>
                                                • Consider if this reset was authorized
                                            </p>
                                        </div>

                                        <!-- Next Steps -->
                                        <div class='next-steps'>
                                            <h3 style='color: #2c3e50;'>🔑 Next Steps</h3>
                                            <p style='color: #6c757d;'>Recommended actions:</p>
                                            <ul style='color: #6c757d;'>
                                                <li>Inform the affected admin about the password change</li>
                                                <li>Advise them to change their password again after login</li>
                                                <li>Recommend enabling Two-Factor Authentication</li>
                                                <li>Monitor login activity for this account</li>
                                            </ul>
                                        </div>

                                        <!-- Admin Actions -->
                                        <div style='text-align: center; margin: 30px 0;'>
                                            <a href='" . $myUrl . "/admin/admins.php' class='verification-button' style='display: inline-block; padding: 12px 30px; background: #198754; color: white; text-decoration: none; border-radius: 6px; font-weight: 600; margin: 5px;'>
                                                Return to Admin Management
                                            </a>
                                        </div>

                                        <!-- System Information -->
                                        <div class='support-section'>
                                            <p class='support-text'>Security Audit Information:</p>
                                            <p style='color: #6c757d; font-size: 12px;'>
                                                <strong>Action:</strong> Manual Password Reset<br>
                                                <strong>Timestamp:</strong> " . date('Y-m-d H:i:s') . "<br>
                                                <strong>Session ID:</strong> " . session_id() . "<br>
                                                <strong>User Agent:</strong> " . substr($_SERVER['HTTP_USER_AGENT'], 0, 100) . "...
                                            </p>
                                        </div>
                                    </div>";

                    // Send admin notification
                    require_once("../proccess/admin_mailer.php");
                    
                    $success = "Password updated successfully!";
                } else {
                    $error = "Failed to update password.";
                }
                break;
                
            case 'delete_admin':
                // Prevent deleting yourself
                if ($target_id == $_SESSION['admin_id']) {
                    $error = "You cannot delete your own account.";
                    break;
                }
                
                // Get admin details before deletion
                $admin_sql = "SELECT name, email, role, created_at FROM admins WHERE id = $target_id";
                $admin_result = mysqli_query($conn, $admin_sql);
                $admin_data = mysqli_fetch_assoc($admin_result);
                $target_admin_name = $admin_data['name'] ?? '';
                $target_admin_email = $admin_data['email'] ?? '';
                $target_admin_role = $admin_data['role'] ?? '';
                $account_created = $admin_data['created_at'] ?? '';
                $account_age = $account_created ? round((time() - strtotime($account_created)) / (60 * 60 * 24), 1) : 0;
                
                $sql = "DELETE FROM admins WHERE id = $target_id";
                
                if (mysqli_query($conn, $sql)) {
                    // Log activity
                    logAdminActivity(
                        'Admin Deleted',
                        "Deleted admin ID $target_id",
                        'Admin Management',
                        $target_id,
                        'admins'
                    );
                    
                    // NOTIFICATION: Admin Deleted (CURRENT ADMIN)
                    $mail_subject = "Administrator Account Deleted";
                    $mail_message = "<!-- Content Section -->
                                    <div class='email-content'>
                                        <h2 class='greeting'>Administrator Account Deleted</h2>
                                        
                                        <p class='message'>
                                            An administrator account has been permanently deleted from the system.
                                        </p>

                                        <!-- Deletion Details -->
                                        <div class='details-section'>
                                            <div class='detail-box'>
                                                <strong>Deleted Admin ID:</strong> ADMIN-" . $target_id . "<br>
                                                <strong>Admin Name:</strong> " . $target_admin_name . "<br>
                                                <strong>Admin Email:</strong> " . $target_admin_email . "<br>
                                                <strong>Admin Role:</strong> <span style='color: " . 
                                                    ($target_admin_role == 'super_admin' ? '#dc3545' : 
                                                     ($target_admin_role == 'admin' ? '#0d6efd' : '#198754')) . 
                                                    ";'>" . ucfirst(str_replace('_', ' ', $target_admin_role)) . "</span><br>
                                                <strong>Account Age:</strong> " . $account_age . " days<br>
                                                <strong>Deleted By:</strong> " . $current_admin_name . " (ID: " . $current_admin_id . ")<br>
                                                <strong>Deletion Date:</strong> " . date('F j, Y g:i A') . "<br>
                                                <strong>IP Address:</strong> " . $_SERVER['REMOTE_ADDR'] . "<br>
                                                <strong>Deletion Type:</strong> Manual Permanent Deletion<br>
                                                <strong>Status:</strong> <span style='color: #dc3545; font-weight: bold;'>PERMANENTLY DELETED</span>
                                            </div>
                                        </div>

                                        <!-- Security Warning -->
                                        <div style='background: #f8d7da; border: 1px solid #f5c6cb; border-radius: 8px; padding: 20px; margin: 25px 0;'>
                                            <h4 style='color: #721c24;'>⚠️ Irreversible Action</h4>
                                            <p style='color: #721c24;'>
                                                <strong>This action cannot be undone!</strong><br>
                                                • All admin account data has been permanently removed<br>
                                                • Login access has been immediately revoked<br>
                                                • No recovery of this account is possible<br>
                                                • All associated data has been deleted
                                            </p>
                                        </div>

                                        <!-- Reasons & Impact -->
                                        <div class='next-steps'>
                                            <h3 style='color: #2c3e50;'>🗑️ Common Deletion Reasons</h3>
                                            <p style='color: #6c757d;'>Possible reasons for admin deletion:</p>
                                            <ul style='color: #6c757d;'>
                                                <li>Admin role no longer required</li>
                                                <li>Security compliance requirements</li>
                                                <li>Employee/team member departure</li>
                                                <li>Account consolidation</li>
                                                <li>Security audit findings</li>
                                            </ul>
                                        </div>

                                        <!-- Admin Actions -->
                                        <div style='text-align: center; margin: 30px 0;'>
                                            <a href='" . $myUrl . "/admin/admins.php' class='verification-button' style='display: inline-block; padding: 12px 30px; background: #198754; color: white; text-decoration: none; border-radius: 6px; font-weight: 600; margin: 5px;'>
                                                Return to Admin Management
                                            </a>
                                            <a href='" . $myUrl . "/admin/admin_activities.php' class='verification-button' style='display: inline-block; padding: 12px 30px; background: #0dcaf0; color: white; text-decoration: none; border-radius: 6px; font-weight: 600; margin: 5px;'>
                                                View Activity Logs
                                            </a>
                                        </div>

                                        <!-- System Information -->
                                        <div class='support-section'>
                                            <p class='support-text'>System Security Audit:</p>
                                            <p style='color: #6c757d; font-size: 12px;'>
                                                <strong>Action:</strong> Manual Admin Deletion<br>
                                                <strong>Timestamp:</strong> " . date('Y-m-d H:i:s') . "<br>
                                                <strong>Remaining Admins:</strong> " . (mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as count FROM admins"))['count'] ?? 0) . "<br>
                                                <strong>Audit ID:</strong> DEL-" . time() . "-" . $target_id . "
                                            </p>
                                        </div>
                                    </div>";

                    // Send admin notification
                    require_once("../proccess/admin_mailer.php");
                    
                    $success = "Admin deleted successfully!";
                } else {
                    $error = "Failed to delete admin.";
                }
                break;
                
            case 'reset_2fa':
                // This would reset 2FA for the admin
                // Get admin details
                $admin_sql = "SELECT name, email FROM admins WHERE id = $target_id";
                $admin_result = mysqli_query($conn, $admin_sql);
                $admin_data = mysqli_fetch_assoc($admin_result);
                $target_admin_name = $admin_data['name'] ?? '';
                $target_admin_email = $admin_data['email'] ?? '';
                
                // Implement 2FA reset logic here
                // Example: $twofa_sql = "UPDATE admins SET twofa_secret = NULL, twofa_enabled = 0 WHERE id = $target_id";
                // mysqli_query($conn, $twofa_sql);
                
                // Log activity
                logAdminActivity(
                    '2FA Reset',
                    "Reset 2FA for admin ID $target_id: $target_admin_name",
                    'Admin Management',
                    $target_id,
                    'admins'
                );
                
                // NOTIFICATION: 2FA Reset (CURRENT ADMIN)
                $mail_subject = "Two-Factor Authentication Reset";
                $mail_message = "<!-- Content Section -->
                                <div class='email-content'>
                                    <h2 class='greeting'>Two-Factor Authentication Reset</h2>
                                    
                                    <p class='message'>
                                        Two-Factor Authentication has been reset for an administrator account.
                                    </p>

                                    <!-- 2FA Reset Details -->
                                    <div class='details-section'>
                                        <div class='detail-box'>
                                            <strong>Admin ID:</strong> ADMIN-" . $target_id . "<br>
                                            <strong>Admin Name:</strong> " . $target_admin_name . "<br>
                                            <strong>Admin Email:</strong> " . $target_admin_email . "<br>
                                            <strong>Reset By:</strong> " . $current_admin_name . " (ID: " . $current_admin_id . ")<br>
                                            <strong>Reset Date:</strong> " . date('F j, Y g:i A') . "<br>
                                            <strong>IP Address:</strong> " . $_SERVER['REMOTE_ADDR'] . "<br>
                                            <strong>2FA Status:</strong> <span style='color: #ffc107; font-weight: bold;'>DISABLED</span><br>
                                            <strong>Security Impact:</strong> Reduced account security until 2FA is re-enabled
                                        </div>
                                    </div>

                                    <!-- Security Implications -->
                                    <div style='background: #fff3cd; border: 1px solid #ffeaa7; border-radius: 8px; padding: 20px; margin: 25px 0;'>
                                        <h4 style='color: #856404;'>⚠️ Security Alert</h4>
                                        <p style='color: #856404;'>
                                            <strong>Important Security Notes:</strong><br>
                                            • The admin's 2FA protection has been removed<br>
                                            • Account now relies only on password protection<br>
                                            • The admin must set up 2FA again on next login<br>
                                            • Monitor account for suspicious login attempts
                                        </p>
                                    </div>

                                    <!-- Next Steps -->
                                    <div class='next-steps'>
                                        <h3 style='color: #2c3e50;'>🔄 Required Actions</h3>
                                        <p style='color: #6c757d;'>The affected admin must:</p>
                                        <ul style='color: #6c757d;'>
                                            <li>Set up 2FA again on their next login</li>
                                            <li>Use an authenticator app for setup</li>
                                            <li>Securely store backup codes</li>
                                            <li>Complete setup within 7 days (recommended)</li>
                                        </ul>
                                    </div>

                                    <!-- Admin Actions -->
                                    <div style='text-align: center; margin: 30px 0;'>
                                        <a href='" . $myUrl . "/admin/admins.php' class='verification-button' style='display: inline-block; padding: 12px 30px; background: #198754; color: white; text-decoration: none; border-radius: 6px; font-weight: 600; margin: 5px;'>
                                            Return to Admin Management
                                        </a>
                                    </div>

                                    <!-- System Information -->
                                    <div class='support-section'>
                                        <p class='support-text'>Security Audit Information:</p>
                                        <p style='color: #6c757d; font-size: 12px;'>
                                            <strong>Action:</strong> Manual 2FA Reset<br>
                                            <strong>Timestamp:</strong> " . date('Y-m-d H:i:s') . "<br>
                                            <strong>Session ID:</strong> " . session_id() . "<br>
                                            <strong>Security Level:</strong> Critical Security Change
                                        </p>
                                    </div>
                                </div>";

                // Send admin notification
                require_once("../proccess/admin_mailer.php");
                
                $success = "2FA reset successfully!";
                break;
        }
    }
}