<?php
session_start();
include('../includes/config.php');

$bonus_id = isset($_GET['bonus_id']) ? intval($_GET['bonus_id']) : 0;

$sql = "SELECT b.*, 
               u1.username as referrer_name, 
               u1.email as referrer_email,
               u1.fund_balance as referrer_balance,
               u2.username as referred_name,
               u2.email as referred_email
        FROM referral_bonuses b
        LEFT JOIN users u1 ON b.referrer_id = u1.id
        LEFT JOIN users u2 ON b.referred_id = u2.id
        WHERE b.id = $bonus_id";
        
$result = mysqli_query($conn, $sql);

if ($bonus = mysqli_fetch_assoc($result)) {
    $status = $bonus['status'];
    $status_color = $status == 'paid' ? 'success' : ($status == 'pending' ? 'warning' : 'danger');
    
    echo '<div class="row">';
    echo '<div class="col-md-6">';
    echo '<h6>Bonus Information</h6>';
    echo '<table class="table table-sm">';
    echo '<tr><td width="40%"><strong>Bonus ID:</strong></td><td>#' . $bonus['id'] . '</td></tr>';
    echo '<tr><td><strong>Amount:</strong></td><td class="fw-500">$' . number_format($bonus['amount'], 2) . '</td></tr>';
    echo '<tr><td><strong>Type:</strong></td><td>' . ucfirst(str_replace('_', ' ', $bonus['bonus_type'])) . '</td></tr>';
    echo '<tr><td><strong>Status:</strong></td><td><span class="badge bg-' . $status_color . '">' . ucfirst($status) . '</span></td></tr>';
    echo '<tr><td><strong>Created:</strong></td><td>' . date('F d, Y H:i:s', strtotime($bonus['created_at'])) . '</td></tr>';
    
    if ($bonus['paid_date']) {
        echo '<tr><td><strong>Paid Date:</strong></td><td>' . date('F d, Y H:i:s', strtotime($bonus['paid_date'])) . '</td></tr>';
    }
    
    if ($bonus['payment_method']) {
        echo '<tr><td><strong>Payment Method:</strong></td><td>' . ucfirst(str_replace('_', ' ', $bonus['payment_method'])) . '</td></tr>';
    }
    
    if ($bonus['transaction_id']) {
        echo '<tr><td><strong>Transaction ID:</strong></td><td><code>' . htmlspecialchars($bonus['transaction_id']) . '</code></td></tr>';
    }
    
    if ($bonus['description']) {
        echo '<tr><td><strong>Description:</strong></td><td>' . htmlspecialchars($bonus['description']) . '</td></tr>';
    }
    
    echo '</table>';
    echo '</div>';
    
    echo '<div class="col-md-6">';
    echo '<h6>Referrer Information</h6>';
    echo '<table class="table table-sm">';
    echo '<tr><td width="40%"><strong>Username:</strong></td><td>' . htmlspecialchars($bonus['referrer_name']) . '</td></tr>';
    echo '<tr><td><strong>Email:</strong></td><td>' . htmlspecialchars($bonus['referrer_email']) . '</td></tr>';
    echo '<tr><td><strong>User ID:</strong></td><td>' . $bonus['referrer_id'] . '</td></tr>';
    echo '<tr><td><strong>Current Balance:</strong></td><td class="fw-500">$' . number_format($bonus['referrer_balance'], 2) . '</td></tr>';
    echo '</table>';
    
    if ($bonus['referred_id']) {
        echo '<h6 class="mt-4">Referred User Information</h6>';
        echo '<table class="table table-sm">';
        echo '<tr><td width="40%"><strong>Username:</strong></td><td>' . htmlspecialchars($bonus['referred_name']) . '</td></tr>';
        echo '<tr><td><strong>Email:</strong></td><td>' . htmlspecialchars($bonus['referred_email']) . '</td></tr>';
        echo '<tr><td><strong>User ID:</strong></td><td>' . $bonus['referred_id'] . '</td></tr>';
        echo '</table>';
    }
    echo '</div>';
    echo '</div>';
    
    if ($bonus['admin_notes']) {
        echo '<div class="mt-3">';
        echo '<h6>Admin Notes</h6>';
        echo '<div class="bg-light p-3 rounded">';
        echo nl2br(htmlspecialchars($bonus['admin_notes']));
        echo '</div>';
        echo '</div>';
    }
    
    if ($bonus['created_by']) {
        echo '<div class="mt-3">';
        echo '<small class="text-mute">Created by: ' . htmlspecialchars($bonus['created_by']) . '</small><br>';
        if ($bonus['processed_by']) {
            echo '<small class="text-mute">Processed by: ' . htmlspecialchars($bonus['processed_by']) . '</small>';
        }
        echo '</div>';
    }
} else {
    echo '<div class="alert alert-danger">Bonus not found.</div>';
}
?>