<?php
session_start();
include('../includes/config.php');

$bonus_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$sql = "SELECT rt.*, 
               referrer.username as referrer_username, referrer.email as referrer_email, referrer.phone as referrer_phone,
               referred.username as referred_username, referred.email as referred_email, referred.phone as referred_phone,
               admin.name as processed_by_name, admin.email as processed_by_email
        FROM referral_transactions rt
        LEFT JOIN users referrer ON rt.referrer_id = referrer.id
        LEFT JOIN users referred ON rt.referred_id = referred.id
        LEFT JOIN admins admin ON rt.processed_by = admin.id
        WHERE rt.id = $bonus_id";

$result = mysqli_query($conn, $sql);

if ($bonus = mysqli_fetch_assoc($result)) {
    $status_colors = array(
        'pending' => 'warning',
        'paid' => 'success',
        'rejected' => 'danger',
        'cancelled' => 'secondary'
    );
    
    $status_color = isset($status_colors[$bonus['status']]) ? $status_colors[$bonus['status']] : 'secondary';
    $created_date = date('F d, Y H:i:s', strtotime($bonus['created_at']));
    $payment_date = $bonus['payment_date'] ? date('F d, Y', strtotime($bonus['payment_date'])) : 'Not paid';
    $processed_date = $bonus['processed_at'] ? date('F d, Y H:i:s', strtotime($bonus['processed_at'])) : 'Not processed';
    
    echo '<div class="row">';
    echo '<div class="col-md-6">';
    echo '<h6>Bonus Information</h6>';
    echo '<table class="table table-sm">';
    echo '<tr><td width="40%"><strong>Bonus ID:</strong></td><td>#' . $bonus['id'] . '</td></tr>';
    echo '<tr><td><strong>Type:</strong></td><td><span class="badge bg-primary">' . str_replace('_', ' ', ucfirst($bonus['transaction_type'])) . '</span></td></tr>';
    echo '<tr><td><strong>Amount:</strong></td><td><h5 class="text-primary mb-0">$' . number_format($bonus['amount'], 2) . '</h5></td></tr>';
    echo '<tr><td><strong>Status:</strong></td><td><span class="badge bg-' . $status_color . '">' . ucfirst($bonus['status']) . '</span></td></tr>';
    echo '<tr><td><strong>Created:</strong></td><td>' . $created_date . '</td></tr>';
    if ($bonus['payment_date']) {
        echo '<tr><td><strong>Payment Date:</strong></td><td>' . $payment_date . '</td></tr>';
    }
    if ($bonus['transaction_hash']) {
        echo '<tr><td><strong>Transaction Hash:</strong></td><td><code>' . htmlspecialchars($bonus['transaction_hash']) . '</code></td></tr>';
    }
    echo '</table>';
    echo '</div>';
    
    echo '<div class="col-md-6">';
    echo '<h6>Referrer Details</h6>';
    echo '<table class="table table-sm">';
    echo '<tr><td width="40%"><strong>User ID:</strong></td><td>' . $bonus['referrer_id'] . '</td></tr>';
    echo '<tr><td><strong>Username:</strong></td><td>' . htmlspecialchars($bonus['referrer_username']) . '</td></tr>';
    echo '<tr><td><strong>Email:</strong></td><td>' . htmlspecialchars($bonus['referrer_email']) . '</td></tr>';
    if ($bonus['referrer_phone']) {
        echo '<tr><td><strong>Phone:</strong></td><td>' . htmlspecialchars($bonus['referrer_phone']) . '</td></tr>';
    }
    echo '</table>';
    
    if ($bonus['referred_id']) {
        echo '<h6 class="mt-4">Referred User Details</h6>';
        echo '<table class="table table-sm">';
        echo '<tr><td width="40%"><strong>User ID:</strong></td><td>' . $bonus['referred_id'] . '</td></tr>';
        echo '<tr><td><strong>Username:</strong></td><td>' . htmlspecialchars($bonus['referred_username']) . '</td></tr>';
        echo '<tr><td><strong>Email:</strong></td><td>' . htmlspecialchars($bonus['referred_email']) . '</td></tr>';
        if ($bonus['referred_phone']) {
            echo '<tr><td><strong>Phone:</strong></td><td>' . htmlspecialchars($bonus['referred_phone']) . '</td></tr>';
        }
        echo '</table>';
    }
    echo '</div>';
    echo '</div>';
    
    if ($bonus['description']) {
        echo '<div class="row mt-3">';
        echo '<div class="col-12">';
        echo '<h6>Description</h6>';
        echo '<div class="alert alert-light">' . htmlspecialchars($bonus['description']) . '</div>';
        echo '</div>';
        echo '</div>';
    }
    
    if ($bonus['admin_notes']) {
        echo '<div class="row mt-3">';
        echo '<div class="col-12">';
        echo '<h6>Admin Notes</h6>';
        echo '<div class="alert alert-info">' . htmlspecialchars($bonus['admin_notes']) . '</div>';
        echo '</div>';
        echo '</div>';
    }
    
    if ($bonus['processed_by']) {
        echo '<div class="row mt-3">';
        echo '<div class="col-12">';
        echo '<h6>Processing Information</h6>';
        echo '<table class="table table-sm">';
        echo '<tr><td width="40%"><strong>Processed By:</strong></td><td>' . htmlspecialchars($bonus['processed_by_name']) . ' (' . htmlspecialchars($bonus['processed_by_email']) . ')</td></tr>';
        echo '<tr><td><strong>Processed At:</strong></td><td>' . $processed_date . '</td></tr>';
        echo '</table>';
        echo '</div>';
        echo '</div>';
    }
} else {
    echo '<div class="alert alert-danger">Bonus not found</div>';
}
?>