<?php
session_start();
include('../includes/config.php');

$total_result = mysqli_query($conn, "SELECT 
    COUNT(*) as total,
    SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END) as pending,
    SUM(CASE WHEN status = 'paid' THEN 1 ELSE 0 END) as paid,
    SUM(CASE WHEN status = 'rejected' THEN 1 ELSE 0 END) as rejected,
    SUM(CASE WHEN status = 'paid' THEN amount ELSE 0 END) as total_paid,
    SUM(CASE WHEN status = 'pending' THEN amount ELSE 0 END) as pending_amount
    FROM referral_bonuses");
    
if ($stats = mysqli_fetch_assoc($total_result)) {
    echo json_encode(array(
        'success' => true,
        'total' => $stats['total'],
        'pending' => $stats['pending'],
        'paid' => $stats['paid'],
        'rejected' => $stats['rejected'],
        'total_paid' => number_format($stats['total_paid'] ?: 0, 2),
        'pending_amount' => number_format($stats['pending_amount'] ?: 0, 2)
    ));
} else {
    echo json_encode(array('success' => false));
}
?>