<?php
session_start();
include('../includes/config.php');

// Get statistics
$stats_sql = "SELECT 
                status,
                COUNT(*) as count,
                SUM(amount) as total
              FROM referral_transactions 
              GROUP BY status";
$stats_result = mysqli_query($conn, $stats_sql);

$stats = array(
    'total' => 0,
    'pending' => 0,
    'paid' => 0,
    'rejected' => 0,
    'cancelled' => 0
);

while ($stat = mysqli_fetch_assoc($stats_result)) {
    $stats['total'] += $stat['total'];
    $stats[$stat['status']] += $stat['total'];
}

echo json_encode(array(
    'success' => true,
    'total' => number_format($stats['total'], 2),
    'pending' => number_format($stats['pending'], 2),
    'paid' => number_format($stats['paid'], 2)
));
?>