<?php
session_start();
include('../includes/config.php');

// Get stats
$stats_sql = "SELECT 
    COUNT(*) as total_plans,
    SUM(is_active) as active_plans,
    SUM(CASE WHEN is_active = 0 THEN 1 ELSE 0 END) as inactive_plans,
    ROUND(AVG(subscription_fee), 2) as avg_fee,
    SUM(CASE WHEN has_machine_learning = 1 THEN 1 ELSE 0 END) as ml_plans,
    SUM(CASE WHEN has_dedicated_manager = 1 THEN 1 ELSE 0 END) as premium_plans
    FROM trading_bot_plans";
$stats_result = mysqli_query($conn, $stats_sql);
$stats = mysqli_fetch_assoc($stats_result);

echo json_encode(array(
    'success' => true,
    'total_plans' => $stats['total_plans'] ?: 0,
    'active_plans' => $stats['active_plans'] ?: 0,
    'inactive_plans' => $stats['inactive_plans'] ?: 0,
    'avg_fee' => $stats['avg_fee'] ?: '0.00',
    'ml_plans' => $stats['ml_plans'] ?: 0,
    'premium_plans' => $stats['premium_plans'] ?: 0
));
?>