<?php
session_start();
include('../includes/config.php');

$bot_id = isset($_GET['bot_id']) ? intval($_GET['bot_id']) : 0;

if ($bot_id > 0) {
    $sql = "SELECT s.*, p.plan_name, p.daily_roi_percentage, p.trading_accuracy,
                   u.username, u.email, u.phone,
                   DATEDIFF(s.subscription_end, CURDATE()) as days_remaining
            FROM user_bot_subscriptions s
            LEFT JOIN trading_bot_plans p ON s.bot_plan_id = p.id
            LEFT JOIN users u ON s.user_id = u.id
            WHERE s.id = $bot_id";
    
    $result = mysqli_query($conn, $sql);
    
    if ($row = mysqli_fetch_assoc($result)) {
        // Calculate ROI
        $roi = $row['trading_balance'] > 0 ? 
               ($row['total_profit'] / $row['trading_balance']) * 100 : 0;
        
        // Get transaction count
        $txn_sql = "SELECT COUNT(*) as total_trades FROM bot_transactions WHERE subscription_id = $bot_id";
        $txn_result = mysqli_query($conn, $txn_sql);
        $txn_data = mysqli_fetch_assoc($txn_result);
        $total_trades = $txn_data['total_trades'];
        
        // Get recent transactions
        $recent_sql = "SELECT * FROM bot_transactions 
                      WHERE subscription_id = $bot_id 
                      ORDER BY created_at DESC 
                      LIMIT 5";
        $recent_result = mysqli_query($conn, $recent_sql);
        
        echo '<div class="row">';
        echo '<div class="col-md-6">';
        echo '<h6>Bot Information</h6>';
        echo '<table class="table table-sm">';
        echo '<tr><td><strong>Bot ID:</strong></td><td>' . $row['id'] . '</td></tr>';
        echo '<tr><td><strong>Plan:</strong></td><td>' . htmlspecialchars($row['plan_name']) . '</td></tr>';
        echo '<tr><td><strong>Status:</strong></td><td><span class="badge bg-' . ($row['status'] == 'active' ? 'success' : 'warning') . '">' . ucfirst($row['status']) . '</span></td></tr>';
        echo '<tr><td><strong>Trading Balance:</strong></td><td>$' . number_format($row['trading_balance'], 2) . '</td></tr>';
        echo '<tr><td><strong>Total Profit:</strong></td><td class="text-success fw-500">$' . number_format($row['total_profit'], 2) . '</td></tr>';
        echo '<tr><td><strong>Success Rate:</strong></td><td>' . number_format($row['success_rate'], 1) . '%</td></tr>';
        echo '<tr><td><strong>ROI:</strong></td><td><span class="badge bg-' . ($roi > 0 ? 'success' : 'danger') . '">' . number_format($roi, 2) . '%</span></td></tr>';
        echo '</table>';
        echo '</div>';
        
        echo '<div class="col-md-6">';
        echo '<h6>User Information</h6>';
        echo '<table class="table table-sm">';
        echo '<tr><td><strong>Username:</strong></td><td>' . htmlspecialchars($row['username']) . '</td></tr>';
        echo '<tr><td><strong>Email:</strong></td><td>' . htmlspecialchars($row['email']) . '</td></tr>';
        echo '<tr><td><strong>Phone:</strong></td><td>' . htmlspecialchars($row['phone']) . '</td></tr>';
        echo '<tr><td><strong>Subscription Start:</strong></td><td>' . date('M d, Y', strtotime($row['subscription_start'])) . '</td></tr>';
        echo '<tr><td><strong>Subscription End:</strong></td><td>' . date('M d, Y', strtotime($row['subscription_end'])) . '</td></tr>';
        echo '<tr><td><strong>Days Remaining:</strong></td><td>' . $row['days_remaining'] . ' days</td></tr>';
        echo '</table>';
        echo '</div>';
        echo '</div>';
        
        echo '<div class="row mt-3">';
        echo '<div class="col-12">';
        echo '<h6>Recent Transactions</h6>';
        if (mysqli_num_rows($recent_result) > 0) {
            echo '<div class="table-responsive">';
            echo '<table class="table table-sm">';
            echo '<thead><tr><th>Date</th><th>Type</th><th>Amount</th><th>Description</th></tr></thead>';
            echo '<tbody>';
            while ($txn = mysqli_fetch_assoc($recent_result)) {
                $type_color = $txn['transaction_type'] == 'profit' ? 'success' : 'danger';
                echo '<tr>';
                echo '<td>' . date('M d, H:i', strtotime($txn['created_at'])) . '</td>';
                echo '<td><span class="badge bg-' . $type_color . '">' . ucfirst($txn['transaction_type']) . '</span></td>';
                echo '<td class="fw-500">$' . number_format($txn['amount'], 2) . '</td>';
                echo '<td><small>' . htmlspecialchars($txn['description']) . '</small></td>';
                echo '</tr>';
            }
            echo '</tbody>';
            echo '</table>';
            echo '</div>';
        } else {
            echo '<p class="text-mute">No transactions yet</p>';
        }
        echo '</div>';
        echo '</div>';
    } else {
        echo '<div class="alert alert-danger">Bot not found</div>';
    }
} else {
    echo '<div class="alert alert-danger">Invalid bot ID</div>';
}
?>