<?php
session_start();
include('../includes/config.php');

$deposit_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$sql = "SELECT d.*, u.username, u.email, u.phone, u.fund_balance, u.available_balance,
               a.name as admin_name, a.email as admin_email
        FROM deposits d 
        LEFT JOIN users u ON d.user_id = u.id 
        LEFT JOIN admins a ON d.confirmed_by = a.id 
        WHERE d.id = $deposit_id";

$result = mysqli_query($conn, $sql);

if ($deposit = mysqli_fetch_assoc($result)) {
    $status_color = $deposit['status'] == 'pending' ? 'warning' : 
                    ($deposit['status'] == 'confirmed' ? 'success' : 'danger');
    
    $created_date = date('F d, Y H:i:s', strtotime($deposit['created_at']));
    $confirmed_date = $deposit['confirmed_at'] ? date('F d, Y H:i:s', strtotime($deposit['confirmed_at'])) : 'Not confirmed';
    
    echo '<div class="row">';
    echo '<div class="col-md-6">';
    echo '<h6>Deposit Information</h6>';
    echo '<table class="table table-sm">';
    echo '<tr><td width="40%"><strong>Deposit ID:</strong></td><td>' . $deposit['id'] . '</td></tr>';
    echo '<tr><td><strong>Amount:</strong></td><td><span class="fw-500">$' . number_format($deposit['amount'], 2) . '</span></td></tr>';
    echo '<tr><td><strong>Status:</strong></td><td><span class="badge bg-' . $status_color . '">' . ucfirst($deposit['status']) . '</span></td></tr>';
    
    if ($deposit['transaction_hash']) {
        echo '<tr><td><strong>Transaction Hash:</strong></td><td><code onclick="showFullHash(\'' . htmlspecialchars($deposit['transaction_hash']) . '\')" style="cursor:pointer;">' . 
             htmlspecialchars(substr($deposit['transaction_hash'], 0, 30) . '...') . '</code></td></tr>';
    }
    
    echo '<tr><td><strong>Created:</strong></td><td>' . $created_date . '</td></tr>';
    
    if ($deposit['confirmed_by']) {
        echo '<tr><td><strong>Confirmed By:</strong></td><td>' . htmlspecialchars($deposit['admin_name']) . '</td></tr>';
        echo '<tr><td><strong>Confirmed At:</strong></td><td>' . $confirmed_date . '</td></tr>';
    }
    
    if ($deposit['note']) {
        echo '<tr><td><strong>Note:</strong></td><td>' . htmlspecialchars($deposit['note']) . '</td></tr>';
    }
    
    echo '</table>';
    echo '</div>';
    
    echo '<div class="col-md-6">';
    echo '<h6>User Information</h6>';
    echo '<table class="table table-sm">';
    echo '<tr><td width="40%"><strong>Username:</strong></td><td>' . htmlspecialchars($deposit['username']) . '</td></tr>';
    echo '<tr><td><strong>Email:</strong></td><td>' . htmlspecialchars($deposit['email']) . '</td></tr>';
    echo '<tr><td><strong>Phone:</strong></td><td>' . htmlspecialchars($deposit['phone']) . '</td></tr>';
    echo '<tr><td><strong>Current Balance:</strong></td><td>$' . number_format($deposit['fund_balance'], 2) . '</td></tr>';
    echo '<tr><td><strong>Available Balance:</strong></td><td>$' . number_format($deposit['available_balance'], 2) . '</td></tr>';
    echo '</table>';
    
    // Show receipt if available
    if ($deposit['receipt_path']) {
        echo '<div class="mt-3">';
        echo '<h6>Receipt</h6>';
        echo '<a href="' . $deposit['receipt_path'] . '" target="_blank" class="btn btn-sm btn-primary">';
        echo '<i class="fas fa-receipt me-1"></i> View Receipt';
        echo '</a>';
        echo '</div>';
    }
    
    echo '</div>';
    echo '</div>';
} else {
    echo '<div class="alert alert-danger">Deposit not found</div>';
}
?>