<?php
session_start();
include('../includes/config.php');

// Get counts for stats
$count_result = mysqli_query($conn, "SELECT status, COUNT(*) as count, COALESCE(SUM(amount), 0) as total FROM deposits GROUP BY status");
$status_counts = array(
    'pending' => array('count' => 0, 'total' => 0),
    'confirmed' => array('count' => 0, 'total' => 0),
    'rejected' => array('count' => 0, 'total' => 0),
    'all' => array('count' => 0, 'total' => 0)
);

while ($row = mysqli_fetch_assoc($count_result)) {
    $status_counts[$row['status']] = array(
        'count' => $row['count'],
        'total' => number_format($row['total'], 2)
    );
    $status_counts['all']['count'] += $row['count'];
    $status_counts['all']['total'] += $row['total'];
}

$status_counts['all']['total'] = number_format($status_counts['all']['total'], 2);

echo json_encode(array(
    'success' => true,
    'pending' => $status_counts['pending'],
    'confirmed' => $status_counts['confirmed'],
    'rejected' => $status_counts['rejected'],
    'all' => $status_counts['all']
));
?>