<?php
session_start();
include('../includes/config.php');

// Get pending counts
$deposit_sql = "SELECT COUNT(*) as count FROM deposits WHERE status = 'pending'";
$deposit_result = mysqli_query($conn, $deposit_sql);
$deposit_row = mysqli_fetch_assoc($deposit_result);
$pending_deposits = $deposit_row['count'];

$withdrawal_sql = "SELECT COUNT(*) as count FROM withdrawals WHERE status = 'pending'";
$withdrawal_result = mysqli_query($conn, $withdrawal_sql);
$withdrawal_row = mysqli_fetch_assoc($withdrawal_result);
$pending_withdrawals = $withdrawal_row['count'];

$kyc_sql = "SELECT COUNT(*) as count FROM kyc_documents WHERE verification_status = 'pending'";
$kyc_result = mysqli_query($conn, $kyc_sql);
$kyc_row = mysqli_fetch_assoc($kyc_result);
$pending_kyc = $kyc_row['count'];

$ticket_sql = "SELECT COUNT(*) as count FROM support_tickets WHERE status IN ('open', 'in_progress')";
$ticket_result = mysqli_query($conn, $ticket_sql);
$ticket_row = mysqli_fetch_assoc($ticket_result);
$open_tickets = $ticket_row['count'];

// Get recent activities
$activity_sql = "SELECT * FROM admin_activities ORDER BY created_at DESC LIMIT 5";
$activity_result = mysqli_query($conn, $activity_sql);

// Output notifications
if ($pending_deposits > 0): ?>
    <li>
        <a href="pending_deposits.php">
            <div class="d-flex">
                <div class="me-10">
                    <i class="fas fa-download text-success fs-18"></i>
                </div>
                <div>
                    <p class="mb-0 fw-500">Pending Deposits</p>
                    <small class="text-mute"><?php echo $pending_deposits; ?> deposit(s) awaiting approval</small>
                    <small class="text-mute d-block"><?php echo date('H:i'); ?></small>
                </div>
            </div>
        </a>
    </li>
<?php endif; ?>

<?php if ($pending_withdrawals > 0): ?>
    <li>
        <a href="pending_withdrawals.php">
            <div class="d-flex">
                <div class="me-10">
                    <i class="fas fa-upload text-danger fs-18"></i>
                </div>
                <div>
                    <p class="mb-0 fw-500">Pending Withdrawals</p>
                    <small class="text-mute"><?php echo $pending_withdrawals; ?> withdrawal(s) to process</small>
                    <small class="text-mute d-block"><?php echo date('H:i'); ?></small>
                </div>
            </div>
        </a>
    </li>
<?php endif; ?>

<?php if ($pending_kyc > 0): ?>
    <li>
        <a href="kyc_documents.php">
            <div class="d-flex">
                <div class="me-10">
                    <i class="fas fa-id-card text-info fs-18"></i>
                </div>
                <div>
                    <p class="mb-0 fw-500">Pending KYC Documents</p>
                    <small class="text-mute"><?php echo $pending_kyc; ?> document(s) to verify</small>
                    <small class="text-mute d-block"><?php echo date('H:i'); ?></small>
                </div>
            </div>
        </a>
    </li>
<?php endif; ?>

<?php if ($open_tickets > 0): ?>
    <li>
        <a href="support_tickets.php">
            <div class="d-flex">
                <div class="me-10">
                    <i class="fas fa-ticket-alt text-warning fs-18"></i>
                </div>
                <div>
                    <p class="mb-0 fw-500">Open Support Tickets</p>
                    <small class="text-mute"><?php echo $open_tickets; ?> ticket(s) need attention</small>
                    <small class="text-mute d-block"><?php echo date('H:i'); ?></small>
                </div>
            </div>
        </a>
    </li>
<?php endif; ?>

<?php if (mysqli_num_rows($activity_result) > 0): ?>
    <li class="divider"><small class="text-mute px-3">Recent Activities</small></li>
    <?php while ($activity = mysqli_fetch_assoc($activity_result)): ?>
        <?php
        $time_ago = time_ago($activity['created_at']);
        $icon = '';
        $color = '';
        
        switch ($activity['action']) {
            case 'User Verified':
            case 'Transaction Processed':
                $icon = 'fas fa-check-circle';
                $color = 'text-success';
                break;
            case 'User Status Updated':
            case 'User Balance Updated':
                $icon = 'fas fa-edit';
                $color = 'text-primary';
                break;
            case 'User Deleted':
            case 'Transaction Rejected':
                $icon = 'fas fa-times-circle';
                $color = 'text-danger';
                break;
            default:
                $icon = 'fas fa-info-circle';
                $color = 'text-info';
        }
        ?>
        <li>
            <a href="admin_activities.php" data-id="<?php echo $activity['id']; ?>">
                <div class="d-flex">
                    <div class="me-10">
                        <i class="<?php echo $icon; ?> <?php echo $color; ?> fs-16"></i>
                    </div>
                    <div>
                        <p class="mb-0 fw-500" style="font-size: 13px;"><?php echo htmlspecialchars($activity['action']); ?></p>
                        <small class="text-mute" style="font-size: 11px;"><?php echo htmlspecialchars(substr($activity['description'], 0, 50)); ?>...</small>
                        <small class="text-mute d-block" style="font-size: 10px;"><?php echo $time_ago; ?> ago</small>
                    </div>
                </div>
            </a>
        </li>
    <?php endwhile; ?>
<?php else: ?>
    <li class="text-center py-10">
        <i class="fas fa-bell-slash fs-24 text-mute"></i>
        <p class="mt-2 mb-0 text-mute">No new notifications</p>
    </li>
<?php endif;
?>

<?php
// Helper function
function time_ago($datetime) {
    $time = strtotime($datetime);
    $now = time();
    $diff = $now - $time;
    
    if ($diff < 60) {
        return $diff . " seconds";
    } elseif ($diff < 3600) {
        return floor($diff / 60) . " minutes";
    } elseif ($diff < 86400) {
        return floor($diff / 3600) . " hours";
    } elseif ($diff < 604800) {
        return floor($diff / 86400) . " days";
    } elseif ($diff < 2592000) {
        return floor($diff / 604800) . " weeks";
    } elseif ($diff < 31536000) {
        return floor($diff / 2592000) . " months";
    } else {
        return floor($diff / 31536000) . " years";
    }
}
?>