<?php
session_start();
include('../includes/config.php');

$plan_id = isset($_GET['plan_id']) ? intval($_GET['plan_id']) : 0;

if ($plan_id > 0) {
    $sql = "SELECT * FROM trading_bot_plans WHERE id = $plan_id";
    $result = mysqli_query($conn, $sql);
    
    if ($plan = mysqli_fetch_assoc($result)) {
        $is_active = $plan['is_active'] ? 'Active' : 'Inactive';
        $status_color = $plan['is_active'] ? 'success' : 'danger';
        
        // Get subscription count
        $sub_sql = "SELECT COUNT(*) as count FROM user_bot_subscriptions WHERE bot_plan_id = $plan_id";
        $sub_result = mysqli_query($conn, $sub_sql);
        $sub_data = mysqli_fetch_assoc($sub_result);
        $subscription_count = $sub_data['count'];
        
        // Get active subscriptions
        $active_sql = "SELECT COUNT(*) as count FROM user_bot_subscriptions WHERE bot_plan_id = $plan_id AND status = 'active'";
        $active_result = mysqli_query($conn, $active_sql);
        $active_data = mysqli_fetch_assoc($active_result);
        $active_count = $active_data['count'];
        
        echo '<div class="row">';
        echo '<div class="col-md-6">';
        echo '<h6>Basic Information</h6>';
        echo '<table class="table table-sm">';
        echo '<tr><td width="40%"><strong>Plan Name:</strong></td><td>' . htmlspecialchars($plan['plan_name']) . '</td></tr>';
        echo '<tr><td><strong>Plan Slug:</strong></td><td>' . htmlspecialchars($plan['plan_slug']) . '</td></tr>';
        echo '<tr><td><strong>Status:</strong></td><td><span class="badge bg-' . $status_color . '">' . $is_active . '</span></td></tr>';
        echo '<tr><td><strong>Sort Order:</strong></td><td>' . $plan['sort_order'] . '</td></tr>';
        echo '<tr><td><strong>Created:</strong></td><td>' . date('M d, Y', strtotime($plan['created_at'])) . '</td></tr>';
        echo '<tr><td><strong>Updated:</strong></td><td>' . date('M d, Y', strtotime($plan['updated_at'])) . '</td></tr>';
        echo '</table>';
        echo '</div>';
        
        echo '<div class="col-md-6">';
        echo '<h6>Financial Information</h6>';
        echo '<table class="table table-sm">';
        echo '<tr><td width="40%"><strong>Monthly Fee:</strong></td><td>$' . number_format($plan['subscription_fee'], 2) . '</td></tr>';
        echo '<tr><td><strong>Min Balance:</strong></td><td>$' . number_format($plan['min_trading_balance'], 2) . '</td></tr>';
        echo '<tr><td><strong>Max Balance:</strong></td><td>' . ($plan['max_trading_balance'] ? '$' . number_format($plan['max_trading_balance'], 2) : 'No limit') . '</td></tr>';
        echo '<tr><td><strong>Daily ROI:</strong></td><td>' . $plan['daily_roi_percentage'] . '%</td></tr>';
        echo '<tr><td><strong>Accuracy:</strong></td><td>' . $plan['trading_accuracy'] . '%</td></tr>';
        echo '</table>';
        echo '</div>';
        echo '</div>';
        
        echo '<div class="row mt-3">';
        echo '<div class="col-md-6">';
        echo '<h6>Technical Details</h6>';
        echo '<table class="table table-sm">';
        echo '<tr><td width="40%"><strong>Markets Covered:</strong></td><td>' . $plan['markets_covered'] . '</td></tr>';
        echo '<tr><td><strong>Support Level:</strong></td><td>' . htmlspecialchars($plan['support_level']) . '</td></tr>';
        echo '<tr><td><strong>Strategy Types:</strong></td><td>' . $plan['strategy_types'] . '</td></tr>';
        echo '</table>';
        echo '</div>';
        
        echo '<div class="col-md-6">';
        echo '<h6>Features</h6>';
        echo '<div class="d-flex flex-wrap gap-2">';
        if ($plan['has_machine_learning']) echo '<span class="badge bg-info">Machine Learning</span>';
        if ($plan['has_multi_market']) echo '<span class="badge bg-primary">Multi-Market</span>';
        if ($plan['has_strategy_blending']) echo '<span class="badge bg-warning">Strategy Blending</span>';
        if ($plan['has_dedicated_manager']) echo '<span class="badge bg-danger">Dedicated Manager</span>';
        if ($plan['has_api_access']) echo '<span class="badge bg-dark">API Access</span>';
        echo '</div>';
        echo '</div>';
        echo '</div>';
        
        echo '<div class="row mt-3">';
        echo '<div class="col-12">';
        echo '<h6>Usage Statistics</h6>';
        echo '<table class="table table-sm">';
        echo '<tr><td width="40%"><strong>Total Subscriptions:</strong></td><td>' . $subscription_count . '</td></tr>';
        echo '<tr><td><strong>Active Subscriptions:</strong></td><td>' . $active_count . '</td></tr>';
        echo '<tr><td><strong>Monthly Revenue:</strong></td><td>$' . number_format($subscription_count * $plan['subscription_fee'], 2) . '</td></tr>';
        echo '</table>';
        echo '</div>';
        echo '</div>';
        
        if ($plan['plan_description']) {
            echo '<div class="mt-3">';
            echo '<h6>Description</h6>';
            echo '<div class="alert alert-light">' . nl2br(htmlspecialchars($plan['plan_description'])) . '</div>';
            echo '</div>';
        }
    } else {
        echo '<div class="alert alert-danger">Plan not found.</div>';
    }
} else {
    echo '<div class="alert alert-danger">Invalid plan ID.</div>';
}
?>