<?php
session_start();
include('../includes/config.php');

$filter = isset($_GET['filter']) ? $_GET['filter'] : 'all';

$sql = "SELECT * FROM admin_activities WHERE 1=1";

// Apply filters
if ($filter == 'today') {
    $today = date('Y-m-d');
    $sql .= " AND DATE(created_at) = '$today'";
} elseif ($filter == 'this_week') {
    $week_start = date('Y-m-d', strtotime('monday this week'));
    $week_end = date('Y-m-d', strtotime('sunday this week'));
    $sql .= " AND DATE(created_at) BETWEEN '$week_start' AND '$week_end'";
}

$sql .= " ORDER BY created_at DESC LIMIT 10";

$result = mysqli_query($conn, $sql);

if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $admin_name = htmlspecialchars($row['admin_name']);
        $admin_role = $row['admin_role'];
        $action = htmlspecialchars($row['action']);
        $description = htmlspecialchars($row['description']);
        $module = $row['module'];
        $created_at = date('M d, H:i', strtotime($row['created_at']));
        
        // Role badge colors
        $role_colors = array(
            'super_admin' => 'danger',
            'admin' => 'primary',
            'support' => 'info'
        );
        
        $role_color = isset($role_colors[$admin_role]) ? $role_colors[$admin_role] : 'secondary';
        
        echo "<tr>";
        echo "<td>";
        echo "<div class='d-flex align-items-center'>";
        echo "<div class='me-10'>";
        echo "<div class='bg-$role_color rounded-circle w-40 h-40 d-flex align-items-center justify-content-center'>";
        echo "<i class='fas fa-user-shield text-white'></i>";
        echo "</div>";
        echo "</div>";
        echo "<div>";
        echo "<p class='mb-0 fw-500'>$admin_name</p>";
        echo "<small class='text-mute'><span class='badge bg-$role_color'>$admin_role</span></small>";
        echo "</div>";
        echo "</div>";
        echo "</td>";
        echo "<td><span class='badge bg-light text-dark'>$action</span></td>";
        echo "<td><small>$description</small></td>";
        echo "<td><span class='badge bg-secondary'>$module</span></td>";
        echo "<td><small class='text-mute'>$created_at</small></td>";
        echo "</tr>";
    }
} else {
    echo "<tr><td colspan='5' class='text-center py-20'>No recent activities found</td></tr>";
}
?>