<?php
session_start();
include('../includes/config.php');

$sql = "SELECT t.*, u.username, u.email 
        FROM transactions t 
        LEFT JOIN users u ON t.user_id = u.id 
        ORDER BY t.created_at DESC 
        LIMIT 10";
$result = mysqli_query($conn, $sql);

if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $id = $row['id'];
        $username = htmlspecialchars($row['username']);
        $type = $row['type'];
        $amount = number_format($row['amount'], 2);
        $status = $row['status'];
        $date = date('M d, H:i', strtotime($row['created_at']));
        
        // Status badge colors
        $status_colors = array(
            'pending' => 'warning',
            'completed' => 'success',
            'processing' => 'info',
            'failed' => 'danger',
            'cancelled' => 'secondary'
        );
        
        $status_color = isset($status_colors[$status]) ? $status_colors[$status] : 'secondary';
        
        // Type icons
        $type_icons = array(
            'deposit' => 'fas fa-download text-success',
            'withdrawal' => 'fas fa-upload text-danger',
            'profit' => 'fas fa-chart-line text-info',
            'fee' => 'fas fa-file-invoice text-warning'
        );
        
        $type_icon = isset($type_icons[$type]) ? $type_icons[$type] : 'fas fa-exchange-alt';
        
        echo "<tr class='view-transaction' data-id='$id'>";
        echo "<td>";
        echo "<div class='d-flex align-items-center'>";
        echo "<div class='me-10'>";
        echo "<i class='$type_icon fs-16'></i>";
        echo "</div>";
        echo "<div>";
        echo "<p class='mb-0 fw-500'>$username</p>";
        echo "<small class='text-mute'>$type</small>";
        echo "</div>";
        echo "</div>";
        echo "</td>";
        echo "<td><span class='badge bg-$status_color'>$status</span></td>";
        echo "<td class='fw-500'>$$amount</td>";
        echo "<td>$date</td>";
        echo "<td><button class='btn btn-sm btn-light'><i class='fas fa-eye'></i></button></td>";
        echo "</tr>";
    }
} else {
    echo "<tr><td colspan='5' class='text-center py-20'>No recent transactions</td></tr>";
}
?>