<?php
session_start();
include('../includes/config.php');

$sql = "SELECT id, username, email, status, fund_balance, registration_date 
        FROM users 
        ORDER BY registration_date DESC 
        LIMIT 10";
$result = mysqli_query($conn, $sql);

if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $id = $row['id'];
        $username = htmlspecialchars($row['username']);
        $email = htmlspecialchars($row['email']);
        $status = $row['status'];
        $balance = number_format($row['fund_balance'], 2);
        $joined = date('M d, Y', strtotime($row['registration_date']));
        
        // Status badge colors
        $status_colors = array(
            'verified' => 'success',
            'pending' => 'warning',
            'rejected' => 'danger'
        );
        
        $status_color = isset($status_colors[$status]) ? $status_colors[$status] : 'secondary';
        
        echo "<tr class='view-user' data-id='$id'>";
        echo "<td>";
        echo "<div class='d-flex align-items-center'>";
        echo "<div class='me-10'>";
        echo "<div class='bg-primary rounded-circle w-40 h-40 d-flex align-items-center justify-content-center'>";
        echo "<i class='fas fa-user text-white'></i>";
        echo "</div>";
        echo "</div>";
        echo "<div>";
        echo "<p class='mb-0 fw-500'>$username</p>";
        echo "<small class='text-mute'>$email</small>";
        echo "</div>";
        echo "</div>";
        echo "</td>";
        echo "<td><span class='badge bg-$status_color'>$status</span></td>";
        echo "<td class='fw-500'>$$balance</td>";
        echo "<td>$joined</td>";
        echo "<td><button class='btn btn-sm btn-light'><i class='fas fa-eye'></i></button></td>";
        echo "</tr>";
    }
} else {
    echo "<tr><td colspan='5' class='text-center py-20'>No recent users</td></tr>";
}
?>