<?php
session_start();
include('../includes/config.php');

// Get stats
$stats_sql = "SELECT 
              COUNT(DISTINCT r.referred_by) as active_referrers,
              COUNT(r.id) as total_referrals,
              COUNT(DISTINCT r.user_id) as users_with_code,
              COALESCE(SUM(rt.amount), 0) as total_bonus_paid
              FROM referrals r
              LEFT JOIN referral_transactions rt ON rt.transaction_type IN ('signup_bonus', 'bot_bonus')";
$stats_result = mysqli_query($conn, $stats_sql);
$stats = mysqli_fetch_assoc($stats_result);

echo json_encode(array(
    'success' => true,
    'active_referrers' => $stats['active_referrers'] ?: 0,
    'total_referrals' => $stats['total_referrals'] ?: 0,
    'users_with_code' => $stats['users_with_code'] ?: 0,
    'total_bonus_paid' => number_format($stats['total_bonus_paid'] ?: 0, 2)
));
?>