<?php
session_start();
include('../includes/config.php');

// Get subscription stats
$stats_sql = "SELECT 
                COUNT(*) as total,
                SUM(CASE WHEN status = 'active' THEN 1 ELSE 0 END) as active,
                SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END) as pending,
                SUM(CASE WHEN status = 'expired' THEN 1 ELSE 0 END) as expired,
                SUM(CASE WHEN status = 'cancelled' THEN 1 ELSE 0 END) as cancelled,
                COALESCE(SUM(trading_balance), 0) as total_balance,
                COALESCE(SUM(total_profit), 0) as total_profit
              FROM user_bot_subscriptions";
$stats_result = mysqli_query($conn, $stats_sql);
$stats = mysqli_fetch_assoc($stats);

echo json_encode(array(
    'success' => true,
    'total' => $stats['total'] ?: 0,
    'active' => $stats['active'] ?: 0,
    'pending' => $stats['pending'] ?: 0,
    'expired' => $stats['expired'] ?: 0,
    'total_balance' => number_format($stats['total_balance'] ?: 0, 2),
    'total_profit' => number_format($stats['total_profit'] ?: 0, 2)
));
?>