<?php
session_start();
include('../includes/config.php');

$ticket_id = isset($_GET['ticket_id']) ? intval($_GET['ticket_id']) : 0;

if ($ticket_id > 0) {
    // Get ticket details
    $sql = "SELECT t.*, u.username, u.email, u.phone, a.name as assigned_admin 
            FROM support_tickets t 
            LEFT JOIN users u ON t.user_id = u.id 
            LEFT JOIN admins a ON t.assigned_to = a.id 
            WHERE t.id = $ticket_id";
    $result = mysqli_query($conn, $sql);
    $ticket = mysqli_fetch_assoc($result);
    
    if ($ticket) {
        // Get ticket replies
        $replies_sql = "SELECT r.*, 
                       CASE 
                           WHEN r.is_admin_reply = 1 THEN (SELECT name FROM admins WHERE id = r.user_id)
                           ELSE (SELECT username FROM users WHERE id = r.user_id)
                       END as author_name,
                       CASE 
                           WHEN r.is_admin_reply = 1 THEN 'Admin'
                           ELSE 'User'
                       END as author_type
                       FROM ticket_replies r 
                       WHERE r.ticket_id = $ticket_id 
                       ORDER BY r.created_at";
        $replies_result = mysqli_query($conn, $replies_sql);
        
        // Status colors
        $status_colors = array(
            'open' => 'danger',
            'in_progress' => 'warning',
            'resolved' => 'success',
            'closed' => 'secondary'
        );
        
        // Priority colors
        $priority_colors = array(
            'urgent' => 'danger',
            'high' => 'warning',
            'medium' => 'info',
            'low' => 'success'
        );
        
        $status_color = isset($status_colors[$ticket['status']]) ? $status_colors[$ticket['status']] : 'secondary';
        $priority_color = isset($priority_colors[$ticket['priority']]) ? $priority_colors[$ticket['priority']] : 'secondary';
        
        echo '<input type="hidden" id="replyTicketId" value="' . $ticket_id . '">';
        
        echo '<div class="row">';
        echo '<div class="col-md-6">';
        echo '<div class="mb-3">';
        echo '<h5>Ticket Information</h5>';
        echo '<table class="table table-sm">';
        echo '<tr><td width="30%"><strong>Ticket #:</strong></td><td>' . $ticket['ticket_number'] . '</td></tr>';
        echo '<tr><td><strong>Subject:</strong></td><td>' . htmlspecialchars($ticket['subject']) . '</td></tr>';
        echo '<tr><td><strong>Category:</strong></td><td>' . ucfirst(str_replace('_', ' ', $ticket['category'])) . '</td></tr>';
        echo '<tr><td><strong>Priority:</strong></td><td><span class="badge bg-' . $priority_color . '">' . ucfirst($ticket['priority']) . '</span></td></tr>';
        echo '<tr><td><strong>Status:</strong></td><td><span class="badge bg-' . $status_color . '">' . ucfirst(str_replace('_', ' ', $ticket['status'])) . '</span></td></tr>';
        echo '<tr><td><strong>Created:</strong></td><td>' . date('F d, Y H:i:s', strtotime($ticket['created_at'])) . '</td></tr>';
        echo '<tr><td><strong>Updated:</strong></td><td>' . ($ticket['updated_at'] ? date('F d, Y H:i:s', strtotime($ticket['updated_at'])) : 'Never') . '</td></tr>';
        echo '</table>';
        echo '</div>';
        echo '</div>';
        
        echo '<div class="col-md-6">';
        echo '<div class="mb-3">';
        echo '<h5>User Information</h5>';
        echo '<table class="table table-sm">';
        echo '<tr><td width="30%"><strong>User:</strong></td><td>' . htmlspecialchars($ticket['username']) . '</td></tr>';
        echo '<tr><td><strong>Email:</strong></td><td>' . htmlspecialchars($ticket['email']) . '</td></tr>';
        if ($ticket['phone']) {
            echo '<tr><td><strong>Phone:</strong></td><td>' . htmlspecialchars($ticket['phone']) . '</td></tr>';
        }
        if ($ticket['assigned_admin']) {
            echo '<tr><td><strong>Assigned To:</strong></td><td>' . $ticket['assigned_admin'] . '</td></tr>';
        }
        echo '</table>';
        echo '</div>';
        echo '</div>';
        echo '</div>';
        
        echo '<div class="mb-3">';
        echo '<h5>Description</h5>';
        echo '<div class="alert alert-light">' . nl2br(htmlspecialchars($ticket['description'])) . '</div>';
        echo '</div>';
        
        echo '<div class="mb-3">';
        echo '<h5>Conversation</h5>';
        
        if (mysqli_num_rows($replies_result) > 0) {
            while ($reply = mysqli_fetch_assoc($replies_result)) {
                $author_class = $reply['author_type'] == 'Admin' ? 'admin' : 'user';
                $author_badge = $reply['author_type'] == 'Admin' ? 'success' : 'secondary';
                
                echo '<div class="ticket-reply ' . $author_class . ' mb-3 p-3">';
                echo '<div class="d-flex justify-content-between mb-2">';
                echo '<strong><span class="badge bg-' . $author_badge . '">' . $reply['author_type'] . '</span> ' . htmlspecialchars($reply['author_name']) . '</strong>';
                echo '<small class="text-mute">' . date('M d, Y H:i', strtotime($reply['created_at'])) . '</small>';
                echo '</div>';
                echo '<div>' . nl2br(htmlspecialchars($reply['message'])) . '</div>';
                echo '</div>';
            }
        } else {
            echo '<div class="alert alert-info">No replies yet.</div>';
        }
        echo '</div>';
    } else {
        echo '<div class="alert alert-danger">Ticket not found.</div>';
    }
} else {
    echo '<div class="alert alert-danger">Invalid ticket ID.</div>';
}
?>