<?php
session_start();
include('../includes/config.php');

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$sql = "SELECT t.*, u.username, u.email, u.phone 
        FROM transactions t 
        LEFT JOIN users u ON t.user_id = u.id 
        WHERE t.id = $id";
$result = mysqli_query($conn, $sql);

if ($row = mysqli_fetch_assoc($result)) {
    $type = $row['type'];
    $amount = number_format($row['amount'], 2);
    $status = $row['status'];
    $date = date('F d, Y H:i:s', strtotime($row['created_at']));
    $description = htmlspecialchars($row['description']);
    $username = htmlspecialchars($row['username']);
    $email = htmlspecialchars($row['email']);
    $phone = htmlspecialchars($row['phone']);
    
    echo "<input type='hidden' id='transactionStatus' value='$status'>";
    
    echo "<div class='row'>";
    echo "<div class='col-md-6'>";
    echo "<h6>Transaction Details</h6>";
    echo "<table class='table table-sm'>";
    echo "<tr><td><strong>Type:</strong></td><td>$type</td></tr>";
    echo "<tr><td><strong>Amount:</strong></td><td>$$amount</td></tr>";
    echo "<tr><td><strong>Status:</strong></td><td><span class='badge bg-" . ($status == 'pending' ? 'warning' : 'success') . "'>$status</span></td></tr>";
    echo "<tr><td><strong>Date:</strong></td><td>$date</td></tr>";
    if ($description) {
        echo "<tr><td><strong>Description:</strong></td><td>$description</td></tr>";
    }
    echo "</table>";
    echo "</div>";
    
    echo "<div class='col-md-6'>";
    echo "<h6>User Details</h6>";
    echo "<table class='table table-sm'>";
    echo "<tr><td><strong>Username:</strong></td><td>$username</td></tr>";
    echo "<tr><td><strong>Email:</strong></td><td>$email</td></tr>";
    if ($phone) {
        echo "<tr><td><strong>Phone:</strong></td><td>$phone</td></tr>";
    }
    echo "</table>";
    echo "</div>";
    echo "</div>";
} else {
    echo "<div class='alert alert-danger'>Transaction not found</div>";
}
?>