<?php
session_start();
include('includes/config.php');

// Get filter parameters
$format = isset($_GET['format']) ? $_GET['format'] : 'csv';
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : '';
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : '';
$admin = isset($_GET['admin']) ? $_GET['admin'] : '';
$role = isset($_GET['role']) ? $_GET['role'] : '';
$module = isset($_GET['module']) ? $_GET['module'] : '';
$action = isset($_GET['action']) ? $_GET['action'] : '';
$ip = isset($_GET['ip']) ? $_GET['ip'] : '';

// Build query
$sql = "SELECT * FROM admin_activities WHERE 1=1";

if ($date_from && $date_to) {
    $sql .= " AND DATE(created_at) BETWEEN '$date_from' AND '$date_to'";
} elseif ($date_from) {
    $sql .= " AND DATE(created_at) >= '$date_from'";
} elseif ($date_to) {
    $sql .= " AND DATE(created_at) <= '$date_to'";
}

if ($admin) {
    $sql .= " AND admin_name LIKE '%$admin%'";
}

if ($role) {
    $sql .= " AND admin_role = '$role'";
}

if ($module) {
    $sql .= " AND module = '$module'";
}

if ($action) {
    $sql .= " AND action LIKE '%$action%'";
}

if ($ip) {
    $sql .= " AND ip_address LIKE '%$ip%'";
}

$sql .= " ORDER BY created_at DESC";
$result = mysqli_query($conn, $sql);

if ($format == 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="activity_report_' . date('Y-m-d_H-i') . '.csv"');
    
    $output = fopen('php://output', 'w');
    
    // Add headers
    fputcsv($output, array('ID', 'Admin ID', 'Admin Name', 'Admin Role', 'Action', 'Description', 'Module', 'IP Address', 'User Agent', 'Affected ID', 'Affected Table', 'Timestamp'));
    
    // Add data
    while ($row = mysqli_fetch_assoc($result)) {
        fputcsv($output, array(
            $row['id'],
            $row['admin_id'],
            $row['admin_name'],
            $row['admin_role'],
            $row['action'],
            $row['description'],
            $row['module'],
            $row['ip_address'],
            $row['user_agent'],
            $row['affected_id'],
            $row['affected_table'],
            $row['created_at']
        ));
    }
    
    fclose($output);
    
} elseif ($format == 'excel') {
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="activity_report_' . date('Y-m-d_H-i') . '.xls"');
    
    echo '<table border="1">';
    echo '<tr>';
    echo '<th>ID</th>';
    echo '<th>Admin Name</th>';
    echo '<th>Admin Role</th>';
    echo '<th>Action</th>';
    echo '<th>Description</th>';
    echo '<th>Module</th>';
    echo '<th>IP Address</th>';
    echo '<th>Affected ID</th>';
    echo '<th>Timestamp</th>';
    echo '</tr>';
    
    while ($row = mysqli_fetch_assoc($result)) {
        echo '<tr>';
        echo '<td>' . $row['id'] . '</td>';
        echo '<td>' . $row['admin_name'] . '</td>';
        echo '<td>' . $row['admin_role'] . '</td>';
        echo '<td>' . $row['action'] . '</td>';
        echo '<td>' . $row['description'] . '</td>';
        echo '<td>' . $row['module'] . '</td>';
        echo '<td>' . $row['ip_address'] . '</td>';
        echo '<td>' . $row['affected_id'] . '</td>';
        echo '<td>' . $row['created_at'] . '</td>';
        echo '</tr>';
    }
    
    echo '</table>';
    
} elseif ($format == 'pdf') {
    // Simple PDF output (for production, use a PDF library)
    header('Content-Type: application/pdf');
    header('Content-Disposition: attachment; filename="activity_report_' . date('Y-m-d_H-i') . '.pdf"');
    
    $html = '<h1>Admin Activity Report</h1>';
    $html .= '<p>Generated on: ' . date('Y-m-d H:i:s') . '</p>';
    $html .= '<p>Filters Applied: ';
    $html .= $date_from ? 'From: ' . $date_from . ' ' : '';
    $html .= $date_to ? 'To: ' . $date_to . ' ' : '';
    $html .= $admin ? 'Admin: ' . $admin . ' ' : '';
    $html .= $role ? 'Role: ' . $role . ' ' : '';
    $html .= '</p>';
    $html .= '<table border="1" cellpadding="5" cellspacing="0">';
    $html .= '<tr>';
    $html .= '<th>ID</th>';
    $html .= '<th>Admin</th>';
    $html .= '<th>Role</th>';
    $html .= '<th>Action</th>';
    $html .= '<th>Module</th>';
    $html .= '<th>IP</th>';
    $html .= '<th>Time</th>';
    $html .= '</tr>';
    
    while ($row = mysqli_fetch_assoc($result)) {
        $html .= '<tr>';
        $html .= '<td>' . $row['id'] . '</td>';
        $html .= '<td>' . $row['admin_name'] . '</td>';
        $html .= '<td>' . $row['admin_role'] . '</td>';
        $html .= '<td>' . $row['action'] . '</td>';
        $html .= '<td>' . $row['module'] . '</td>';
        $html .= '<td>' . $row['ip_address'] . '</td>';
        $html .= '<td>' . $row['created_at'] . '</td>';
        $html .= '</tr>';
    }
    
    $html .= '</table>';
    
    echo $html;
}
?>