<?php
session_start();
include('includes/config.php');

$date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');
$format = isset($_GET['format']) ? $_GET['format'] : 'pdf';

// Get daily stats (same function as daily_report.php)
function getDailyStats($date) {
    global $conn;
    
    $stats = array();
    
    // ... (copy the same getDailyStats function from daily_report.php)
    // For brevity, I'm showing a simplified version
    
    $sql = "SELECT COUNT(*) as total FROM users";
    $result = mysqli_query($conn, $sql);
    $stats['total_users'] = mysqli_fetch_assoc($result)['total'];
    
    $sql = "SELECT COUNT(*) as total FROM users WHERE DATE(registration_date) = '$date'";
    $result = mysqli_query($conn, $sql);
    $stats['new_users'] = mysqli_fetch_assoc($result)['total'];
    
    // ... add other queries
    
    return $stats;
}

$stats = getDailyStats($date);

if ($format == 'pdf') {
    header('Content-Type: application/pdf');
    header('Content-Disposition: attachment; filename="daily_report_' . $date . '.pdf"');
    
    $html = '<h1>Daily Report - ' . date('F d, Y', strtotime($date)) . '</h1>';
    $html .= '<h3>Platform Statistics</h3>';
    $html .= '<table border="1" cellpadding="5">';
    $html .= '<tr><th>Metric</th><th>Value</th></tr>';
    $html .= '<tr><td>Total Users</td><td>' . number_format($stats['total_users']) . '</td></tr>';
    $html .= '<tr><td>New Users Today</td><td>' . number_format($stats['new_users']) . '</td></tr>';
    // ... add more rows
    $html .= '</table>';
    
    echo $html;
    
} elseif ($format == 'excel') {
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="daily_report_' . $date . '.xls"');
    
    echo '<table border="1">';
    echo '<tr><th>Metric</th><th>Value</th></tr>';
    echo '<tr><td>Total Users</td><td>' . number_format($stats['total_users']) . '</td></tr>';
    echo '<tr><td>New Users Today</td><td>' . number_format($stats['new_users']) . '</td></tr>';
    // ... add more rows
    echo '</table>';
    
} elseif ($format == 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="daily_report_' . $date . '.csv"');
    
    $output = fopen('php://output', 'w');
    fputcsv($output, array('Metric', 'Value'));
    fputcsv($output, array('Total Users', $stats['total_users']));
    fputcsv($output, array('New Users Today', $stats['new_users']));
    // ... add more rows
    fclose($output);
}
?>