<?php
session_start();
include('includes/config.php');

// Get filter parameters
$format = isset($_GET['format']) ? $_GET['format'] : 'csv';
$status = isset($_GET['status']) ? $_GET['status'] : '';
$search = isset($_GET['search']) ? $_GET['search'] : '';
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : '';
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : '';

// Build query
$sql = "SELECT w.*, u.username, u.email, u.phone 
        FROM withdrawals w 
        LEFT JOIN users u ON w.user_id = u.id 
        WHERE 1=1";

if ($status) {
    $sql .= " AND w.status = '$status'";
}

if ($search) {
    $sql .= " AND (u.username LIKE '%$search%' OR u.email LIKE '%$search%' OR w.destination_address LIKE '%$search%' OR w.transaction_hash LIKE '%$search%')";
}

if ($date_from && $date_to) {
    $sql .= " AND DATE(w.created_at) BETWEEN '$date_from' AND '$date_to'";
} elseif ($date_from) {
    $sql .= " AND DATE(w.created_at) >= '$date_from'";
} elseif ($date_to) {
    $sql .= " AND DATE(w.created_at) <= '$date_to'";
}

$sql .= " ORDER BY w.id DESC";
$result = mysqli_query($conn, $sql);

if ($format == 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="withdrawals_' . date('Y-m-d') . '.csv"');
    
    $output = fopen('php://output', 'w');
    
    // Add headers
    fputcsv($output, array('ID', 'User', 'Email', 'Amount', 'Fee', 'Total', 'Status', 'Destination Address', 'Transaction Hash', 'Created', 'Processed'));
    
    // Add data
    while ($row = mysqli_fetch_assoc($result)) {
        fputcsv($output, array(
            $row['id'],
            $row['username'],
            $row['email'],
            $row['amount'],
            $row['fee'],
            $row['total_amount'],
            $row['status'],
            $row['destination_address'],
            $row['transaction_hash'] ?: 'N/A',
            $row['created_at'],
            $row['processed_at'] ?: 'N/A'
        ));
    }
    
    fclose($output);
    
} elseif ($format == 'excel') {
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="withdrawals_' . date('Y-m-d') . '.xls"');
    
    echo '<table border="1">';
    echo '<tr>';
    echo '<th>ID</th>';
    echo '<th>User</th>';
    echo '<th>Email</th>';
    echo '<th>Amount</th>';
    echo '<th>Fee</th>';
    echo '<th>Total</th>';
    echo '<th>Status</th>';
    echo '<th>Destination Address</th>';
    echo '<th>Transaction Hash</th>';
    echo '<th>Created</th>';
    echo '<th>Processed</th>';
    echo '</tr>';
    
    while ($row = mysqli_fetch_assoc($result)) {
        echo '<tr>';
        echo '<td>' . $row['id'] . '</td>';
        echo '<td>' . $row['username'] . '</td>';
        echo '<td>' . $row['email'] . '</td>';
        echo '<td>' . $row['amount'] . '</td>';
        echo '<td>' . $row['fee'] . '</td>';
        echo '<td>' . $row['total_amount'] . '</td>';
        echo '<td>' . $row['status'] . '</td>';
        echo '<td>' . $row['destination_address'] . '</td>';
        echo '<td>' . ($row['transaction_hash'] ?: 'N/A') . '</td>';
        echo '<td>' . $row['created_at'] . '</td>';
        echo '<td>' . ($row['processed_at'] ?: 'N/A') . '</td>';
        echo '</tr>';
    }
    
    echo '</table>';
}
?>