<?php
// Authentication check for all admin pages
session_start();

// Check if user is logged in
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    // Redirect to login page
    header('Location: login.php');
    exit();
}

// Check session timeout (30 minutes)
$session_timeout = 1800; // 30 minutes in seconds
if (isset($_SESSION['LAST_ACTIVITY']) && (time() - $_SESSION['LAST_ACTIVITY'] > $session_timeout)) {
    // Last request was more than 30 minutes ago
    session_unset();
    session_destroy();
    header('Location: login.php?error=Session expired. Please login again.');
    exit();
}

// Update last activity time
$_SESSION['LAST_ACTIVITY'] = time();

// Check admin role permissions (optional)
$allowed_roles = ['super_admin', 'admin', 'support'];
if (!in_array($_SESSION['admin_role'], $allowed_roles)) {
    header('Location: login.php?error=Access denied. Invalid role.');
    exit();
}

// Add to every protected page by including this file at the top
?>