<?php

// Idle timeout in seconds (30 minutes)
$idle_timeout = 100;

// Check if user is logged in
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit();
}

// Check if we're coming from lock screen
if (isset($_SESSION['locked']) && $_SESSION['locked'] === true) {
    // Don't redirect to lock screen if already there
    unset($_SESSION['locked']);
} else {
    // Check last activity time
    if (isset($_SESSION['last_activity'])) {
        $seconds_inactive = time() - $_SESSION['last_activity'];
        
        if ($seconds_inactive > $idle_timeout) {
            // User has been idle for too long, lock the screen
            $_SESSION['locked'] = true;
            header('Location: lock_screen.php');
            exit();
        }
    }
}

// Update last activity time
$_SESSION['last_activity'] = time();

// Store current page for return after unlock
$_SESSION['return_to'] = basename($_SERVER['PHP_SELF']);
?>