<?php
// Get notification counts from database

// Get pending deposits count
$deposit_sql = "SELECT COUNT(*) as count FROM deposits WHERE status = 'pending'";
$deposit_result = mysqli_query($conn, $deposit_sql);
$deposit_row = mysqli_fetch_assoc($deposit_result);
$pending_deposits = $deposit_row['count'];

// Get pending withdrawals count
$withdrawal_sql = "SELECT COUNT(*) as count FROM withdrawals WHERE status = 'pending'";
$withdrawal_result = mysqli_query($conn, $withdrawal_sql);
$withdrawal_row = mysqli_fetch_assoc($withdrawal_result);
$pending_withdrawals = $withdrawal_row['count'];

// Get pending KYC count
$kyc_sql = "SELECT COUNT(*) as count FROM kyc_documents WHERE verification_status = 'pending'";
$kyc_result = mysqli_query($conn, $kyc_sql);
$kyc_row = mysqli_fetch_assoc($kyc_result);
$pending_kyc = $kyc_row['count'];

// Get open support tickets count
$ticket_sql = "SELECT COUNT(*) as count FROM support_tickets WHERE status IN ('open', 'in_progress')";
$ticket_result = mysqli_query($conn, $ticket_sql);
$ticket_row = mysqli_fetch_assoc($ticket_result);
$open_tickets = $ticket_row['count'];

// Get recent admin activities for notifications
$activity_sql = "SELECT * FROM admin_activities ORDER BY created_at DESC LIMIT 5";
$activity_result = mysqli_query($conn, $activity_sql);
?>

<header class="main-header">
    <div class="d-flex align-items-center logo-box justify-content-start">
        <a href="#" class=" waves-light nav-link d-none d-md-inline-block mx-10 push-btn bg-transparent" data-toggle="push-menu" role="button">
            <i class="fas fa-bars"></i>
        </a>    
        <!-- Logo -->
        <a href="index.php" class="logo">
            <!-- logo-->
            <div class="logo-lg">
                <span class="light-logo"><img src="../images/logo-dark-text.png" alt="logo"></span>
                <span class="dark-logo"><img src="../images/logo-light-text.png" alt="logo"></span>
            </div>
        </a>    
    </div>  
    <!-- Header Navbar -->
    <nav class="navbar navbar-static-top">
        <!-- Sidebar toggle button-->
        <div class="app-menu">
            <ul class="header-megamenu nav">
                <li class="btn-group nav-item d-md-none">
                    <a href="#" class=" waves-light nav-link push-btn" data-toggle="push-menu" role="button">
                        <i class="fas fa-bars"></i>
                    </a>
                </li>
                <li class="btn-group nav-item d-none d-xl-inline-block">
                    <a href="support_tickets.php" class=" waves-light nav-link svg-bt-icon position-relative" title="Support Tickets">
                        <i class="fas fa-ticket-alt"></i>
                        <?php if ($open_tickets > 0): ?>
                            <span class="badge bg-danger notification-badge"><?php echo $open_tickets; ?></span>
                        <?php endif; ?>
                    </a>
                </li>
                <li class="btn-group nav-item d-none d-xl-inline-block">
                    <a href="pending_deposits.php" class=" waves-light nav-link svg-bt-icon position-relative" title="Pending Deposits">
                        <i class="fas fa-download"></i>
                        <?php if ($pending_deposits > 0): ?>
                            <span class="badge bg-warning notification-badge"><?php echo $pending_deposits; ?></span>
                        <?php endif; ?>
                    </a>
                </li>
                <li class="btn-group nav-item d-none d-xl-inline-block">
                    <a href="kyc_documents.php" class=" waves-light nav-link svg-bt-icon position-relative" title="KYC Documents">
                        <i class="fas fa-id-card"></i>
                        <?php if ($pending_kyc > 0): ?>
                            <span class="badge bg-info notification-badge out"><?php echo $pending_kyc; ?></span>
                        <?php endif; ?>
                    </a>
                </li>
            </ul> 
        </div>
        
        <div class="navbar-custom-menu r-side">
            <ul class="nav navbar-nav"> 
                <!-- Lock Screen Button -->
                <li class="btn-group nav-item d-lg-inline-flex d-none">
                    <a href="lock_screen.php"  class=" waves-light nav-link full-screen" title="Full Screen">
                        <i class="fas fa-lock"></i>
                    </a>
                </li>     
                <!-- Full Screen Button -->
                <li class="btn-group nav-item d-lg-inline-flex d-none">
                    <a href="#" data-provide="fullscreen" class=" waves-light nav-link full-screen" title="Full Screen">
                        <i class="fas fa-expand"></i>
                    </a>
                </li>     
                
                <!-- Search -->
                
                
                <!-- Live Notifications -->
                <li class="dropdown notifications-menu">
                    <a href="#" class=" waves-light dropdown-toggle position-relative" data-bs-toggle="dropdown" title="Notifications" id="notificationBell">
                        <i class="fas fa-bell"></i>
                        <?php 
                        $total_notifications = $pending_deposits + $pending_withdrawals + $pending_kyc + $open_tickets;
                        if ($total_notifications > 0): ?>
                            <span class="badge bg-danger notification-count"><?php echo $total_notifications; ?></span>
                        <?php endif; ?>
                    </a>
                    <ul class="dropdown-menu animated bounceIn" style="width: 350px;">

                        <li class="header">
                            <div class="p-20">
                                <div class="flexbox">
                                    <div>
                                        <h4 class="mb-0 mt-0">Notifications</h4>
                                        <small class="text-mute">Real-time updates</small>
                                    </div>
                                    <div>
                                        <a href="javascript:void(0)" class="text-danger" onclick="clearAllNotifications()">Clear All</a>
                                    </div>
                                </div>
                            </div>
                        </li>

                        <li>
                            <!-- inner menu: contains the actual data -->
                            <ul class="menu sm-scrol" id="notificationList" style="max-height: 400px; overflow-y: auto;">
                                <!-- Pending Deposits -->
                                <?php if ($pending_deposits > 0): ?>
                                    <li>
                                        <a href="pending_deposits.php">
                                            <div class="d-flex align-items-center">
                                                <div class="me-10">
                                                    <i class="fas fa-download text-success fs-18"></i>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <p class="mb-0 fw-500">Pending Deposits</p>
                                                    <small class="text-mute"><?php echo $pending_deposits; ?> deposit(s) awaiting approval</small>
                                                    <small class="text-mute d-block"><?php echo date('H:i'); ?></small>
                                                </div>
                                                <div class="ms-2">
                                                    <span class="badge bg-warning"><?php echo $pending_deposits; ?></span>
                                                </div>
                                            </div>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                
                                <!-- Pending Withdrawals -->
                                <?php if ($pending_withdrawals > 0): ?>
                                    <li>
                                        <a href="pending_withdrawals.php">
                                            <div class="d-flex align-items-center">
                                                <div class="me-10">
                                                    <i class="fas fa-upload text-danger fs-18"></i>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <p class="mb-0 fw-500">Pending Withdrawals</p>
                                                    <small class="text-mute"><?php echo $pending_withdrawals; ?> withdrawal(s) to process</small>
                                                    <small class="text-mute d-block"><?php echo date('H:i'); ?></small>
                                                </div>
                                                <div class="ms-2">
                                                    <span class="badge bg-danger"><?php echo $pending_withdrawals; ?></span>
                                                </div>
                                            </div>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                
                                <!-- Pending KYC -->
                                <?php if ($pending_kyc > 0): ?>
                                    <li>
                                        <a href="kyc_documents.php">
                                            <div class="d-flex align-items-center">
                                                <div class="me-10">
                                                    <i class="fas fa-id-card text-info fs-18"></i>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <p class="mb-0 fw-500">Pending KYC Documents</p>
                                                    <small class="text-mute"><?php echo $pending_kyc; ?> document(s) to verify</small>
                                                    <small class="text-mute d-block"><?php echo date('H:i'); ?></small>
                                                </div>
                                                <div class="ms-2">
                                                    <span class="badge bg-info"><?php echo $pending_kyc; ?></span>
                                                </div>
                                            </div>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                
                                <!-- Open Tickets -->
                                <?php if ($open_tickets > 0): ?>
                                    <li>
                                        <a href="support_tickets.php">
                                            <div class="d-flex align-items-center">
                                                <div class="me-10">
                                                    <i class="fas fa-ticket-alt text-warning fs-18"></i>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <p class="mb-0 fw-500">Open Support Tickets</p>
                                                    <small class="text-mute"><?php echo $open_tickets; ?> ticket(s) need attention</small>
                                                    <small class="text-mute d-block"><?php echo date('H:i'); ?></small>
                                                </div>
                                                <div class="ms-2">
                                                    <span class="badge bg-primary"><?php echo $open_tickets; ?></span>
                                                </div>
                                            </div>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                
                                <!-- Recent Admin Activities -->
                                <?php if (mysqli_num_rows($activity_result) > 0): ?>
                                    <li class="divider"><small class="text-mute px-3">Recent Activities</small></li>
                                    <?php while ($activity = mysqli_fetch_assoc($activity_result)): ?>
                                        <?php
                                        $time_ago = time_ago($activity['created_at']);
                                        $icon = '';
                                        $color = '';
                                        
                                        switch ($activity['action']) {
                                            case 'User Verified':
                                            case 'Transaction Processed':
                                                $icon = 'fas fa-check-circle';
                                                $color = 'text-success';
                                                break;
                                            case 'User Status Updated':
                                            case 'User Balance Updated':
                                                $icon = 'fas fa-edit';
                                                $color = 'text-primary';
                                                break;
                                            case 'User Deleted':
                                            case 'Transaction Rejected':
                                                $icon = 'fas fa-times-circle';
                                                $color = 'text-danger';
                                                break;
                                            default:
                                                $icon = 'fas fa-info-circle';
                                                $color = 'text-info';
                                        }
                                        ?>
                                        <li>
                                            <a href="admin_activities.php">
                                                <div class="d-flex align-items-center">
                                                    <div class="me-10">
                                                        <i class="<?php echo $icon; ?> <?php echo $color; ?> fs-16"></i>
                                                    </div>
                                                    <div class="flex-grow-1">
                                                        <p class="mb-0 fw-500" style="font-size: 13px;"><?php echo htmlspecialchars($activity['action']); ?></p>
                                                        <small class="text-mute" style="font-size: 11px;"><?php echo htmlspecialchars(substr($activity['description'], 0, 50)); ?>...</small>
                                                        <small class="text-mute d-block" style="font-size: 10px;"><?php echo $time_ago; ?> ago</small>
                                                    </div>
                                                </div>
                                            </a>
                                        </li>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <li class="text-center py-10">
                                        <i class="fas fa-bell-slash fs-24 text-mute"></i>
                                        <p class="mt-2 mb-0 text-mute">No new notifications</p>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </li>
                        
                        <li class="footer">
                            <a href="admin_activities.php" class="text-center d-block py-2">View All Activities</a>
                        </li>
                    </ul>
                </li> 
                
                <!-- User Account-->
                <li class="dropdown user user-menu">
                    <?php
                    // Get admin info from session
                    $admin_name = $_SESSION['admin_name'] ?: 'Admin';
                    $admin_role = $_SESSION['admin_role'] ?: 'admin';
                    $admin_email = $_SESSION['admin_email'] ?: 'admin@system.com';
                    ?>
                    <a href="#" class=" waves-light dropdown-toggle" data-bs-toggle="dropdown" title="User">
                        <div class="d-flex align-items-center">
                            <div class="me-10">
                                <div class="bg-primary rounded-circle w-35 h-35 d-flex align-items-center justify-content-center">
                                    <i class="fas fa-user-shield text-white"></i>
                                </div>
                            </div>
                            
                        </div>
                    </a>
                    <ul class="dropdown-menu animated flipInX">
                        <li class="user-header">
                            <div class="text-center p-20">
                                <div class="bg-primary rounded-circle w-60 h-60 mx-auto d-flex align-items-center justify-content-center mb-3">
                                    <i class="fas fa-user-shield fa-2x text-white"></i>
                                </div>
                                <h5 class="mb-0"><?php echo htmlspecialchars($admin_name); ?></h5>
                                <small class="text-mute"><?php echo htmlspecialchars($admin_email); ?></small>
                                <div class="mt-2">
                                    <span class="badge bg-<?php echo $admin_role == 'super_admin' ? 'danger' : ($admin_role == 'admin' ? 'primary' : 'info'); ?>">
                                        <?php echo ucfirst(str_replace('_', ' ', $admin_role)); ?>
                                    </span>
                                </div>
                            </div>
                        </li>
                        <li class="user-body">
                            <div class="row">
                                <div class="col-6 text-center">
                                    <a href="profile.php">Profile</a>
                                </div>
                                <div class="col-6 text-center">
                                    <a href="settings.php">Settings</a>
                                </div>
                            </div>
                        </li>
                        <li class="user-footer">
                            <a href="profile.php" class="btn btn-default btn-flat"><i class="fas fa-user me-2"></i> Profile</a>
                            <a href="logout.php" class="btn btn-default btn-flat float-end"><i class="fas fa-sign-out-alt me-2"></i> Logout</a>
                        </li>
                    </ul>
                </li> 
                
                <!-- Control Sidebar Toggle Button -->
                <li>
                    <a href="#" data-toggle="control-sidebar" title="Setting" class=" waves-light">
                        <i class="fas fa-cog"></i>
                    </a>
                </li>
                    
            </ul>
        </div>
    </nav>
</header>

<!-- Toast Container for Live Notifications -->
<div class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 9999;">
    <!-- Toasts will be appended here dynamically -->
</div>

<!-- Notification Sound (optional) -->
<audio id="notificationSound" preload="auto">
    <source src="https://assets.mixkit.co/sfx/preview/mixkit-correct-answer-tone-2870.mp3" type="audio/mpeg">
</audio>

<script>
// Notification System
$(document).ready(function() {
    // Check for new notifications every 30 seconds
    setInterval(checkNewNotifications, 30000);
    
    // Initialize notification count
    updateNotificationCount();
    
    // Listen for custom notification events
    $(document).on('newNotification', function(e, data) {
        showToastNotification(data);
        updateNotificationCount();
        playNotificationSound();
    });
    
    // Full screen functionality
    $('.full-screen').on('click', function(e) {
        e.preventDefault();
        toggleFullScreen();
    });
});

// Function to check for new notifications
function checkNewNotifications() {
    $.ajax({
        url: 'ajax/check_notifications.php',
        type: 'GET',
        success: function(response) {
            var data = JSON.parse(response);
            if (data.has_new) {
                // Trigger notification event
                $(document).trigger('newNotification', [{
                    title: data.title,
                    message: data.message,
                    type: data.type,
                    link: data.link
                }]);
                
                // Update notification dropdown
                loadNotificationDropdown();
            }
        }
    });
}

// Function to load notification dropdown
function loadNotificationDropdown() {
    $.ajax({
        url: 'ajax/get_notifications.php',
        type: 'GET',
        success: function(response) {
            $('#notificationList').html(response);
        }
    });
}

// Function to update notification count
function updateNotificationCount() {
    $.ajax({
        url: 'ajax/get_notification_count.php',
        type: 'GET',
        success: function(count) {
            var countElement = $('.notification-count');
            if (count > 0) {
                countElement.text(count).show();
                $('#notificationBell').addClass('has-notifications');
                
                // Add pulse animation
                countElement.addClass('notification-pulse');
            } else {
                countElement.text('').hide();
                $('#notificationBell').removeClass('has-notifications');
                countElement.removeClass('notification-pulse');
            }
        }
    });
}

// Function to show toast notification
function showToastNotification(data) {
    var icon = '';
    var bgColor = '';
    
    switch(data.type) {
        case 'success':
            icon = 'fas fa-check-circle';
            bgColor = 'bg-success';
            break;
        case 'warning':
            icon = 'fas fa-exclamation-triangle';
            bgColor = 'bg-warning';
            break;
        case 'error':
            icon = 'fas fa-times-circle';
            bgColor = 'bg-danger';
            break;
        case 'info':
        default:
            icon = 'fas fa-info-circle';
            bgColor = 'bg-info';
    }
    
    var toastId = 'toast-' + Date.now();
    var toastHtml = `
        <div id="${toastId}" class="toast align-items-center text-white ${bgColor} border-0" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="d-flex">
                <div class="toast-body">
                    <div class="d-flex align-items-center">
                        <i class="${icon} me-3 fs-18"></i>
                        <div>
                            <h6 class="mb-1">${data.title}</h6>
                            <p class="mb-0" style="font-size: 13px;">${data.message}</p>
                        </div>
                    </div>
                </div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
        </div>
    `;
    
    $('.toast-container').append(toastHtml);
    var toastElement = document.getElementById(toastId);
    var toast = new bootstrap.Toast(toastElement, {
        animation: true,
        autohide: true,
        delay: 5000
    });
    toast.show();
    
    // Remove toast after it's hidden
    $(toastElement).on('hidden.bs.toast', function () {
        $(this).remove();
    });
    
    // Make toast clickable if link is provided
    if (data.link) {
        $(toastElement).css('cursor', 'pointer').on('click', function() {
            window.location.href = data.link;
        });
    }
}

// Function to play notification sound
function playNotificationSound() {
    var sound = document.getElementById('notificationSound');
    if (sound) {
        sound.currentTime = 0;
        sound.play().catch(e => console.log("Audio play failed:", e));
    }
}

// Function to clear all notifications
function clearAllNotifications() {
    Swal.fire({
        title: 'Clear All Notifications?',
        text: "This will mark all notifications as read.",
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, clear all'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: 'ajax/clear_notifications.php',
                type: 'POST',
                success: function() {
                    updateNotificationCount();
                    loadNotificationDropdown();
                    showToastNotification({
                        title: 'Notifications Cleared',
                        message: 'All notifications have been marked as read.',
                        type: 'success'
                    });
                }
            });
        }
    });
}

// Mark notification as read when clicked
$(document).on('click', '#notificationList a', function(e) {
    var notificationId = $(this).data('id');
    if (notificationId) {
        $.ajax({
            url: 'ajax/mark_notification_read.php',
            type: 'POST',
            data: { id: notificationId }
        });
    }
});

// Full screen toggle function
function toggleFullScreen() {
    var elem = document.documentElement;
    if (!document.fullscreenElement && !document.mozFullScreenElement &&
        !document.webkitFullscreenElement && !document.msFullscreenElement) {
        // Enter full screen
        if (elem.requestFullscreen) {
            elem.requestFullscreen();
        } else if (elem.msRequestFullscreen) {
            elem.msRequestFullscreen();
        } else if (elem.mozRequestFullScreen) {
            elem.mozRequestFullScreen();
        } else if (elem.webkitRequestFullscreen) {
            elem.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT);
        }
        $('.full-screen i').removeClass('fa-expand').addClass('fa-compress');
    } else {
        // Exit full screen
        if (document.exitFullscreen) {
            document.exitFullscreen();
        } else if (document.msExitFullscreen) {
            document.msExitFullscreen();
        } else if (document.mozCancelFullScreen) {
            document.mozCancelFullScreen();
        } else if (document.webkitExitFullscreen) {
            document.webkitExitFullscreen();
        }
        $('.full-screen i').removeClass('fa-compress').addClass('fa-expand');
    }
}

// Listen for full screen change
document.addEventListener('fullscreenchange', handleFullScreenChange);
document.addEventListener('webkitfullscreenchange', handleFullScreenChange);
document.addEventListener('mozfullscreenchange', handleFullScreenChange);
document.addEventListener('MSFullscreenChange', handleFullScreenChange);

function handleFullScreenChange() {
    if (!document.fullscreenElement && !document.webkitIsFullScreen &&
        !document.mozFullScreen && !document.msFullscreenElement) {
        $('.full-screen i').removeClass('fa-compress').addClass('fa-expand');
    }
}

// Helper function for time ago (same as in PHP)
function timeAgo(timestamp) {
    var seconds = Math.floor((new Date() - new Date(timestamp)) / 1000);
    
    var intervals = {
        year: 31536000,
        month: 2592000,
        week: 604800,
        day: 86400,
        hour: 3600,
        minute: 60,
        second: 1
    };
    
    for (var unit in intervals) {
        var interval = Math.floor(seconds / intervals[unit]);
        if (interval >= 1) {
            return interval + ' ' + unit + (interval === 1 ? '' : 's') + ' ago';
        }
    }
    return 'just now';
}
</script>

<style>
/* Notification Badge Styles */
.notification-count {
    position: absolute;
    top: -5px;
    right: -5px;
    background: #ff4d4f;
    color: white;
    border-radius: 50%;
    padding: 3px 7px;
    font-size: 11px;
    font-weight: bold;
    min-width: 20px;
    min-height: 20px;
    text-align: center;
    line-height: 14px;
    display: flex;
    align-items: center;
    justify-content: center;
    border: 2px solid #fff;
    box-shadow: 0 2px 4px rgba(0,0,0,0.2);
}

.notification-badge {
    position: absolute;
    top: -8px;
    right: -8px;
    font-size: 10px;
    padding: 3px 6px;
    min-width: 18px;
    min-height: 18px;
    text-align: center;
    line-height: 12px;
    border: 2px solid #fff;
    border-radius: 50%;
    box-shadow: 0 2px 4px rgba(0,0,0,0.2);
	
}

.out {
	z-index: 99999 !important;
}
/* Position relative for badge containers */
.position-relative {
    position: relative !important;
}

.svg-bt-icon {
    position: relative;
    display: flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
}

/* Notification Bell Animation */
.has-notifications .fa-bell {
    animation: bellRing 0.5s ease-in-out;
    color: #ff4d4f;
}

@keyframes bellRing {
    0%, 100% { transform: rotate(0); }
    10%, 30%, 50%, 70%, 90% { transform: rotate(-10deg); }
    20%, 40%, 60%, 80% { transform: rotate(10deg); }
}

/* Notification Pulse Animation */
.notification-pulse {
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0% {
        box-shadow: 0 0 0 0 rgba(255, 77, 79, 0.7);
    }
    70% {
        box-shadow: 0 0 0 10px rgba(255, 77, 79, 0);
    }
    100% {
        box-shadow: 0 0 0 0 rgba(255, 77, 79, 0);
    }
}

/* Notification Dropdown Styles */
.notifications-menu .dropdown-menu {
    width: 350px;
    border-radius: 10px;
    border: 1px solid #e0e0e0;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
}

.notifications-menu .menu {
    max-height: 400px;
    overflow-y: auto;
}

.notifications-menu .menu li > a {
    padding: 12px 15px;
    border-bottom: 1px solid #f5f5f5;
    transition: background-color 0.2s;
    display: block;
    color: #333;
    text-decoration: none;
}

.notifications-menu .menu li > a:hover {
    background-color: #f8f9fa;
}

.notifications-menu .menu li.divider {
    border-top: 1px solid #f1f1f1;
    padding: 8px 0;
    margin: 8px 0;
}

.notifications-menu .menu li.divider small {
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

/* Header Navigation Styles */
.navbar-nav > li > a {
    padding: 0 12px;
    display: flex;
    align-items: center;
    height: 60px;
}

.navbar-nav > li > a i {
    font-size: 18px;
    color: #666;
}

.navbar-nav > li > a:hover i {
    color: #667eea;
}

/* User Dropdown Styles */
.user-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    padding: 20px;
    text-align: center;
    color: white;
    border-radius: 10px 10px 0 0;
}

.user-body .row {
    margin: 0;
    padding: 10px 0;
}

.user-body .col-6 {
    padding: 10px;
    border-right: 1px solid #f1f1f1;
}

.user-body .col-6:last-child {
    border-right: none;
}

.user-footer {
    padding: 10px;
    display: flex;
    justify-content: space-between;
    background: #f8f9fa;
    border-radius: 0 0 10px 10px;
}

/* Toast Notification Styles */
.toast-container {
    z-index: 9999;
}

.toast {
    border-radius: 10px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    margin-bottom: 10px;
    max-width: 350px;
    border: none;
}

.toast-body {
    padding: 12px 15px;
}

/* Lock Screen Button */
.navbar-nav > li > a[title="Lock Screen"]:hover i {
    color: #ff4d4f;
}

/* Full Screen Button */
.navbar-nav > li > a[title="Full Screen"]:hover i {
    color: #4CAF50;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .notification-badge {
        top: -5px;
        right: -5px;
        font-size: 9px;
        padding: 2px 5px;
        min-width: 16px;
        min-height: 16px;
    }
    
    .notification-count {
        top: -3px;
        right: -3px;
        font-size: 10px;
        padding: 2px 5px;
        min-width: 18px;
        min-height: 18px;
    }
    
    .notifications-menu .dropdown-menu {
        width: 300px;
        right: -50px;
    }
}
</style>

<?php
// Helper function for time ago
function time_ago($datetime) {
    $time = strtotime($datetime);
    $now = time();
    $diff = $now - $time;
    
    if ($diff < 60) {
        return $diff . " seconds";
    } elseif ($diff < 3600) {
        return floor($diff / 60) . " minutes";
    } elseif ($diff < 86400) {
        return floor($diff / 3600) . " hours";
    } elseif ($diff < 604800) {
        return floor($diff / 86400) . " days";
    } elseif ($diff < 2592000) {
        return floor($diff / 604800) . " weeks";
    } elseif ($diff < 31536000) {
        return floor($diff / 2592000) . " months";
    } else {
        return floor($diff / 31536000) . " years";
    }
}
?>