<?php session_start();?>
<!DOCTYPE html>
<html lang="en">
  	<?php 
  	include('includes/head.php');
  	?>
	<?php 
// Check permission for dashboard
if (!checkPermission($conn, $_SESSION['admin_role'], 'dashboard', 'can_view')) {
    header("Location: unauthorized.php");
    exit();
}

// Log dashboard access
logAdminActivity($conn, $_SESSION['admin_id'], 'Dashboard Access', 'Accessed dashboard page', 'dashboard');
?>
	
	<body class="hold-transition dark-skin sidebar-mini theme-primary fixed">
		
		<div class="wrapper">
		  	<div id="loader"></div>
		  	
		  <?php include('includes/header.php') ?>

		  <?php include('includes/sidebar.php') ?>

		  	 
		  	<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<div class="container-full">
					<!-- Main content -->
					<section class="content">
						<div class="row">
							<!-- Page Header -->
							<div class="col-12">
								<div class="box">
									<div class="box-body">
										<div class="d-flex justify-content-between align-items-center">
											<div>
												<h4 class="box-title mb-0"><i class="fas fa-tachometer-alt me-2"></i>AI Trading Dashboard</h4>
												<p class="mb-0 text-mute">Real-time statistics and analytics</p>
											</div>
											<div class="dropdown">
												<button class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
													<i class="fas fa-sync-alt me-1"></i> Auto Refresh: <span id="refreshStatus">ON</span>
												</button>
												<div class="dropdown-menu">
													<a class="dropdown-item" href="javascript:void(0)" onclick="toggleRefresh(true)"><i class="fas fa-play text-success"></i> Enable Auto Refresh</a>
													<a class="dropdown-item" href="javascript:void(0)" onclick="toggleRefresh(false)"><i class="fas fa-pause text-warning"></i> Disable Auto Refresh</a>
													<a class="dropdown-item" href="javascript:void(0)" onclick="refreshDashboard()"><i class="fas fa-redo"></i> Refresh Now</a>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							
							<!-- Stats Cards Row 1 -->
							<div class="col-xl-3 col-md-6 col-12">
								<div class="box bg-gradient-primary pull-up" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
									<div class="box-body">
										<div class="d-flex justify-content-between align-items-center">
											<div>
												<h5 class="text-white mb-0">Total Users</h5>
												<h2 class="text-white fw-500 mb-0" id="totalUsers">0</h2>
												<p class="text-white-50 mb-0">Registered users on platform</p>
											</div>
											<div class="bg-white-20 rounded-circle p-15">
												<i class="fas fa-users fa-2x text-white"></i>
											</div>
										</div>
										<div class="mt-20">
											<div class="d-flex justify-content-between">
												<span class="text-white-50">Today: <span id="newUsersToday">0</span></span>
												<span class="text-white-50">This Week: <span id="newUsersWeek">0</span></span>
											</div>
										</div>
									</div>
								</div>
							</div>
							
							<div class="col-xl-3 col-md-6 col-12">
								<div class="box bg-gradient-success pull-up" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
									<div class="box-body">
										<div class="d-flex justify-content-between align-items-center">
											<div>
												<h5 class="text-white mb-0">Active Subscriptions</h5>
												<h2 class="text-white fw-500 mb-0" id="activeSubscriptions">0</h2>
												<p class="text-white-50 mb-0">Currently running bots</p>
											</div>
											<div class="bg-white-20 rounded-circle p-15">
												<i class="fas fa-robot fa-2x text-white"></i>
											</div>
										</div>
										<div class="mt-20">
											<div class="d-flex justify-content-between">
												<span class="text-white-50">Active: <span id="activeBotsCount">0</span></span>
												<span class="text-white-50">Expired: <span id="expiredSubscriptions">0</span></span>
											</div>
										</div>
									</div>
								</div>
							</div>
							
							<div class="col-xl-3 col-md-6 col-12">
								<div class="box bg-gradient-warning pull-up" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
									<div class="box-body">
										<div class="d-flex justify-content-between align-items-center">
											<div>
												<h5 class="text-white mb-0">Pending Deposits</h5>
												<h2 class="text-white fw-500 mb-0" id="pendingDeposits">0</h2>
												<p class="text-white-50 mb-0">Awaiting confirmation</p>
											</div>
											<div class="bg-white-20 rounded-circle p-15">
												<i class="fas fa-download fa-2x text-white"></i>
											</div>
										</div>
										<div class="mt-20">
											<div class="d-flex justify-content-between">
												<span class="text-white-50">Today: <span id="pendingDepositsToday">0</span></span>
												<span class="text-white-50">Amount: $<span id="pendingDepositsAmount">0</span></span>
											</div>
										</div>
									</div>
								</div>
							</div>
							
							<div class="col-xl-3 col-md-6 col-12">
								<div class="box bg-gradient-danger pull-up" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
									<div class="box-body">
										<div class="d-flex justify-content-between align-items-center">
											<div>
												<h5 class="text-white mb-0">Pending Withdrawals</h5>
												<h2 class="text-white fw-500 mb-0" id="pendingWithdrawals">0</h2>
												<p class="text-white-50 mb-0">Awaiting processing</p>
											</div>
											<div class="bg-white-20 rounded-circle p-15">
												<i class="fas fa-upload fa-2x text-white"></i>
											</div>
										</div>
										<div class="mt-20">
											<div class="d-flex justify-content-between">
												<span class="text-white-50">Today: <span id="pendingWithdrawalsToday">0</span></span>
												<span class="text-white-50">Amount: $<span id="pendingWithdrawalsAmount">0</span></span>
											</div>
										</div>
									</div>
								</div>
							</div>
							
							<!-- Stats Cards Row 2 -->
							<div class="col-xl-3 col-md-6 col-12">
								<div class="box bg-gradient-info pull-up" style="background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);">
									<div class="box-body">
										<div class="d-flex justify-content-between align-items-center">
											<div>
												<h5 class="text-white mb-0">Total Profit</h5>
												<h2 class="text-white fw-500 mb-0" id="totalProfit">$0</h2>
												<p class="text-white-50 mb-0">Total profit generated</p>
											</div>
											<div class="bg-white-20 rounded-circle p-15">
												<i class="fas fa-chart-line fa-2x text-white"></i>
											</div>
										</div>
										<div class="mt-20">
											<div class="d-flex justify-content-between">
												<span class="text-white-50">This Month: $<span id="profitThisMonth">0</span></span>
												<span class="text-white-50">All Time</span>
											</div>
										</div>
									</div>
								</div>
							</div>
							
							<div class="col-xl-3 col-md-6 col-12">
								<div class="box bg-gradient-secondary pull-up" style="background: linear-gradient(135deg, #30cfd0 0%, #330867 100%);">
									<div class="box-body">
										<div class="d-flex justify-content-between align-items-center">
											<div>
												<h5 class="text-white mb-0">Today's Profit</h5>
												<h2 class="text-white fw-500 mb-0" id="todaysProfit">$0</h2>
												<p class="text-white-50 mb-0">Profit generated today</p>
											</div>
											<div class="bg-white-20 rounded-circle p-15">
												<i class="fas fa-coins fa-2x text-white"></i>
											</div>
										</div>
										<div class="mt-20">
											<div class="d-flex justify-content-between">
												<span class="text-white-50">Yesterday: $<span id="yesterdayProfit">0</span></span>
												<span class="text-white-50">Change: <span id="profitChange">0%</span></span>
											</div>
										</div>
									</div>
								</div>
							</div>
							
							<div class="col-xl-3 col-md-6 col-12">
								<div class="box bg-gradient-dark pull-up" style="background: linear-gradient(135deg, #5ee7df 0%, #b490ca 100%);">
									<div class="box-body">
										<div class="d-flex justify-content-between align-items-center">
											<div>
												<h5 class="text-white mb-0">Active Bots</h5>
												<h2 class="text-white fw-500 mb-0" id="activeBots">0</h2>
												<p class="text-white-50 mb-0">Currently trading bots</p>
											</div>
											<div class="bg-white-20 rounded-circle p-15">
												<i class="fas fa-bolt fa-2x text-white"></i>
											</div>
										</div>
										<div class="mt-20">
											<div class="d-flex justify-content-between">
												<span class="text-white-50">Running: <span id="runningBots">0</span></span>
												<span class="text-white-50">Idle: <span id="idleBots">0</span></span>
											</div>
										</div>
									</div>
								</div>
							</div>
							
							<div class="col-xl-3 col-md-6 col-12">
								<div class="box bg-gradient-light pull-up" style="background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%);">
									<div class="box-body">
										<div class="d-flex justify-content-between align-items-center">
											<div>
												<h5 class="text-dark mb-0">Open Tickets</h5>
												<h2 class="text-dark fw-500 mb-0" id="openTickets">0</h2>
												<p class="text-dark-50 mb-0">Pending support requests</p>
											</div>
											<div class="bg-dark-20 rounded-circle p-15">
												<i class="fas fa-ticket-alt fa-2x text-dark"></i>
											</div>
										</div>
										<div class="mt-20">
											<div class="d-flex justify-content-between">
												<span class="text-dark-50">New: <span id="newTickets">0</span></span>
												<span class="text-dark-50">In Progress: <span id="inProgressTickets">0</span></span>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						
						<div class="row">
							<!-- Chart 1: Revenue & Profit Trend -->
							<div class="col-xl-8 col-lg-6">
								<div class="box b-1 overflow-hidden">
									<div class="box-header pb-0 no-border">
										<div class="d-flex justify-content-between align-items-center">
											<div class="d-flex align-items-center">
												<h4 class="fw-500 fs-20 m-0"><i class="fas fa-chart-line me-2"></i>Revenue & Profit Trend</h4>
											</div>
											<div class="dropdown">
											  	<button class="btn btn-secondary btn-outline btn-md dropdown-toggle fw-500" type="button" data-bs-toggle="dropdown" aria-expanded="false" id="chartPeriod">Last 7 Days</button>
											  	<div class="dropdown-menu dropdown-menu-end">
											    	<a class="dropdown-item" href="javascript:void(0)" onclick="changeChartPeriod('7')">Last 7 Days</a>
												  	<a class="dropdown-item" href="javascript:void(0)" onclick="changeChartPeriod('30')">Last 30 Days</a>
												  	<a class="dropdown-item" href="javascript:void(0)" onclick="changeChartPeriod('90')">Last 90 Days</a>
											  	</div>
											</div>
										</div>
									</div>
									<div class="box-body py-0 px-0">
										<div id="revenue-profit-chart" style="height: 300px;"></div>
									</div>
								</div>
							</div>
							
							<!-- Chart 2: Bot Plan Distribution -->
							<div class="col-xl-4 col-lg-6">
								<div class="box b-1">
									<div class="box-header pb-0 no-border">
										<div class="d-flex justify-content-between align-items-center">
											<div class="d-flex align-items-center">
												<h4 class="fw-500 m-0"><i class="fas fa-robot me-2"></i>Bot Plan Distribution</h4>
											</div>
										</div>
									</div>
									<div class="box-body pb-0 ps-0 pe-10">
										<div id="bot-plan-chart" style="height: 300px;"></div>
									</div>
								</div>
							</div>
						</div>
						
						<div class="row">
							<!-- Recent Transactions -->
							<div class="col-xl-6 col-lg-6">
								<div class="box b-1">
									<div class="box-header no-border d-flex justify-content-between align-items-center">
										<h4 class="box-title"><i class="fas fa-exchange-alt me-2"></i>Recent Transactions</h4>
										<a href="all_transactions.php" class="btn btn-secondary btn-outline btn-md fw-500" type="button">View All</a>
									</div>
									<div class="box-body p-0">
										<div class="table-responsive">
											<table class="table table-hover mb-0">
												<thead>
													<tr>
														<th>User</th>
														<th>Type</th>
														<th>Amount</th>
														<th>Status</th>
														<th>Date</th>
													</tr>
												</thead>
												<tbody id="recentTransactions">
													<!-- Transactions will be loaded via AJAX -->
												</tbody>
											</table>
										</div>
									</div>
								</div>
							</div>
							
							<!-- Recent Users -->
							<div class="col-xl-6 col-lg-6">
								<div class="box b-1">
									<div class="box-header no-border d-flex justify-content-between align-items-center">
										<h4 class="box-title"><i class="fas fa-user-plus me-2"></i>Recent Users</h4>
										<a href="users.php" class="btn btn-secondary btn-outline btn-md fw-500" type="button">View All</a>
									</div>
									<div class="box-body p-0">
										<div class="table-responsive">
											<table class="table table-hover mb-0">
												<thead>
													<tr>
														<th>User</th>
														<th>Email</th>
														<th>Status</th>
														<th>Balance</th>
														<th>Joined</th>
													</tr>
												</thead>
												<tbody id="recentUsers">
													<!-- Users will be loaded via AJAX -->
												</tbody>
											</table>
										</div>
									</div>
								</div>
							</div>
						</div>

						<!-- Admin Activities Widget -->
						<div class="row">
							<div class="col-12">
								<div class="box">
									<div class="box-header">
										<h4 class="box-title"><i class="fas fa-history me-2"></i>Recent Admin Activities</h4>
										<div class="dropdown">
											<button class="btn btn-sm btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown">
												<i class="fas fa-filter"></i> Filter
											</button>
											<div class="dropdown-menu">
												<a class="dropdown-item" href="javascript:void(0)" onclick="filterActivities('all')">All Activities</a>
												<a class="dropdown-item" href="javascript:void(0)" onclick="filterActivities('today')">Today</a>
												<a class="dropdown-item" href="javascript:void(0)" onclick="filterActivities('this_week')">This Week</a>
												<div class="dropdown-divider"></div>
												<a class="dropdown-item" href="admin_activities.php">View All</a>
											</div>
										</div>
									</div>
									<div class="box-body p-0">
										<div class="table-responsive">
											<table class="table table-hover mb-0">
												<thead>
													<tr>
														<th>Admin</th>
														<th>Action</th>
														<th>Description</th>
														<th>Module</th>
														<th>Time</th>
													</tr>
												</thead>
												<tbody id="recentActivities">
													<!-- Activities will be loaded via AJAX -->
												</tbody>
											</table>
										</div>
									</div>
								</div>
							</div>
						</div>
						
						<!-- Quick Actions Row -->
						<div class="row">
							<div class="col-12">
								<div class="box">
									<div class="box-header">
										<h4 class="box-title"><i class="fas fa-bolt me-2"></i>Quick Actions</h4>
									</div>
									<div class="box-body">
										<div class="row">
											<div class="col-md-3 col-6">
												<a href="quick_verify.php" class="box quick-action-box bg-primary">
													<div class="box-body text-center">
														<i class="fas fa-user-check fa-2x mb-3"></i>
														<h5>Verify Users</h5>
														<small>Approve pending verifications</small>
													</div>
												</a>
											</div>
											<div class="col-md-3 col-6">
												<a href="pending_deposits.php" class="box quick-action-box bg-success">
													<div class="box-body text-center">
														<i class="fas fa-download fa-2x mb-3"></i>
														<h5>Process Deposits</h5>
														<small>Confirm pending deposits</small>
													</div>
												</a>
											</div>
											<div class="col-md-3 col-6">
												<a href="pending_withdrawals.php" class="box quick-action-box bg-warning">
													<div class="box-body text-center">
														<i class="fas fa-upload fa-2x mb-3"></i>
														<h5>Process Withdrawals</h5>
														<small>Approve withdrawal requests</small>
													</div>
												</a>
											</div>
											<div class="col-md-3 col-6">
												<a href="open_tickets.php" class="box quick-action-box bg-danger">
													<div class="box-body text-center">
														<i class="fas fa-ticket-alt fa-2x mb-3"></i>
														<h5>Support Tickets</h5>
														<small>Respond to user queries</small>
													</div>
												</a>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</section>
					<!-- /.content -->
				</div>
			</div>
		  	
		  <?php include('includes/footer.php') ?>

		  <?php include('includes/control_sidebar.php') ?>
			
		</div>
		<!-- ./wrapper -->
		
		<!-- Modal for Transaction Details -->
		<div class="modal fade" id="transactionModal" tabindex="-1" aria-labelledby="transactionModalLabel" aria-hidden="true">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title" id="transactionModalLabel">Transaction Details</h5>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<div class="modal-body" id="transactionDetails">
						<!-- Details will be loaded via AJAX -->
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
						<button type="button" class="btn btn-primary" id="processTransactionBtn">Process</button>
					</div>
				</div>
			</div>
		</div>
		
		<!-- Modal for User Details -->
		<div class="modal fade" id="userModal" tabindex="-1" aria-labelledby="userModalLabel" aria-hidden="true">
			<div class="modal-dialog modal-lg">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title" id="userModalLabel">User Details</h5>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<div class="modal-body" id="userDetails">
						<!-- Details will be loaded via AJAX -->
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
						<button type="button" class="btn btn-primary" id="verifyUserBtn">Verify User</button>
					</div>
				</div>
			</div>
		</div>
		
		  
    
		
		
		  <?php include('includes/scripts.php') ?>
		
		<!-- Apex Charts -->
		<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
		
		<!-- Custom Dashboard JS -->
		<script>
		// Global Variables
		let autoRefresh = true;
		let refreshInterval;
		let revenueChart;
		let botPlanChart;
		let currentChartPeriod = '7';
		
		// Initialize Dashboard
		$(document).ready(function() {
			// Load initial data
			loadDashboardData();
			loadCharts();
			loadRecentTransactions();
			loadRecentUsers();
			
			// Start auto-refresh
			startAutoRefresh();
			
			// Initialize tooltips
			$('[data-bs-toggle="tooltip"]').tooltip();
		});
		
		// Start Auto Refresh
		// Update the auto-refresh function
		if (autoRefresh) {
			refreshInterval = setInterval(function() {
				loadDashboardData();
				loadRecentTransactions();
				loadRecentUsers();
				loadRecentActivities('all'); // Add this line
			}, 300); // Refresh every 30 seconds
		}
		
		// Toggle Auto Refresh
		function toggleRefresh(status) {
			autoRefresh = status;
			$('#refreshStatus').text(status ? 'ON' : 'OFF');
			
			if (autoRefresh) {
				startAutoRefresh();
			} else {
				clearInterval(refreshInterval);
			}
			
			// Show notification
			showNotification(
				status ? 'Auto Refresh Enabled' : 'Auto Refresh Disabled',
				status ? 'success' : 'warning'
			);
		}
		
		// Manual Refresh
		function refreshDashboard() {
			loadDashboardData();
			loadCharts();
			loadRecentTransactions();
			loadRecentUsers();
			
			showNotification('Dashboard Refreshed', 'success');
		}


		
		
		// Load Dashboard Stats
		function loadDashboardData() {
			$.ajax({
				url: 'ajax/get_dashboard_stats.php',
				type: 'GET',
				dataType: 'json',
				success: function(data) {
					if (data.success) {
						// Update stats
						$('#totalUsers').text(data.total_users);
						$('#newUsersToday').text(data.new_users_today);
						$('#newUsersWeek').text(data.new_users_week);
						
						$('#activeSubscriptions').text(data.active_subscriptions);
						$('#activeBotsCount').text(data.active_bots);
						$('#expiredSubscriptions').text(data.expired_subscriptions);
						
						$('#pendingDeposits').text(data.pending_deposits);
						$('#pendingDepositsToday').text(data.pending_deposits_today);
						$('#pendingDepositsAmount').text(data.pending_deposits_amount);
						
						$('#pendingWithdrawals').text(data.pending_withdrawals);
						$('#pendingWithdrawalsToday').text(data.pending_withdrawals_today);
						$('#pendingWithdrawalsAmount').text(data.pending_withdrawals_amount);
						
						$('#totalProfit').text('$' + data.total_profit);
						$('#profitThisMonth').text(data.profit_this_month);
						
						$('#todaysProfit').text('$' + data.todays_profit);
						$('#yesterdayProfit').text(data.yesterday_profit);
						$('#profitChange').text(data.profit_change + '%');
						
						$('#activeBots').text(data.active_bots);
						$('#runningBots').text(data.running_bots);
						$('#idleBots').text(data.idle_bots);
						
						$('#openTickets').text(data.open_tickets);
						$('#newTickets').text(data.new_tickets);
						$('#inProgressTickets').text(data.in_progress_tickets);
					}
				},
				error: function() {
					console.log('Error loading dashboard stats');
				}
			});
		}
		
		// Load Charts
		function loadCharts() {
			loadRevenueProfitChart();
			loadBotPlanChart();
		}
		
		// Revenue & Profit Chart
		function loadRevenueProfitChart() {
			$.ajax({
				url: 'ajax/get_chart_data.php',
				type: 'GET',
				data: { period: currentChartPeriod, chart: 'revenue' },
				dataType: 'json',
				success: function(data) {
					if (data.success) {
						var options = {
							series: [
								{
									name: 'Revenue',
									data: data.revenue
								},
								{
									name: 'Profit',
									data: data.profit
								}
							],
							chart: {
								type: 'area',
								height: 300,
								toolbar: {
									show: false
								}
							},
							colors: ['#667eea', '#f093fb'],
							dataLabels: {
								enabled: false
							},
							stroke: {
								curve: 'smooth',
								width: 2
							},
							fill: {
								type: 'gradient',
								gradient: {
									shadeIntensity: 1,
									opacityFrom: 0.7,
									opacityTo: 0.3,
									stops: [0, 90, 100]
								}
							},
							xaxis: {
								categories: data.labels,
								labels: {
									style: {
										colors: '#8c8c8c'
									}
								}
							},
							yaxis: {
								labels: {
									formatter: function(value) {
										return '$' + value;
									},
									style: {
										colors: '#8c8c8c'
									}
								}
							},
							legend: {
								position: 'top',
								horizontalAlign: 'right'
							},
							grid: {
								borderColor: '#f1f1f1'
							}
						};
						
						if (revenueChart) {
							revenueChart.updateOptions(options);
						} else {
							revenueChart = new ApexCharts(document.querySelector("#revenue-profit-chart"), options);
							revenueChart.render();
						}
					}
				}
			});
		}
		
		// Bot Plan Distribution Chart
		function loadBotPlanChart() {
			$.ajax({
				url: 'ajax/get_chart_data.php',
				type: 'GET',
				data: { chart: 'bot_plan' },
				dataType: 'json',
				success: function(data) {
					if (data.success) {
						var options = {
							series: data.series,
							chart: {
								type: 'donut',
								height: 300
							},
							labels: data.labels,
							colors: ['#667eea', '#f093fb', '#4facfe', '#43e97b'],
							legend: {
								position: 'bottom'
							},
							responsive: [{
								breakpoint: 480,
								options: {
									chart: {
										width: 200
									},
									legend: {
										position: 'bottom'
									}
								}
							}]
						};
						
						if (botPlanChart) {
							botPlanChart.updateSeries(data.series);
						} else {
							botPlanChart = new ApexCharts(document.querySelector("#bot-plan-chart"), options);
							botPlanChart.render();
						}
					}
				}
			});
		}

		// Load Recent Admin Activities
		function loadRecentActivities(filter = 'all') {
			$.ajax({
				url: 'ajax/get_recent_activities.php',
				type: 'GET',
				data: { filter: filter },
				success: function(data) {
					$('#recentActivities').html(data);
				}
			});
		}

		// Filter Activities
		function filterActivities(filter) {
			loadRecentActivities(filter);
		}

		// Initialize with all activities
		loadRecentActivities('all');
		
		// Change Chart Period
		function changeChartPeriod(period) {
			currentChartPeriod = period;
			$('#chartPeriod').text(
				period === '7' ? 'Last 7 Days' : 
				period === '30' ? 'Last 30 Days' : 
				'Last 90 Days'
			);
			loadRevenueProfitChart();
		}
		
		// Load Recent Transactions
		function loadRecentTransactions() {
			$.ajax({
				url: 'ajax/get_recent_transactions.php',
				type: 'GET',
				success: function(data) {
					$('#recentTransactions').html(data);
					
					// Add click events to transaction rows
					$('.view-transaction').off('click').on('click', function(e) {
						e.preventDefault();
						var transactionId = $(this).data('id');
						viewTransactionDetails(transactionId);
					});
				}
			});
		}
		
		// Load Recent Users
		function loadRecentUsers() {
			$.ajax({
				url: 'ajax/get_recent_users.php',
				type: 'GET',
				success: function(data) {
					$('#recentUsers').html(data);
					
					// Add click events to user rows
					$('.view-user').off('click').on('click', function(e) {
						e.preventDefault();
						var userId = $(this).data('id');
						viewUserDetails(userId);
					});
				}
			});
		}
		
		// View Transaction Details
		function viewTransactionDetails(id) {
			$.ajax({
				url: 'ajax/get_transaction_details.php',
				type: 'GET',
				data: { id: id },
				success: function(data) {
					$('#transactionDetails').html(data);
					$('#transactionModal').modal('show');
					
					// Update process button based on status
					var status = $('#transactionStatus').val();
					if (status === 'pending') {
						$('#processTransactionBtn').show().text('Process Transaction');
					} else {
						$('#processTransactionBtn').hide();
					}
					
					// Process button click
					$('#processTransactionBtn').off('click').on('click', function() {
						processTransaction(id);
					});
				}
			});
		}
		
		// View User Details
		function viewUserDetails(id) {
			$.ajax({
				url: 'ajax/get_user_details.php',
				type: 'GET',
				data: { id: id },
				success: function(data) {
					$('#userDetails').html(data);
					$('#userModal').modal('show');
					
					// Update verify button based on status
					var status = $('#userStatus').val();
					if (status === 'pending') {
						$('#verifyUserBtn').show().text('Verify User');
					} else {
						$('#verifyUserBtn').hide();
					}
					
					// Verify button click
					$('#verifyUserBtn').off('click').on('click', function() {
						verifyUser(id);
					});
				}
			});
		}
		
		// Process Transaction
		function processTransaction(id) {
			if (confirm('Are you sure you want to process this transaction?')) {
				$.ajax({
					url: 'ajax/process_transaction.php',
					type: 'POST',
					data: { id: id },
					success: function(response) {
						var result = JSON.parse(response);
						if (result.success) {
							showNotification('Transaction processed successfully', 'success');
							$('#transactionModal').modal('hide');
							loadDashboardData();
							loadRecentTransactions();
						} else {
							showNotification(result.message, 'error');
						}
					}
				});
			}
		}
		
		// Verify User
		function verifyUser(id) {
			if (confirm('Are you sure you want to verify this user?')) {
				$.ajax({
					url: 'ajax/verify_user.php',
					type: 'POST',
					data: { id: id },
					success: function(response) {
						var result = JSON.parse(response);
						if (result.success) {
							showNotification('User verified successfully', 'success');
							$('#userModal').modal('hide');
							loadDashboardData();
							loadRecentUsers();
						} else {
							showNotification(result.message, 'error');
						}
					}
				});
			}
		}
		
		// Show Notification
		function showNotification(message, type) {
			var icon = type === 'success' ? 'fas fa-check-circle' : 
					   type === 'error' ? 'fas fa-exclamation-circle' : 
					   type === 'warning' ? 'fas fa-exclamation-triangle' : 
					   'fas fa-info-circle';
			
			var toast = '<div class="toast align-items-center text-bg-' + type + ' border-0" role="alert" aria-live="assertive" aria-atomic="true">' +
						'<div class="d-flex">' +
						'<div class="toast-body">' +
						'<i class="' + icon + ' me-2"></i>' + message +
						'</div>' +
						'<button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>' +
						'</div>' +
						'</div>';
			
			$('.toast-container').append(toast);
			var toastEl = $('.toast').last();
			var bsToast = new bootstrap.Toast(toastEl, { delay: 3000 });
			bsToast.show();
			
			// Remove toast after hide
			toastEl.on('hidden.bs.toast', function () {
				$(this).remove();
			});
		}
		</script>
		
		<!-- Custom CSS -->
		<style>
		.quick-action-box {
			transition: transform 0.3s ease, box-shadow 0.3s ease;
			border-radius: 10px;
			color: white;
			text-decoration: none;
		}
		.quick-action-box:hover {
			transform: translateY(-5px);
			box-shadow: 0 10px 20px rgba(0,0,0,0.1);
			color: white;
		}
		.quick-action-box .box-body {
			padding: 30px 20px;
		}
		.quick-action-box i {
			opacity: 0.9;
		}
		.quick-action-box h5 {
			font-weight: 600;
			margin-bottom: 5px;
		}
		.quick-action-box small {
			opacity: 0.8;
		}
		.pull-up {
			transition: transform 0.3s ease, box-shadow 0.3s ease;
		}
		.pull-up:hover {
			transform: translateY(-5px);
			box-shadow: 0 5px 20px rgba(0,0,0,0.1);
		}
		.bg-white-20 {
			background-color: rgba(255, 255, 255, 0.2);
		}
		.bg-dark-20 {
			background-color: rgba(0, 0, 0, 0.2);
		}
		.toast-container {
			position: fixed;
			top: 20px;
			right: 20px;
			z-index: 9999;
		}
		.table-hover tbody tr {
			cursor: pointer;
		}
		</style>
		
		<!-- Toast Container -->
		<div class="toast-container"></div>
		
	</body>
</html>