<?php
session_start();
include('includes/config.php');

$date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');
$bot_plan = isset($_GET['bot_plan']) ? intval($_GET['bot_plan']) : 0;
$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;

// Get daily transactions
$sql = "SELECT 
            t.*,
            u.username,
            u.email,
            p.plan_name
        FROM transactions t
        LEFT JOIN users u ON t.user_id = u.id
        LEFT JOIN user_bot_subscriptions s ON t.related_id = s.id AND t.related_type = 'bot_transaction'
        LEFT JOIN trading_bot_plans p ON s.bot_plan_id = p.id
        WHERE t.status = 'completed' 
          AND t.type IN ('profit', 'loss', 'fee')
          AND DATE(t.date) = '$date'";

if ($user_id > 0) {
    $sql .= " AND t.user_id = $user_id";
}

if ($bot_plan > 0) {
    $sql .= " AND s.bot_plan_id = $bot_plan";
}

$sql .= " ORDER BY t.created_at DESC";

$result = mysqli_query($conn, $sql);

// Get daily summary
$summary_sql = str_replace("ORDER BY t.created_at DESC", "", $sql);
$summary_sql = str_replace("t.*, u.username, u.email, p.plan_name", 
                          "COUNT(t.id) as total, 
                           SUM(CASE WHEN t.type = 'profit' THEN t.amount ELSE 0 END) as profit,
                           SUM(CASE WHEN t.type = 'loss' THEN t.amount ELSE 0 END) as loss,
                           SUM(CASE WHEN t.type = 'fee' THEN t.amount ELSE 0 END) as fees", 
                          $summary_sql);
$summary_result = mysqli_query($conn, $summary_sql);
$summary = mysqli_fetch_assoc($summary_result);
?>

<!DOCTYPE html>
<html lang="en">
  	
	
	<body class="hold-transition dark-skin sidebar-mini theme-primary fixed">
		
		<div class="wrapper">
		  	<div id="loader"></div>
		  	
		  <?php include('includes/header.php') ?>

		  <?php include('includes/sidebar.php') ?>

		  	<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<div class="container-full">
					<!-- Main content -->
					<section class="content">
						<div class="row">
							<div class="col-12">
								<div class="box">
									<div class="box-header">
										<div class="d-flex justify-content-between align-items-center">
											<div>
												<h4 class="box-title">
													<i class="fas fa-calendar-day me-2"></i>
													Daily Transactions: <?php echo date('F d, Y', strtotime($date)); ?>
												</h4>
												<p class="mb-0 text-mute">
													<?php echo $summary['total']; ?> transactions | 
													Net: <span class="<?php echo ($summary['profit'] - $summary['loss'] - $summary['fees']) >= 0 ? 'text-success' : 'text-danger'; ?> fw-500">
														$<?php echo number_format($summary['profit'] - $summary['loss'] - $summary['fees'], 2); ?>
													</span>
												</p>
											</div>
											<div>
												<a href="profit_loss.php" class="btn btn-light">
													<i class="fas fa-arrow-left me-1"></i> Back to Report
												</a>
											</div>
										</div>
									</div>
									<div class="box-body">
										<!-- Summary Cards -->
										<div class="row mb-20">
											<div class="col-md-4">
												<div class="box bg-success text-white">
													<div class="box-body text-center">
														<h2 class="fw-500">+ $<?php echo number_format($summary['profit'], 2); ?></h2>
														<p class="mb-0">Total Profit</p>
													</div>
												</div>
											</div>
											<div class="col-md-4">
												<div class="box bg-danger text-white">
													<div class="box-body text-center">
														<h2 class="fw-500">- $<?php echo number_format($summary['loss'], 2); ?></h2>
														<p class="mb-0">Total Loss</p>
													</div>
												</div>
											</div>
											<div class="col-md-4">
												<div class="box bg-warning text-white">
													<div class="box-body text-center">
														<h2 class="fw-500">$<?php echo number_format($summary['fees'], 2); ?></h2>
														<p class="mb-0">Total Fees</p>
													</div>
												</div>
											</div>
										</div>
										
										<!-- Transactions Table -->
										<div class="table-responsive">
											<table class="table table-hover">
												<thead>
													<tr>
														<th>Time</th>
														<th>User</th>
														<th>Type</th>
														<th>Bot Plan</th>
														<th>Amount</th>
														<th>Description</th>
														<th>Status</th>
													</tr>
												</thead>
												<tbody>
													<?php if (mysqli_num_rows($result) > 0): ?>
														<?php while ($txn = mysqli_fetch_assoc($result)): ?>
															<?php
															$type_color = $txn['type'] == 'profit' ? 'success' : 
																		($txn['type'] == 'loss' ? 'danger' : 'warning');
															$time = date('H:i:s', strtotime($txn['created_at']));
															?>
															<tr>
																<td><?php echo $time; ?></td>
																<td>
																	<?php if ($txn['username']): ?>
																		<a href="view_user.php?id=<?php echo $txn['user_id']; ?>" class="text-primary">
																			<?php echo htmlspecialchars($txn['username']); ?>
																		</a>
																		<br>
																		<small class="text-mute"><?php echo htmlspecialchars($txn['email']); ?></small>
																	<?php else: ?>
																		User #<?php echo $txn['user_id']; ?>
																	<?php endif; ?>
																</td>
																<td>
																	<span class="badge bg-<?php echo $type_color; ?>">
																		<?php echo ucfirst($txn['type']); ?>
																	</span>
																</td>
																<td>
																	<?php echo $txn['plan_name'] ? htmlspecialchars($txn['plan_name']) : 'N/A'; ?>
																</td>
																<td class="fw-500 <?php echo $txn['type'] == 'profit' ? 'text-success' : 'text-danger'; ?>">
																	<?php echo $txn['type'] == 'profit' ? '+' : '-'; ?>
																	$<?php echo number_format($txn['amount'], 2); ?>
																</td>
																<td>
																	<small><?php echo htmlspecialchars($txn['description']); ?></small>
																</td>
																<td>
																	<span class="badge bg-success">Completed</span>
																</td>
															</tr>
														<?php endwhile; ?>
													<?php else: ?>
														<tr>
															<td colspan="7" class="text-center py-20">
																<i class="fas fa-exchange-alt fa-2x text-mute mb-3"></i>
																<h5>No transactions found</h5>
																<p class="text-mute">No transactions for selected date</p>
															</td>
														</tr>
													<?php endif; ?>
												</tbody>
											</table>
										</div>
									</div>
								</div>
							</div>
						</div>
					</section>
				</div>
			</div>
		</div>
		
		  <?php include('includes/scripts.php') ?>
	</body>
</html>