<?php session_start();
// make_payment.php
include 'includes/head.php';



// Generate ticket number
function generateTicketNumber() {
    return 'TKT-' . date('Ymd') . '-' . strtoupper(substr(uniqid(), -6));
}

$success = '';
$error = '';


?>
<!DOCTYPE html>
<html lang="en">

<title>Create Support Ticket - E-Finance Loans</title>


<style>
    .ticket-preview {
        background: #f8f9fa;
        border-radius: 10px;
        padding: 20px;
        margin-top: 20px;
        display: none;
    }
    .priority-badge {
        font-size: 0.8em;
        padding: 4px 8px;
    }
    .form-label.required:after {
        content: " *";
        color: #dc3545;
    }
</style>

<body class="dashboard">
    <div id="main-wrapper">
        <!-- Header would be included here -->
         <?php include('includes/header.php');?>
         <?php include('includes/sidebar.php');?>
        <!-- Sidebar would be included here -->
        <div class="content-body">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title">
                            <div class="row align-items-center justify-content-between">
                                <div class="col-xl-4">
                                    <div class="page-title-content">
                                        <h3>Create Support Ticket</h3>
                                        <p class="mb-2">Get help with your loan account and services</p>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <div class="breadcrumbs">
                                        <a href="dashboard.php">Home</a>
                                        <span><i class="fi fi-rr-angle-small-right"></i></span>
                                        <a href="support.php">Support</a>
                                        <span><i class="fi fi-rr-angle-small-right"></i></span>
                                        <a href="#">Create Ticket</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Success/Error Messages -->
                <?php if(!empty($success)): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fi fi-rr-check me-2"></i>
                            <?php echo $success; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if(!empty($error)): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fi fi-rr-exclamation me-2"></i>
                            <?php echo $error; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <div class="row">
                    <div class="col-xl-8">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="card-title mb-0">Create New Support Ticket</h4>
                                <a href="support.php" class="btn btn-outline-secondary btn-sm">Cancel</a>
                            </div>
                            <div class="card-body">
                                <div id="result"></div>
                                <form id="ticketForm">
                                    <div class="mb-4">
                                        <label class="form-label required">Subject</label>
                                        <input type="text" class="form-control" name="subject" 
                                               placeholder="Brief description of your issue" 
                                               value="<?php echo isset($_POST['subject']) ? htmlspecialchars($_POST['subject']) : ''; ?>" 
                                               required>
                                        <small class="text-muted">Summarize your issue in a few words</small>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label required">Category</label>
                                                <select class="form-select" name="category" required>
                                                    <option value="">Select category</option>
                                                    <option value="loan_application" <?php echo (isset($_POST['category']) && $_POST['category'] == 'loan_application') ? 'selected' : ''; ?>>Loan Application</option>
                                                    <option value="repayment" <?php echo (isset($_POST['category']) && $_POST['category'] == 'repayment') ? 'selected' : ''; ?>>Repayment Issues</option>
                                                    <option value="account" <?php echo (isset($_POST['category']) && $_POST['category'] == 'account') ? 'selected' : ''; ?>>Account Management</option>
                                                    <option value="technical" <?php echo (isset($_POST['category']) && $_POST['category'] == 'technical') ? 'selected' : ''; ?>>Technical Support</option>
                                                    <option value="dispute" <?php echo (isset($_POST['category']) && $_POST['category'] == 'dispute') ? 'selected' : ''; ?>>Loan Dispute</option>
                                                    <option value="general" <?php echo (isset($_POST['category']) && $_POST['category'] == 'general') ? 'selected' : ''; ?>>General Inquiry</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label required">Priority</label>
                                                <select class="form-select" name="priority" required>
                                                    <option value="low" <?php echo (isset($_POST['priority']) && $_POST['priority'] == 'low') ? 'selected' : ''; ?>>Low</option>
                                                    <option value="medium" <?php echo (isset($_POST['priority']) && $_POST['priority'] == 'medium') ? 'selected' : ''; ?>>Medium</option>
                                                    <option value="high" <?php echo (isset($_POST['priority']) && $_POST['priority'] == 'high') ? 'selected' : ''; ?>>High</option>
                                                    <option value="urgent" <?php echo (isset($_POST['priority']) && $_POST['priority'] == 'urgent') ? 'selected' : ''; ?>>Urgent</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- <div class="mb-3">
                                        <label class="form-label">Preferred Response Language</label>
                                        <select class="form-select" name="language">
                                            <option value="english" <?php echo (isset($_POST['language']) && $_POST['language'] == 'english') ? 'selected' : 'selected'; ?>>English</option>
                                            <option value="afrikaans" <?php echo (isset($_POST['language']) && $_POST['language'] == 'afrikaans') ? 'selected' : ''; ?>>Afrikaans</option>
                                            <option value="zulu" <?php echo (isset($_POST['language']) && $_POST['language'] == 'zulu') ? 'selected' : ''; ?>>isiZulu</option>
                                            <option value="xhosa" <?php echo (isset($_POST['language']) && $_POST['language'] == 'xhosa') ? 'selected' : ''; ?>>isiXhosa</option>
                                        </select>
                                    </div> -->

                                    <div class="mb-4">
                                        <label class="form-label required">Problem Description</label>
                                        <textarea rows="8" class="form-control" name="description" 
                                                  placeholder="Please provide a detailed description of the problem you are encountering..." 
                                                  required><?php echo isset($_POST['description']) ? htmlspecialchars($_POST['description']) : ''; ?></textarea>
                                        <small class="text-muted">
                                            Include any error messages, steps to reproduce the issue, and what you were trying to accomplish.
                                        </small>
                                    </div>

                                    <div class="d-flex justify-content-between align-items-center">
                                        <button type="button" class="btn btn-outline-primary" onclick="previewTicket()">
                                            <i class="fi fi-rr-eye me-2"></i>Preview Ticket
                                        </button>
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fi fi-rr-paper-plane me-2"></i>Create Ticket
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-4">
                        <!-- Ticket Preview -->
                        
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Ticket Preview</h5>
                            </div>
                            <div class="card-body">
                                <div id="ticketPreview" class="ticket-preview">
                                    <div class="mb-3">
                                        <strong>Subject:</strong>
                                        <div id="previewSubject" class="text-primary"></div>
                                    </div>
                                    <div class="mb-3">
                                        <strong>Category:</strong>
                                        <div id="previewCategory"></div>
                                    </div>
                                    <div class="mb-3">
                                        <strong>Priority:</strong>
                                        <span id="previewPriority" class="badge priority-badge"></span>
                                    </div>
                                    <div class="mb-3">
                                        <strong>Language:</strong>
                                        <div id="previewLanguage"></div>
                                    </div>
                                    <div>
                                        <strong>Description:</strong>
                                        <div id="previewDescription" class="mt-2 p-2 bg-light rounded"></div>
                                    </div>
                                </div>
                                <div id="emptyPreview" class="text-center text-muted py-4">
                                    <i class="fi fi-rr-document fs-1 mb-3"></i>
                                    <p>Fill out the form to preview your ticket</p>
                                </div>
                            </div>
                        </div>

                        <!-- Help Tips -->
                        <div class="card mt-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0">💡 Help Tips</h5>
                            </div>
                            <div class="card-body">
                                <ul class="list-unstyled small">
                                    <li class="mb-2">
                                        <i class="fi fi-rr-info text-primary me-2"></i>
                                        <strong>Be specific</strong> - Include loan numbers if applicable
                                    </li>
                                    <li class="mb-2">
                                        <i class="fi fi-rr-time-fast text-warning me-2"></i>
                                        <strong>Response time</strong> - Usually within 2-4 business hours
                                    </li>
                                    <li class="mb-2">
                                        <i class="fi fi-rr-document text-info me-2"></i>
                                        <strong>Attach screenshots</strong> - Email them to support@E-Financeloans.co.za
                                    </li>
                                    <li>
                                        <i class="fi fi-rr-phone-call text-success me-2"></i>
                                        <strong>Urgent issues?</strong> Call 0861 123 456
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <!-- Common Issues -->
                        <div class="card mt-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0">🚀 Quick Solutions</h5>
                            </div>
                            <div class="card-body">
                                <div class="accordion" id="quickSolutions">
                                    <div class="accordion-item">
                                        <h6 class="accordion-header">
                                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#solution1">
                                                Loan Application Pending?
                                            </button>
                                        </h6>
                                        <div id="solution1" class="accordion-collapse collapse" data-bs-parent="#quickSolutions">
                                            <div class="accordion-body small">
                                                Most applications are processed within 24-48 hours. Ensure all documents are uploaded clearly.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="accordion-item">
                                        <h6 class="accordion-header">
                                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#solution2">
                                                Payment Not Reflected?
                                            </button>
                                        </h6>
                                        <div id="solution2" class="accordion-collapse collapse" data-bs-parent="#quickSolutions">
                                            <div class="accordion-body small">
                                                Bank transfers can take 1-3 business days. Keep your proof of payment handy.
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer">
            <div class="container">
                <div class="row">
                    <div class="col-xl-6">
                        <div class="copyright">
                            <p>© Copyright
                                <script>
                                    var CurrentYear = new Date().getFullYear()
                                    document.write(CurrentYear)
                                </script>
                                <a href="#"> E-Finance Loans</a> | All Rights Reserved
                            </p>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="footer-social">
                            <ul>
                                <li><a href="#"><i class="fi fi-brands-facebook"></i></a></li>
                                <li><a href="#"><i class="fi fi-brands-twitter"></i></a></li>
                                <li><a href="#"><i class="fi fi-brands-linkedin"></i></a></li>
                                <li><a href="#"><i class="fi fi-brands-youtube"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
     <?php include('includes/footer.php');?>

    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>


    <script>
        $(document).ready(function(){
            $("#ticketForm").submit(function(event){
                // Stop form from submitting normally
                event.preventDefault();
                $("#pageloader").show();
                /* Serialize the submitted form control values to be sent to the web server with the request */
                var formValues = $(this).serialize();
                
                // Send the form data using post
                $.post("proccess/create_ticket.php", formValues, function(data){
                    // Display the returned data in browser
                    $("#result").html(data);
                    $("#pageloader").hide();
                });
            });
        });
    </script>
    
    <script>
    function previewTicket() {
        const subject = document.querySelector('input[name="subject"]').value;
        const category = document.querySelector('select[name="category"]');
        const categoryText = category.options[category.selectedIndex].text;
        const priority = document.querySelector('select[name="priority"]').value;
        const language = document.querySelector('select[name="language"]');
        const languageText = language.options[language.selectedIndex].text;
        const description = document.querySelector('textarea[name="description"]').value;

        if (!subject || !description) {
            alert('Please fill in the subject and description to preview.');
            return;
        }

        // Update preview
        document.getElementById('previewSubject').textContent = subject;
        document.getElementById('previewCategory').textContent = categoryText;
        document.getElementById('previewLanguage').textContent = languageText;
        document.getElementById('previewDescription').textContent = description;

        // Set priority badge
        const priorityBadge = document.getElementById('previewPriority');
        priorityBadge.textContent = priority.charAt(0).toUpperCase() + priority.slice(1);
        priorityBadge.className = 'badge priority-badge bg-' + 
            (priority === 'urgent' ? 'danger' : 
             priority === 'high' ? 'warning' : 
             priority === 'medium' ? 'info' : 'secondary');

        // Show preview
        document.getElementById('ticketPreview').style.display = 'block';
        document.getElementById('emptyPreview').style.display = 'none';
    }

    // Auto-preview when form changes
    /*document.addEventListener('DOMContentLoaded', function() {
        const formElements = document.querySelectorAll('#ticketForm input, #ticketForm select, #ticketForm textarea');
        formElements.forEach(function(element) {
            element.addEventListener('change', function() {
                // Small delay to ensure values are updated
                setTimeout(previewTicket, 100);
            });
        });

        // Auto-preview if form has values
        const subject = document.querySelector('input[name="subject"]').value;
        const description = document.querySelector('textarea[name="description"]').value;
        if (subject || description) {
            previewTicket();
        }
    }); */
    </script>
</body>
</html>
<?php mysqli_close($conn); ?>