<?php session_start();
// bank_linking.php
include 'includes/head.php';


$user_email = $userEmail;
$user_name = $userName;

$success = '';
$error = '';


// Get user's recent loans for reference dropdown
$loans_sql = "SELECT id, loan_amount, loan_purpose FROM loan_applications WHERE user_id = '$user_id' ORDER BY created_at DESC LIMIT 10";
$loans_result = mysqli_query($conn, $loans_sql);
?>
<!DOCTYPE html>
<html lang="en">


<style>
    .feedback-card {
        border: none;
        border-radius: 15px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }
    .rating-stars {
        display: flex;
        gap: 5px;
        margin: 10px 0;
    }
    .star {
        font-size: 2rem;
        color: #ddd;
        cursor: pointer;
        transition: color 0.2s ease;
    }
    .star:hover,
    .star.active {
        color: #ffc107;
    }
    .feedback-type-card {
        border: 2px solid #e9ecef;
        border-radius: 10px;
        padding: 20px;
        text-align: center;
        cursor: pointer;
        transition: all 0.3s ease;
        margin-bottom: 15px;
    }
    .feedback-type-card:hover {
        border-color: #007bff;
        background-color: #b1e33bff;
    }
    .feedback-type-card.selected {
        border-color: #007bff;
        background-color: #19ba54ff;
    }
    .type-icon {
        font-size: 2rem;
        margin-bottom: 10px;
    }
    .type-complaint { color: #dc3545; }
    .type-suggestion { color: #28a745; }
    .type-dispute { color: #ffc107; }
    .type-general { color: #6c757d; }
    .character-count {
        font-size: 0.8rem;
        text-align: right;
        margin-top: 5px;
    }
    .character-count.warning {
        color: #ffc107;
    }
    .character-count.danger {
        color: #dc3545;
    }
</style>


<body class="dashboard">
    <div id="main-wrapper">
        
        <?php include('includes/header.php');?>
        <?php include('includes/sidebar.php');?>

        <div class="content-body">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title">
                            <div class="row align-items-center justify-content-between">
                                <div class="col-xl-4">
                                    <div class="page-title-content">
                                        <h3>Feedback & Suggestions</h3>
                                        <p class="mb-2">Help us improve our services</p>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <div class="breadcrumbs">
                                        <a href="dashboard.php">Home</a>
                                        <span><i class="fi fi-rr-angle-small-right"></i></span>
                                        <a href="support.php">Support</a>
                                        <span><i class="fi fi-rr-angle-small-right"></i></span>
                                        <a href="#">Feedback</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Success/Error Messages -->
                <?php if(!empty($success)): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fi fi-rr-check me-2"></i>
                            <?php echo $success; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if(!empty($error)): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fi fi-rr-exclamation me-2"></i>
                            <?php echo $error; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <div class="row">
                    <div class="col-xl-8">
                        <div class="card feedback-card">
                            <div class="card-header">
                                <h4 class="card-title mb-0">Share Your Feedback</h4>
                            </div>
                            <div class="card-body">
                                <form id="feedbackForm">
                                    <!-- Feedback Type Selection -->
                                    <div class="mb-4">
                                        <label class="form-label required">What type of feedback would you like to share?</label>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="feedback-type-card" data-type="complaint" onclick="selectType('complaint')">
                                                    <div class="type-icon type-complaint">
                                                        <i class="fi fi-rr-comment-exclamation"></i>
                                                    </div>
                                                    <h6>Complaint</h6>
                                                    <p class="small text-muted mb-0">Report an issue or problem</p>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="feedback-type-card" data-type="suggestion" onclick="selectType('suggestion')">
                                                    <div class="type-icon type-suggestion">
                                                        <i class="fi fi-rr-lightbulb"></i>
                                                    </div>
                                                    <h6>Suggestion</h6>
                                                    <p class="small text-muted mb-0">Share ideas for improvement</p>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="feedback-type-card" data-type="dispute" onclick="selectType('dispute')">
                                                    <div class="type-icon type-dispute">
                                                        <i class="fi fi-rr-shield-exclamation"></i>
                                                    </div>
                                                    <h6>Dispute</h6>
                                                    <p class="small text-muted mb-0">Challenge a transaction or charge</p>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="feedback-type-card" data-type="general" onclick="selectType('general')">
                                                    <div class="type-icon type-general">
                                                        <i class="fi fi-rr-comment"></i>
                                                    </div>
                                                    <h6>General Feedback</h6>
                                                    <p class="small text-muted mb-0">Share general thoughts</p>
                                                </div>
                                            </div>
                                        </div>
                                        <input type="hidden" name="type" id="feedbackType" required>
                                    </div>

                                    <!-- Rating Section -->
                                    <div class="mb-4" id="ratingSection">
                                        <label class="form-label required">How would you rate your experience?</label>
                                        <div class="rating-stars" id="starRating">
                                            <span class="star" data-rating="1">★</span>
                                            <span class="star" data-rating="2">★</span>
                                            <span class="star" data-rating="3">★</span>
                                            <span class="star" data-rating="4">★</span>
                                            <span class="star" data-rating="5">★</span>
                                        </div>
                                        <div class="d-flex justify-content-between">
                                            <small class="text-muted">Poor</small>
                                            <small class="text-muted">Excellent</small>
                                        </div>
                                        <input type="hidden" name="rating" id="selectedRating" value="0">
                                    </div>

                                    <!-- Personal Information -->
                                    <div class="row mb-4">
                                        <div class="col-md-6">
                                            <label class="form-label required">Your Name</label>
                                            <input type="text" class="form-control" name="name" 
                                                   value="<?php echo isset($_POST['name']) ? htmlspecialchars($_POST['name']) : htmlspecialchars($user_name); ?>" 
                                                   required>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label required">Email Address</label>
                                            <input type="email" class="form-control" name="email" 
                                                   value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : htmlspecialchars($user_email); ?>" 
                                                   required>
                                        </div>
                                    </div>

                                    <!-- Loan Reference (Optional) -->
                                    <div class="mb-4" id="loanReferenceSection">
                                        <label class="form-label">Related Loan (Optional)</label>
                                        <select class="form-select" name="loan_reference" id="loanReference">
                                            <option value="">Select a loan reference</option>
                                            <?php while($loan = mysqli_fetch_assoc($loans_result)): ?>
                                            <option value="<?php echo $loan['id']; ?>" 
                                                <?php echo (isset($_POST['loan_reference']) && $_POST['loan_reference'] == $loan['id']) ? 'selected' : ''; ?>>
                                                Loan #<?php echo $loan['id']; ?> - R <?php echo number_format($loan['loan_amount'], 2); ?> - <?php echo htmlspecialchars($loan['loan_purpose']); ?>
                                            </option>
                                            <?php endwhile; ?>
                                        </select>
                                        <small class="text-muted">Select if your feedback is related to a specific loan</small>
                                    </div>

                                    <!-- Subject -->
                                    <div class="mb-4">
                                        <label class="form-label required">Subject</label>
                                        <input type="text" class="form-control" name="subject" 
                                               placeholder="Brief summary of your feedback"
                                               value="<?php echo isset($_POST['subject']) ? htmlspecialchars($_POST['subject']) : ''; ?>" 
                                               required>
                                    </div>

                                    <!-- Message -->
                                    <div class="mb-4">
                                        <label class="form-label required">Your Feedback</label>
                                        <textarea rows="8" class="form-control" name="message" 
                                                  placeholder="Please provide detailed feedback about your experience..."
                                                  oninput="updateCharacterCount(this)"
                                                  required><?php echo isset($_POST['message']) ? htmlspecialchars($_POST['message']) : ''; ?></textarea>
                                        <div class="character-count" id="characterCount">
                                            <span id="charCount">0</span>/2000 characters
                                        </div>
                                        <small class="text-muted">
                                            Be specific and include any relevant details that will help us understand your feedback better.
                                        </small>
                                    </div>

                                    <!-- Submit Button -->
                                    <div class="d-flex justify-content-between align-items-center">
                                        <small class="text-muted">
                                            <i class="fi fi-rr-info me-1"></i>
                                            We review all feedback and respond within 2 business days
                                        </small>
                                        <button type="submit" class="btn btn-primary btn-lg">
                                            <i class="fi fi-rr-paper-plane me-2"></i>Submit Feedback
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-4">
                        <!-- Feedback Guidelines -->
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">📝 Feedback Guidelines</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <h6 class="text-primary">For Effective Feedback:</h6>
                                    <ul class="small">
                                        <li class="mb-2">Be specific and provide examples</li>
                                        <li class="mb-2">Include relevant loan numbers if applicable</li>
                                        <li class="mb-2">Describe what happened and when</li>
                                        <li>Suggest how we can improve</li>
                                    </ul>
                                </div>
                                <div class="mb-3">
                                    <h6 class="text-success">What Happens Next:</h6>
                                    <ul class="small">
                                        <li class="mb-2">We review all feedback within 48 hours</li>
                                        <li class="mb-2">You may receive a follow-up email</li>
                                        <li class="mb-2">We use feedback to improve our services</li>
                                        <li>Your input helps other customers</li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <!-- Response Times -->
                        <div class="card mt-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0">⏱️ Expected Response Times</h5>
                            </div>
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <span class="text-danger">Complaints & Disputes</span>
                                    <span class="badge bg-danger">24-48 hours</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <span class="text-success">Suggestions</span>
                                    <span class="badge bg-success">2-5 business days</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="text-info">General Feedback</span>
                                    <span class="badge bg-info">3-7 business days</span>
                                </div>
                            </div>
                        </div>

                        <!-- Alternative Contact Methods -->
                        <div class="card mt-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0">📞 Need Immediate Help?</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <strong>Phone Support</strong>
                                    <div class="small text-muted">0861 123 456</div>
                                    <small>Mon-Fri: 8AM-6PM | Sat: 9AM-1PM</small>
                                </div>
                                <div class="mb-3">
                                    <strong>Email Support</strong>
                                    <div class="small text-muted">support@E-Financeloans.co.za</div>
                                </div>
                                <div>
                                    <strong>Live Chat</strong>
                                    <div class="small text-muted">Available 24/7 on our website</div>
                                </div>
                            </div>
                        </div>

                        <!-- Privacy Notice -->
                        <div class="card mt-4">
                            <div class="card-body">
                                <h6 class="text-info mb-2">🔒 Your Privacy</h6>
                                <p class="small text-muted mb-0">
                                    All feedback is treated confidentially. We only use your information to improve our services and respond to your concerns in accordance with POPI Act regulations.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <?php include('includes/footer.php');?>
    </div>

    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script>
        $(document).ready(function(){
            $("#feedbackForm").submit(function(event){
                // Stop form from submitting normally
                event.preventDefault();
                //$("#pageloader").show();
                /* Serialize the submitted form control values to be sent to the web server with the request */
                var formValues = $(this).serialize();
                
                // Send the form data using post
                $.post("proccess/feedback.php", formValues, function(data){
                    // Display the returned data in browser
                    $("#result").html(data);
                    $("#pageloader").hide();
                });
            });
        });
    </script>
    <script>
    let currentRating = 0;
    let currentType = '';

    function selectType(type) {
        currentType = type;
        
        // Update visual selection
        document.querySelectorAll('.feedback-type-card').forEach(card => {
            card.classList.remove('selected');
        });
        document.querySelector(`.feedback-type-card[data-type="${type}"]`).classList.add('selected');
        
        // Update hidden input
        document.getElementById('feedbackType').value = type;
        
        // Show/hide rating based on type
        if (type === 'suggestion') {
            document.getElementById('ratingSection').style.display = 'none';
            document.getElementById('selectedRating').value = 0;
        } else {
            document.getElementById('ratingSection').style.display = 'block';
        }
        
        // Show/hide loan reference based on type
        if (type === 'complaint' || type === 'dispute') {
            document.getElementById('loanReferenceSection').style.display = 'block';
        } else {
            document.getElementById('loanReferenceSection').style.display = 'none';
            document.getElementById('loanReference').value = '';
        }
    }

    // Star rating functionality
    document.querySelectorAll('.star').forEach(star => {
        star.addEventListener('click', function() {
            const rating = parseInt(this.getAttribute('data-rating'));
            currentRating = rating;
            document.getElementById('selectedRating').value = rating;
            
            // Update star appearances
            document.querySelectorAll('.star').forEach(s => {
                const starRating = parseInt(s.getAttribute('data-rating'));
                if (starRating <= rating) {
                    s.classList.add('active');
                } else {
                    s.classList.remove('active');
                }
            });
        });
        
        star.addEventListener('mouseover', function() {
            const rating = parseInt(this.getAttribute('data-rating'));
            document.querySelectorAll('.star').forEach(s => {
                const starRating = parseInt(s.getAttribute('data-rating'));
                if (starRating <= rating) {
                    s.style.color = '#ffc107';
                } else {
                    s.style.color = '#ddd';
                }
            });
        });
        
        star.addEventListener('mouseout', function() {
            document.querySelectorAll('.star').forEach(s => {
                const starRating = parseInt(s.getAttribute('data-rating'));
                if (starRating <= currentRating) {
                    s.style.color = '#ffc107';
                } else {
                    s.style.color = '#ddd';
                }
            });
        });
    });

    function updateCharacterCount(textarea) {
        const count = textarea.value.length;
        const countElement = document.getElementById('charCount');
        const counterElement = document.getElementById('characterCount');
        
        countElement.textContent = count;
        
        // Update color based on count
        counterElement.className = 'character-count';
        if (count > 1500) {
            counterElement.classList.add('warning');
        }
        if (count > 1900) {
            counterElement.classList.add('danger');
        }
    }

    // Form validation
    document.getElementById('feedbackForm').addEventListener('submit', function(e) {
        const type = document.getElementById('feedbackType').value;
        const rating = document.getElementById('selectedRating').value;
        
        if (!type) {
            e.preventDefault();
            Swal.fire({
                title: 'All Fields Required',
                text: 'Please select a feedback type.',
                icon: 'error',
                background: '#ffffff',   // white background
                color: '#000000',        // black text
                confirmButtonColor: '#3085d6' // bootstrap blue button
            });
            //alert('Please select a feedback type.');
            return;
        }
        
        if (type !== 'suggestion' && rating == 0) {
            e.preventDefault();
            Swal.fire({
                title: 'All Fields Required',
                text: 'Please provide a rating for your feedback.',
                icon: 'error',
                background: '#ffffff',   // white background
                color: '#000000',        // black text
                confirmButtonColor: '#3085d6' // bootstrap blue button
            });
           // alert('Please provide a rating for your feedback.');
            return;
        }
    });

    // Initialize character count
    document.addEventListener('DOMContentLoaded', function() {
        const textarea = document.querySelector('textarea[name="message"]');
        if (textarea.value) {
            updateCharacterCount(textarea);
        }
        
        // Set initial type if coming from URL parameter
        const urlParams = new URLSearchParams(window.location.search);
        const typeParam = urlParams.get('type');
        if (typeParam && ['complaint', 'suggestion', 'dispute', 'general'].includes(typeParam)) {
            selectType(typeParam);
        }
    });
    </script>
</body>
</html>
<?php mysqli_close($conn); ?>