<?php
session_start();
include 'session.php';

if (!isset($_GET['type']) || !isset($_GET['id'])) {
    die('Invalid request');
}

$type = $_GET['type'];
$id = intval($_GET['id']);
$details = [];

switch ($type) {
    case 'deposit':
        $sql = "SELECT d.*, u.username, u.email 
                FROM deposits d 
                JOIN users u ON d.user_id = u.id 
                WHERE d.id = '$id' AND d.user_id = '$user_id'";
        $result = mysqli_query($conn, $sql);
        $details = mysqli_fetch_assoc($result);
        $title = 'USDT Deposit Details';
        break;
        
    case 'withdrawal':
        $sql = "SELECT w.*, u.username, u.email 
                FROM withdrawals w 
                JOIN users u ON w.user_id = u.id 
                WHERE w.id = '$id' AND w.user_id = '$user_id'";
        $result = mysqli_query($conn, $sql);
        $details = mysqli_fetch_assoc($result);
        $title = 'USDT Withdrawal Details';
        break;
        
    default:
        $sql = "SELECT t.*, u.username, u.email 
                FROM transactions t 
                JOIN users u ON t.user_id = u.id 
                WHERE t.id = '$id' AND t.user_id = '$user_id'";
        $result = mysqli_query($conn, $sql);
        $details = mysqli_fetch_assoc($result);
        $title = 'Transaction Details';
        break;
}

if (!$details) {
    die('Transaction not found');
}

function getStatusBadgeClass($status) {
    switch ($status) {
        case 'completed':
        case 'confirmed':
            return 'bg-success';
        case 'pending':
            return 'bg-warning';
        case 'processing':
            return 'bg-info';
        case 'rejected':
        case 'failed':
        case 'cancelled':
            return 'bg-danger';
        default:
            return 'bg-secondary';
    }
}

function getStatusText($status) {
    switch ($status) {
        case 'completed':
        case 'confirmed':
            return 'Completed';
        case 'pending':
            return 'Pending';
        case 'processing':
            return 'Processing';
        case 'rejected':
            return 'Rejected';
        case 'cancelled':
            return 'Cancelled';
        case 'failed':
            return 'Failed';
        default:
            return ucfirst($status);
    }
}
?>

<div class="transaction-details">
    <h5 class="mb-4"><?php echo $title; ?></h5>
    
    <table class="table table-bordered">
        <tbody>
            <?php if ($type == 'deposit'): ?>
            <tr>
                <th>Deposit ID</th>
                <td>#<?php echo $details['id']; ?></td>
            </tr>
            <tr>
                <th>Amount</th>
                <td class="text-success fw-bold">+$<?php echo number_format($details['amount'], 2); ?></td>
            </tr>
            <tr>
                <th>Transaction Hash</th>
                <td><code><?php echo htmlspecialchars($details['transaction_hash']); ?></code></td>
            </tr>
            <tr>
                <th>Status</th>
                <td>
                    <span class="badge <?php echo getStatusBadgeClass($details['status']); ?>">
                        <?php echo getStatusText($details['status']); ?>
                    </span>
                </td>
            </tr>
            <?php if (!empty($details['note'])): ?>
            <tr>
                <th>Note</th>
                <td><?php echo htmlspecialchars($details['note']); ?></td>
            </tr>
            <?php endif; ?>
            <?php if (!empty($details['confirmed_by'])): ?>
            <tr>
                <th>Confirmed By</th>
                <td>Admin #<?php echo $details['confirmed_by']; ?></td>
            </tr>
            <?php endif; ?>
            <?php if (!empty($details['confirmed_at'])): ?>
            <tr>
                <th>Confirmed At</th>
                <td><?php echo date('M j, Y g:i A', strtotime($details['confirmed_at'])); ?></td>
            </tr>
            <?php endif; ?>
            
            <?php elseif ($type == 'withdrawal'): ?>
            <tr>
                <th>Withdrawal ID</th>
                <td>#<?php echo $details['id']; ?></td>
            </tr>
            <tr>
                <th>Amount</th>
                <td class="text-warning fw-bold">-$<?php echo number_format($details['amount'], 2); ?></td>
            </tr>
            <tr>
                <th>Fee</th>
                <td>$<?php echo number_format($details['fee'], 2); ?></td>
            </tr>
            <tr>
                <th>Total Sent</th>
                <td>$<?php echo number_format($details['total_amount'], 2); ?></td>
            </tr>
            <tr>
                <th>Destination Address</th>
                <td><code><?php echo htmlspecialchars($details['destination_address']); ?></code></td>
            </tr>
            <tr>
                <th>Status</th>
                <td>
                    <span class="badge <?php echo getStatusBadgeClass($details['status']); ?>">
                        <?php echo getStatusText($details['status']); ?>
                    </span>
                </td>
            </tr>
            <?php if (!empty($details['transaction_hash'])): ?>
            <tr>
                <th>Transaction Hash</th>
                <td><code><?php echo htmlspecialchars($details['transaction_hash']); ?></code></td>
            </tr>
            <?php endif; ?>
            <?php if (!empty($details['processed_by'])): ?>
            <tr>
                <th>Processed By</th>
                <td>Admin #<?php echo $details['processed_by']; ?></td>
            </tr>
            <?php endif; ?>
            <?php if (!empty($details['processed_at'])): ?>
            <tr>
                <th>Processed At</th>
                <td><?php echo date('M j, Y g:i A', strtotime($details['processed_at'])); ?></td>
            </tr>
            <?php endif; ?>
            
            <?php else: ?>
            <tr>
                <th>Transaction ID</th>
                <td>#<?php echo $details['id']; ?></td>
            </tr>
            <tr>
                <th>Type</th>
                <td>
                    <?php if (in_array($details['type'], ['credit', 'profit'])): ?>
                        <span class="badge bg-success">Credit</span>
                    <?php else: ?>
                        <span class="badge bg-danger">Debit</span>
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <th>Amount</th>
                <td class="<?php echo in_array($details['type'], ['credit', 'profit']) ? 'text-success' : 'text-danger'; ?> fw-bold">
                    <?php echo in_array($details['type'], ['credit', 'profit']) ? '+' : '-'; ?>
                    $<?php echo number_format($details['amount'], 2); ?>
                </td>
            </tr>
            <tr>
                <th>Description</th>
                <td><?php echo htmlspecialchars($details['description']); ?></td>
            </tr>
            <tr>
                <th>Category</th>
                <td><?php echo ucfirst(str_replace('_', ' ', $details['category'])); ?></td>
            </tr>
            <tr>
                <th>Currency</th>
                <td><?php echo strtoupper($details['currency']); ?></td>
            </tr>
            <tr>
                <th>Status</th>
                <td>
                    <span class="badge <?php echo getStatusBadgeClass($details['status']); ?>">
                        <?php echo getStatusText($details['status']); ?>
                    </span>
                </td>
            </tr>
            <?php if (!empty($details['reference'])): ?>
            <tr>
                <th>Reference</th>
                <td><?php echo htmlspecialchars($details['reference']); ?></td>
            </tr>
            <?php endif; ?>
            <?php if (!empty($details['balance_after'])): ?>
            <tr>
                <th>Balance After</th>
                <td>$<?php echo number_format($details['balance_after'], 2); ?></td>
            </tr>
            <?php endif; ?>
            <?php endif; ?>
            
            <tr>
                <th>Created At</th>
                <td><?php echo date('M j, Y g:i A', strtotime($details['created_at'])); ?></td>
            </tr>
            <tr>
                <th>User</th>
                <td><?php echo htmlspecialchars($details['username']); ?> (<?php echo htmlspecialchars($details['email']); ?>)</td>
            </tr>
        </tbody>
    </table>
    
    <?php if ($type == 'deposit' && !empty($details['receipt_path']) && file_exists($details['receipt_path'])): ?>
    <div class="mt-4">
        <h6>Receipt</h6>
        <div class="text-center">
            <img src="<?php echo $details['receipt_path']; ?>" alt="Receipt" class="img-fluid rounded" style="max-height: 300px;">
        </div>
    </div>
    <?php endif; ?>
</div>