<?php session_start();
include 'includes/head.php';






// Get user's tickets
$tickets_sql = "SELECT * FROM support_tickets WHERE user_id = '$user_id' ORDER BY created_at DESC LIMIT 5";
$tickets_result = mysqli_query($conn, $tickets_sql);

// Get FAQ categories
$faq_categories_sql = "SELECT * FROM faq_categories WHERE is_active = 1";
$faq_categories_result = mysqli_query($conn, $faq_categories_sql);
?>
<!DOCTYPE html>
<html lang="en">

<style>
    .support-card {
        border: none;
        border-radius: 15px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        transition: all 0.3s ease;
    }
    .support-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 15px rgba(0,0,0,0.2);
    }
    .contact-method {
        text-align: center;
        padding: 30px 20px;
        border-radius: 10px;
        margin-bottom: 20px;
    }
    .contact-method.phone { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; }
    .contact-method.email { background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); color: white; }
    .contact-method.chat { background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); color: white; }
    .faq-category {
        margin-bottom: 30px;
    }
    .faq-item {
        border-bottom: 1px solid #eee;
        padding: 15px 0;
    }
    .faq-question {
        font-weight: 600;
        cursor: pointer;
        margin: 0;
    }
    .faq-answer {
        display: none;
        padding-top: 10px;
        color: #666;
    }
    .badge-priority { font-size: 0.7em; padding: 4px 8px; }
</style>


<body class="dashboard">
    <div id="main-wrapper">
        <?php include('includes/header.php');?>
        <?php include('includes/sidebar.php');?>

        <div class="content-body">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="page-title">
                            <div class="row align-items-center justify-content-between">
                                <div class="col-xl-4">
                                    <div class="page-title-content">
                                        <h3>Support & Help Center</h3>
                                        <p class="mb-2">We're here to help you with any questions or issues</p>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <div class="breadcrumbs">
                                        <a href="dashboard.php">Home</a>
                                        <span><i class="fi fi-rr-angle-small-right"></i></span>
                                        <a href="#">Support</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- QUICK SUPPORT OPTIONS -->
               <!-- <div class="row mb-4">
                    <div class="col-12">
                        <div class="card support-card">
                            <div class="card-body">
                                <h5 class="card-title mb-4">Quick Support Options</h5>
                                <div class="row g-4">
                                    <div class="col-md-3">
                                        <div class="contact-method">
                                            <div class="bg-primary bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                                                <i class="fi fi-rr-phone-call text-primary fs-2"></i>
                                            </div>
                                            <h6>Call Support</h6>
                                            <p class="text-muted small mb-2">Speak directly with our team</p>
                                            <a href="tel:0861001234" class="btn btn-outline-primary btn-sm">086 100 1234</a>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="contact-method">
                                            <div class="bg-success bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                                                <i class="fi fi-rr-envelope text-success fs-2"></i>
                                            </div>
                                            <h6>Email Us</h6>
                                            <p class="text-muted small mb-2">Send us a detailed message</p>
                                            <a href="mailto:info@efina.co.za" class="btn btn-outline-success btn-sm">info@efina.co.za</a>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="contact-method">
                                            <div class="bg-info bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                                                <i class="fi fi-rr-comments text-info fs-2"></i>
                                            </div>
                                            <h6>Live Chat</h6>
                                            <p class="text-muted small mb-2">Instant messaging support</p>
                                            <button class="btn btn-outline-info btn-sm" onclick="openLiveChat()">Start Chat</button>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="contact-method">
                                            <div class="bg-warning bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                                                <i class="fi fi-rr-document text-warning fs-2"></i>
                                            </div>
                                            <h6>Submit Ticket</h6>
                                            <p class="text-muted small mb-2">Track your support requests</p>
                                            <button class="btn btn-outline-warning btn-sm" data-bs-toggle="modal" data-bs-target="#supportTicketModal">Create Ticket</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> -->

                <div class="row">
                    <!-- SUPPORT TICKETS -->
                    <div class="col-xl-6">
                        <div class="card support-card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h4 class="card-title mb-0">Your Support Tickets</h4>
                                <a href="create_ticket.php" class="btn btn-primary btn-sm">Create New Ticket</a>
                            </div>
                            <div class="card-body">
                                <?php if(mysqli_num_rows($tickets_result) > 0): ?>
                                    <div class="ticket-list">
                                        <?php while($ticket = mysqli_fetch_assoc($tickets_result)): 
                                            $status_class = '';
                                            if($ticket['status'] == 'open') $status_class = 'badge-success';
                                            elseif($ticket['status'] == 'in_progress') $status_class = 'badge-warning';
                                            elseif($ticket['status'] == 'resolved') $status_class = 'badge-info';
                                            else $status_class = 'badge-secondary';
                                        ?>
                                        <a href="ticket_details.php?id=<?php echo $ticket['id']; ?>" class="d-block p-3 border-bottom">
                                            <div class="d-flex justify-content-between align-items-start">
                                                <div class="flex-grow-1">
                                                    <h6 class="mb-1"><?php echo htmlspecialchars($ticket['subject']); ?></h6>
                                                    <p class="text-muted small mb-1"><?php echo substr($ticket['description'], 0, 100); ?>...</p>
                                                    <div class="d-flex gap-2">
                                                        <span class="badge <?php echo $status_class; ?>"><?php echo ucfirst(str_replace('_', ' ', $ticket['status'])); ?></span>
                                                        <span class="badge badge-priority bg-<?php 
                                                            if($ticket['priority'] == 'urgent') echo 'danger';
                                                            elseif($ticket['priority'] == 'high') echo 'warning';
                                                            elseif($ticket['priority'] == 'medium') echo 'info';
                                                            else echo 'secondary';
                                                        ?>"><?php echo ucfirst($ticket['priority']); ?></span>
                                                    </div>
                                                </div>
                                                <div class="text-end">
                                                    <small class="text-muted d-block"><?php echo date('M j, Y', strtotime($ticket['created_at'])); ?></small>
                                                    <i class="fi fi-ss-angle-right text-muted"></i>
                                                </div>
                                            </div>
                                        </a>
                                        <?php endwhile; ?>
                                    </div>
                                    <div class="text-center mt-3">
                                        <a href="tickets.php" class="btn btn-outline-primary btn-sm">View All Tickets</a>
                                    </div>
                                <?php else: ?>
                                    <div class="text-center py-5">
                                        <i class="fi fi-rr-inbox-in fs-1 text-muted mb-3"></i>
                                        <p class="text-muted">You have no support tickets yet</p>
                                        <a href="create_ticket.php" class="btn btn-primary">Create Your First Ticket</a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- LOAN DISPUTE REPORTING -->
                        <div class="card support-card mt-4">
                            <div class="card-header">
                                <h4 class="card-title mb-0">Loan Dispute Reporting</h4>
                            </div>
                            <div class="card-body">
                                <p class="text-muted">Report issues with your loan account, payments, or statements</p>
                                <div class="row g-2">
                                    <div class="col-6">
                                        <a href="create_ticket.php?category=dispute" class="btn btn-outline-warning w-100">
                                            <i class="fi fi-rr-shield-exclamation me-2"></i>
                                            Report Dispute
                                        </a>
                                    </div>
                                    <div class="col-6">
                                        <a href="feedback.php?type=complaint" class="btn btn-outline-danger w-100">
                                            <i class="fi fi-rr-comment-exclamation me-2"></i>
                                            File Complaint
                                        </a>
                                    </div>
                                </div>
                                <div class="mt-3">
                                    <small class="text-muted">
                                        <i class="fi fi-rr-info me-1"></i>
                                        All disputes are handled in accordance with the National Credit Act
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- FAQ & QUICK HELP -->
                    <div class="col-xl-6">
                        <div class="card support-card">
                            <div class="card-header">
                                <h4 class="card-title mb-0">Frequently Asked Questions</h4>
                            </div>
                            <div class="card-body">
                                <div class="faq-categories">
                                    <?php while($category = mysqli_fetch_assoc($faq_categories_result)): 
                                        // Get FAQs for this category
                                        $faq_sql = "SELECT * FROM faq_items WHERE category_id = '{$category['id']}' AND is_active = 1 LIMIT 3";
                                        $faq_result = mysqli_query($conn, $faq_sql);
                                    ?>
                                    <div class="faq-category">
                                        <h6 class="text-primary mb-3"><?php echo htmlspecialchars($category['name']); ?></h6>
                                        <?php while($faq = mysqli_fetch_assoc($faq_result)): ?>
                                        <div class="faq-item">
                                            <div class="faq-question" onclick="toggleFAQ(this)">
                                                <i class="fi fi-rr-angle-right me-2 faq-icon"></i>
                                                <?php echo htmlspecialchars($faq['question']); ?>
                                            </div>
                                            <div class="faq-answer">
                                                <?php echo nl2br(htmlspecialchars($faq['answer'])); ?>
                                            </div>
                                        </div>
                                        <?php endwhile; ?>
                                    </div>
                                    <?php endwhile; ?>
                                </div>
                                <div class="text-center mt-3">
                                    <a href="faq.php" class="btn btn-outline-primary btn-sm">View All FAQs</a>
                                </div>
                            </div>
                        </div>

                        <!-- QUICK SUPPORT RESOURCES -->
                        <div class="card support-card mt-4">
                            <div class="card-body">
                                <h5 class="card-title mb-3">Quick Support Resources</h5>
                                <div class="row g-3">
                                    <div class="col-sm-6">
                                        <div class="border rounded p-3 card-hover text-center">
                                            <i class="fi fi-rr-document fs-2 text-primary mb-2"></i>
                                            <h6 class="fw-medium mb-1">Knowledge Base</h6>
                                            <p class="text-muted small mb-0">Browse articles and guides</p>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="border rounded p-3 card-hover text-center">
                                            <i class="fi fi-rr-play fs-2 text-success mb-2"></i>
                                            <h6 class="fw-medium mb-1">Video Tutorials</h6>
                                            <p class="text-muted small mb-0">Step-by-step guides</p>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="border rounded p-3 card-hover text-center">
                                            <i class="fi fi-rr-users fs-2 text-info mb-2"></i>
                                            <h6 class="fw-medium mb-1">Community Forum</h6>
                                            <p class="text-muted small mb-0">Connect with other users</p>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="border rounded p-3 card-hover text-center">
                                            <i class="fi fi-rr-comment-alt fs-2 text-warning mb-2"></i>
                                            <h6 class="fw-medium mb-1">Feedback</h6>
                                            <p class="text-muted small mb-0">Share your suggestions</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php include('includes/footer.php');?>
    </div>

    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    
    <script>
    function toggleFAQ(element) {
        const answer = element.nextElementSibling;
        const icon = element.querySelector('.faq-icon');
        
        if (answer.style.display === 'block') {
            answer.style.display = 'none';
            icon.className = 'fi fi-rr-angle-right me-2 faq-icon';
        } else {
            answer.style.display = 'block';
            icon.className = 'fi fi-rr-angle-down me-2 faq-icon';
        }
    }

    function startLiveChat() {
        alert('Live chat feature will be implemented soon! For now, please call or email us.');
    }

    // Initialize FAQs
    $(document).ready(function() {
        // Add click handlers to all FAQ questions
        $('.faq-question').click(function() {
            toggleFAQ(this);
        });
    });
    </script>
</body>
</html>
<?php mysqli_close($conn); ?>