<!DOCTYPE html>
<html lang="en">


<?php include("includes/head.php")?>


<body>

    <!--==========================   Preloader Start  ==========================-->
    
    <!--==========================  Preloader End  ==========================-->

    <div class="wrapper">
        <!--==========================   Header Start  ==========================-->
            <?php include("includes/header.php") ?>

        <!--==========================  Header End  ==========================-->
       
       <main>
    <!-- ==================== Breadcrumb Start Here ==================== -->
    <section class="breadcrumb">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="breadcrumb__wrapper">
                        <h2 class="breadcrumb__title">AI Trading FAQs</h2>
                        <ul class="breadcrumb__list">
                            <li class="breadcrumb__item"><a href="index.php" class="breadcrumb__link"> 
                                <i class="las la-home"></i> Home</a> 
                            </li>
                            <li class="breadcrumb__item"><i class="fa-solid fa-minus"></i></li>
                            <li class="breadcrumb__item"> 
                                <span class="breadcrumb__item-text"> AI Trading Questions</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ==================== Breadcrumb End Here ==================== -->
    
    <!--==========================  AI Trading FAQ Section Start  ==========================-->
    <section class="faq-section bg--black py-120">
        <div class="container position-relative">
            <div class="faq-shape d-none d-lg-block">
                <img src="assets/svg/bank.svg" alt="bank">
                <img src="assets/svg/balance-5.svg" alt="balance">
            </div>
            <div class="row justify-content-center">
                <div class="col-xl-7 col-lg-8">
                    <div class="section-content text-center">
                        <h6 class="top-reveal">AI Trading Support</h6>
                        <h2 class="top-reveal">Frequently Asked Questions</h2>
                        <p class="top-reveal">Get answers to common questions about AI trading bots, funding, withdrawals, and account management. No trading knowledge needed - our AI does all the work.</p>
                    </div>
                </div>
            </div>
            
            <!-- FAQ Category Tabs -->
            <div class="row mt-5">
                <div class="col-12">
                    <ul class="nav nav-pills justify-content-center mb-4" id="faqCategoryTab" role="tablist">
                        <?php
                        // Fetch FAQ categories from database
                        $category_query = mysqli_query($conn, "
                            SELECT DISTINCT fc.id, fc.name, fc.description 
                            FROM faq_categories fc 
                            INNER JOIN faq_items fi ON fc.id = fi.category_id 
                            WHERE fc.is_active = 1 AND fi.is_active = 1
                            ORDER BY fc.name
                        ");
                        
                        $category_count = 0;
                        while($category = mysqli_fetch_assoc($category_query)):
                            $category_count++;
                            $active = $category_count == 1 ? 'active' : '';
                            $selected = $category_count == 1 ? 'true' : 'false';
                        ?>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link <?php echo $active; ?>" id="cat-<?php echo $category['id']; ?>-tab" 
                                data-bs-toggle="pill" data-bs-target="#cat-<?php echo $category['id']; ?>" 
                                type="button" role="tab" aria-controls="cat-<?php echo $category['id']; ?>" 
                                aria-selected="<?php echo $selected; ?>">
                                <?php echo htmlspecialchars($category['name']); ?>
                            </button>
                        </li>
                        <?php endwhile; ?>
                    </ul>
                </div>
            </div>
            
            <!-- FAQ Content by Category -->
            <div class="tab-content mt-4" id="faqCategoryContent">
                <?php
                // Reset category query pointer
                mysqli_data_seek($category_query, 0);
                $category_count = 0;
                
                while($category = mysqli_fetch_assoc($category_query)):
                    $category_count++;
                    $active = $category_count == 1 ? 'show active' : '';
                ?>
                <div class="tab-pane fade <?php echo $active; ?>" id="cat-<?php echo $category['id']; ?>" 
                    role="tabpanel" aria-labelledby="cat-<?php echo $category['id']; ?>-tab" tabindex="0">
                    
                    <div class="row mt-60 row-gap-5">
                        <div class="col-lg-6 align-self-center">
                            <div class="faq-category-info">
                                <h3 class="mb-3"><?php echo htmlspecialchars($category['name']); ?></h3>
                                <p><?php echo htmlspecialchars($category['description']); ?></p>
                                
                                <?php if($category['id'] == 6): // Trading Bots category ?>
                                <div class="mt-4">
                                    <h5 class="mb-3">Quick Bot Comparison:</h5>
                                    <?php
                                    $bot_stats = mysqli_query($conn, "
                                        SELECT 
                                            COUNT(*) as total_bots,
                                            AVG(daily_roi_percentage) as avg_roi,
                                            MIN(min_trading_balance) as min_balance
                                        FROM trading_bot_plans 
                                        WHERE is_active = 1
                                    ")->fetch_assoc();
                                    ?>
                                    <div class="d-flex flex-wrap gap-3">
                                        <div class="stat-badge">
                                            <i class="fa-solid fa-robot"></i>
                                            <span><?php echo $bot_stats['total_bots']; ?> AI Bots</span>
                                        </div>
                                        <div class="stat-badge">
                                            <i class="fa-solid fa-chart-line"></i>
                                            <span><?php echo number_format($bot_stats['avg_roi'], 1); ?>% Avg ROI</span>
                                        </div>
                                        <div class="stat-badge">
                                            <i class="fa-solid fa-money-bill"></i>
                                            <span>$<?php echo $bot_stats['min_balance']; ?> Min</span>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-lg-6 align-self-center">
                            <div class="accordion custom--accordion" id="faqCategory<?php echo $category['id']; ?>">
                                <?php
                                // Fetch FAQ items for this category
                                $faq_query = mysqli_query($conn, "
                                    SELECT * FROM faq_items 
                                    WHERE category_id = '{$category['id']}' 
                                    AND is_active = 1 
                                    ORDER BY id 
                                    LIMIT 5
                                ");
                                
                                $faq_count = 0;
                                while($faq = mysqli_fetch_assoc($faq_query)):
                                    $faq_count++;
                                    $faq_active = $faq_count == 1 ? 'show' : '';
                                    $faq_collapsed = $faq_count == 1 ? '' : 'collapsed';
                                ?>
                                <div class="accordion-item bottom-reveal">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button <?php echo $faq_collapsed; ?>" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#faq-<?php echo $faq['id']; ?>" 
                                            aria-expanded="<?php echo $faq_count == 1 ? 'true' : 'false'; ?>">
                                            <i class="fa-solid fa-circle-question me-2 text--base"></i>
                                            <?php echo htmlspecialchars($faq['question']); ?>
                                        </button>
                                    </h2>
                                    <div id="faq-<?php echo $faq['id']; ?>" class="accordion-collapse collapse <?php echo $faq_active; ?>" 
                                        data-bs-parent="#faqCategory<?php echo $category['id']; ?>">
                                        <div class="accordion-body">
                                            <?php echo $faq['answer']; ?>
                                            <?php if($category['id'] == 6 && $faq['id'] == 39): // ROI question ?>
                                            <div class="mt-3 p-3 bg-dark rounded">
                                                <h6 class="mb-2"><i class="fa-solid fa-calculator me-2"></i>ROI Calculator:</h6>
                                                <div class="row">
                                                    <div class="col-6">
                                                        <small>Daily ROI: 12.5%</small><br>
                                                        <small>Monthly (30 days): ~375%</small>
                                                    </div>
                                                    <div class="col-6">
                                                        <small>Example: $1,000 investment</small><br>
                                                        <small>30-day profit: ~$3,750</small>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <?php endwhile; ?>
                                
                                <?php if(mysqli_num_rows($faq_query) == 5): ?>
                                <div class="text-center mt-4">
                                    <a href="faq-category.php?id=<?php echo $category['id']; ?>" class="btn btn-outline--base">
                                        View All <?php echo htmlspecialchars($category['name']); ?> Questions
                                        <i class="flaticon-arrow-upper-right"></i>
                                    </a>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
            
            <!-- FAQ Search -->
            <div class="row mt-5">
                <div class="col-lg-8 mx-auto">
                    <div class="faq-search">
                        <h5 class="text-center mb-3">Can't find your answer? Search our knowledge base</h5>
                        <form action="faq-search.php" method="GET" class="search-form">
                            <div class="input-group">
                                <input type="text" name="q" class="form-control" placeholder="Search AI trading questions..." aria-label="Search FAQs">
                                <button class="btn btn--base-two" type="submit">
                                    <i class="fa-solid fa-magnifying-glass"></i> Search
                                </button>
                            </div>
                        </form>
                        <div class="text-center mt-3">
                            <small class="text-muted">
                                <i class="fa-solid fa-lightbulb me-1"></i>
                                Popular searches: "bot setup", "withdrawal time", "minimum deposit", "ROI calculator"
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--==========================  AI Trading FAQ Section End  ==========================-->
    
    <!--==========================  AI Bot Plans Section Start  ==========================-->
    <section class="pricing-section bg--black-two py-120">
        <div class="container position-relative">
            <div class="pricing-shape d-none d-lg-block">
                <img src="assets/svg/analysis-1.svg" alt="star">
                <img src="assets/svg/analysis-2.svg" alt="star">
            </div>
            <div class="row row-gap-3 ">
                <div class="col-lg-6 align-self-end">
                    <div class="section-content">
                        <h6 class="right-reveal">AI Bot Plans</h6>
                        <h2 class="mb-0 right-reveal">Choose Your AI Trading Bot</h2>
                    </div>
                </div>
                <div class="col-lg-6 align-self-end">
                    <div class="section-content">
                        <p class="right-reveal">No trading experience needed. Select from our AI bot plans - each designed for different investment levels. The bots do all the trading work automatically.</p>
                    </div>
                </div>
            </div>
            <div class="row mt-60 row-gap-4 justify-content-center">
                <div class="col-12 bottom-reveal">
                    <div class="pricing-slide swiper">
                        <div class="swiper-wrapper">
                            <?php
                            // Fetch bot plans from database
                            $bot_plans_query = mysqli_query($conn, "
                                SELECT * FROM trading_bot_plans 
                                WHERE is_active = 1 
                                ORDER BY sort_order ASC
                            ");
                            
                            while($plan = mysqli_fetch_assoc($bot_plans_query)):
                            ?>
                            <div class="swiper-slide">
                                <div class="pricing-content">
                                    <div class="pricing-header">
                                        <h6 class="mb-2"><?php echo htmlspecialchars($plan['plan_name']); ?></h6>
                                        <h2 class="mb-2">$<?php echo number_format($plan['subscription_fee'], 0); ?>
                                            <sub class="fs-16 fw-normal">/Month</sub>
                                        </h2>
                                        <p><?php echo $plan['daily_roi_percentage']; ?>% Daily ROI</p>
                                    </div>
                                    <div class="pricing-body">
                                        <ul>
                                            <li><?php echo $plan['trading_accuracy']; ?>% Trading Accuracy</li>
                                            <li><?php echo $plan['markets_covered']; ?>+ Markets</li>
                                            <li><?php echo $plan['strategy_types']; ?> Strategies</li>
                                            <li>Min: $<?php echo number_format($plan['min_trading_balance'], 0); ?></li>
                                            <li><?php echo $plan['support_level']; ?> Support</li>
                                        </ul>
                                    </div>
                                    <div class="pricing-footer">
                                        <a href="register.php?plan=<?php echo $plan['id']; ?>" class="btn btn--black-two">
                                            Subscribe Now
                                        </a>
                                        <a href="bot-details.php?id=<?php echo $plan['id']; ?>" class="btn btn-outline--base mt-2">
                                            Learn More
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php endwhile; ?>
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
            </div>
            
            <!-- Bot Plan Comparison -->
            <div class="row mt-5">
                <div class="col-12">
                    <div class="plan-comparison">
                        <h5 class="text-center mb-4">Which AI Bot is Right for You?</h5>
                        <div class="table-responsive">
                            <table class="table table-dark table-bordered">
                                <thead>
                                    <tr>
                                        <th>Feature</th>
                                        <?php mysqli_data_seek($bot_plans_query, 0); ?>
                                        <?php while($plan = mysqli_fetch_assoc($bot_plans_query)): ?>
                                        <th class="text-center"><?php echo $plan['plan_name']; ?></th>
                                        <?php endwhile; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>Daily ROI</td>
                                        <?php mysqli_data_seek($bot_plans_query, 0); ?>
                                        <?php while($plan = mysqli_fetch_assoc($bot_plans_query)): ?>
                                        <td class="text-center"><?php echo $plan['daily_roi_percentage']; ?>%</td>
                                        <?php endwhile; ?>
                                    </tr>
                                    <tr>
                                        <td>Trading Accuracy</td>
                                        <?php mysqli_data_seek($bot_plans_query, 0); ?>
                                        <?php while($plan = mysqli_fetch_assoc($bot_plans_query)): ?>
                                        <td class="text-center"><?php echo $plan['trading_accuracy']; ?>%</td>
                                        <?php endwhile; ?>
                                    </tr>
                                    <tr>
                                        <td>Minimum Balance</td>
                                        <?php mysqli_data_seek($bot_plans_query, 0); ?>
                                        <?php while($plan = mysqli_fetch_assoc($bot_plans_query)): ?>
                                        <td class="text-center">$<?php echo number_format($plan['min_trading_balance'], 0); ?></td>
                                        <?php endwhile; ?>
                                    </tr>
                                    <tr>
                                        <td>Monthly Fee</td>
                                        <?php mysqli_data_seek($bot_plans_query, 0); ?>
                                        <?php while($plan = mysqli_fetch_assoc($bot_plans_query)): ?>
                                        <td class="text-center">$<?php echo number_format($plan['subscription_fee'], 0); ?></td>
                                        <?php endwhile; ?>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--==========================  AI Bot Plans Section End  ==========================-->
    
    <!--==========================  Call-to-action Section Start  ==========================-->
    <section class="call-to-action-section bg--black-two">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="call-action-box">
                        <div class="call-shape">
                            <img src="assets/svg/twostar.svg" alt="star">
                        </div>
                        <div class="row row-gap-5">
                            <div class="col-lg-6 align-self-center order-1 order-lg-0">
                                <div class="call-text text-center text-lg-start">
                                    <span class="text--base pb-3 right-reveal">Still Have Questions?</span>
                                    <h2 class="mb-4 right-reveal">Chat With Our AI Trading Specialists 24/7</h2>
                                    <p class="mb-4">Get instant answers about bot setup, funding, or withdrawals. No trading knowledge needed - we'll guide you through everything.</p>
                                    <div class="d-flex flex-wrap gap-3">
                                        <a href="support-tickets.php" class="btn btn--base-two right-reveal">
                                            <i class="fa-solid fa-headset me-2"></i>
                                            Live Chat Support
                                        </a>
                                        <a href="contact.php" class="btn btn-outline--base right-reveal">
                                            <i class="fa-solid fa-phone me-2"></i>
                                            Call Support
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 align-self-center">
                                <div class="call-img text-lg-end text-center scaleUp">
                                    <img src="assets/images/call/call-img.png" alt="AI Trading Support" class="img-fluid m-auto">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--==========================  Call-to-action Section End  ==========================-->
</main>
        <!-- ==================== Footer Start Here ==================== -->
       <?php include("includes/footer.php") ?>
        <!-- ==================== Footer End Here ==================== -->
    </div>
    <div class="progress-wrap">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>


    <!-- Jquery js -->
    <script data-cfasync="false" src="../../../cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script><script src="assets/js/jquery-3.7.1.min.js"></script>
    <!-- gsap Js -->
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.js"></script>
    <!-- Bootstrap Bundle Js -->
    <script src="assets/js/boostrap.bundle.min.js"></script>
    <!-- Scroll Reveal Js -->
    <script src="assets/js/scrollreveal.min.js"></script>
    <!-- Swiper Bundle Js -->
    <script src="assets/js/swiper-bundle.min.js"></script>
    <!-- Fancy Box js -->
    <script src="assets/js/fancybox.umd.js"></script>
    <!-- Odometer js -->
    <script src="assets/js/odometer.min.js"></script>

    <!-- main js -->
    <script src="assets/js/main.js"></script>
<script defer src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015" integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ==" data-cf-beacon='{"version":"2024.11.0","token":"3c29d7bffb424472bfac70b0302e98df","r":1,"server_timing":{"name":{"cfCacheStatus":true,"cfEdge":true,"cfExtPri":true,"cfL4":true,"cfOrigin":true,"cfSpeedBrain":true},"location_startswith":null}}' crossorigin="anonymous"></script>
</body>


</html>