<?php
// mail_sender.php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

require_once '../mail/Exception.php';
require_once '../mail/PHPMailer.php';
require_once '../mail/SMTP.php';

// Your email configuration
$myHost = $mailer['host'];
$myPort = $mailer['port'];
$host_email = $mailer['username'];
$host_pass = $mailer['password'];

// User data
$user_email = $email;
$first_name = $first_name;

$mail = new PHPMailer;
$mail->isSMTP();
$mail->Host = $myHost;
$mail->Port = $myPort;
$mail->SMTPDebug = 0;
$mail->SMTPAuth = true;
$mail->Username = $host_email;
$mail->Password = $host_pass;
$mail->setFrom($host_email, $sitename);
$mail->addAddress($user_email, $first_name);

if ($mail->addReplyTo($host_email, $sitename)) {
    $mail->Subject = $mail_subject . ' - ' . $sitename;
    $mail->isHTML(true);    
    $mail->Body = "
    <!DOCTYPE html>
    <html lang='en' xmlns='http://www.w3.org/1999/xhtml' xmlns:v='urn:schemas-microsoft-com:vml' xmlns:o='urn:schemas-microsoft-com:office:office'>
    <head>
        <meta charset='utf-8'>
        <meta name='viewport' content='width=device-width,initial-scale=1'>
        <meta name='x-apple-disable-message-reformatting'>
        <meta name='format-detection' content='telephone=no,date=no,address=no,email=no,url=no'>
        <title>" . $mail_subject . "</title>
        <!--[if mso]>
        <xml>
            <o:OfficeDocumentSettings>
                <o:PixelsPerInch>96</o:PixelsPerInch>
            </o:OfficeDocumentSettings>
        </xml>
        <![endif]-->
        <style>
            * {
                margin: 0;
                padding: 0;
                box-sizing: border-box;
            }
            body {
                font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
                background-color: #f8fafc;
                color: #334155;
                line-height: 1.6;
                -webkit-font-smoothing: antialiased;
                -moz-osx-font-smoothing: grayscale;
            }
            .email-wrapper {
                max-width: 600px;
                margin: 0 auto;
                padding: 20px;
            }
            .email-container {
                background: #ffffff;
                border-radius: 16px;
                overflow: hidden;
                box-shadow: 0 10px 40px rgba(47, 44, 216, 0.08);
                border: 1px solid #e2e8f0;
            }
            .email-header {
                background: linear-gradient(135deg, #2F2CD8 0%, #6366f1 50%, #8b5cf6 100%);
                padding: 50px 40px 40px;
                text-align: center;
                position: relative;
                overflow: hidden;
            }
            .email-header::before {
                content: '';
                position: absolute;
                top: -50%;
                left: -50%;
                width: 200%;
                height: 200%;
                background: radial-gradient(circle, rgba(255,255,255,0.1) 1px, transparent 1px);
                background-size: 20px 20px;
                opacity: 0.1;
            }
            .logo-container {
                margin-bottom: 25px;
            }
            .logo {
                max-width: 200px;
                height: auto;
                filter: drop-shadow(0 4px 6px rgba(0, 0, 0, 0.1));
            }
            .email-title {
                color: #ffffff;
                font-size: 32px;
                font-weight: 700;
                margin-bottom: 12px;
                letter-spacing: -0.5px;
                position: relative;
                z-index: 2;
            }
            .email-subtitle {
                color: rgba(255, 255, 255, 0.9);
                font-size: 17px;
                font-weight: 400;
                opacity: 0.95;
                position: relative;
                z-index: 2;
            }
            .email-badge {
                display: inline-block;
                background: rgba(255, 255, 255, 0.15);
                backdrop-filter: blur(10px);
                color: white;
                padding: 6px 16px;
                border-radius: 20px;
                font-size: 13px;
                font-weight: 500;
                margin-top: 15px;
                border: 1px solid rgba(255, 255, 255, 0.2);
                position: relative;
                z-index: 2;
            }
            .email-content {
                padding: 50px 40px;
            }
            .greeting-section {
                margin-bottom: 35px;
            }
            .greeting {
                font-size: 22px;
                font-weight: 600;
                color: #1e293b;
                margin-bottom: 8px;
            }
            .user-name {
                color: #2F2CD8;
                background: linear-gradient(90deg, #2F2CD8, #6366f1);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
                font-weight: 700;
            }
            .message-content {
                font-size: 16px;
                color: #475569;
                margin-bottom: 35px;
                line-height: 1.7;
            }
            .action-section {
                background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
                border-radius: 12px;
                padding: 35px;
                margin: 40px 0;
                border: 1px solid #e2e8f0;
                text-align: center;
            }
            .action-button {
                display: inline-block;
                background: linear-gradient(135deg, #2F2CD8 0%, #6366f1 100%);
                color: #ffffff !important;
                text-decoration: none;
                padding: 18px 45px;
                border-radius: 12px;
                font-weight: 600;
                font-size: 17px;
                text-align: center;
                transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
                box-shadow: 0 8px 25px rgba(47, 44, 216, 0.25);
                border: none;
                cursor: pointer;
                position: relative;
                overflow: hidden;
            }
            .action-button:hover {
                background: linear-gradient(135deg, #2521c7 0%, #4f46e5 100%);
                transform: translateY(-3px);
                box-shadow: 0 12px 30px rgba(47, 44, 216, 0.35);
            }
            .action-button:active {
                transform: translateY(-1px);
            }
            .action-button::after {
                content: '';
                position: absolute;
                top: 50%;
                left: 50%;
                width: 5px;
                height: 5px;
                background: rgba(255, 255, 255, 0.5);
                opacity: 0;
                border-radius: 100%;
                transform: scale(1, 1) translate(-50%);
                transform-origin: 50% 50%;
            }
            .action-button:hover::after {
                animation: ripple 1s ease-out;
            }
            @keyframes ripple {
                0% {
                    transform: scale(0, 0);
                    opacity: 0.5;
                }
                100% {
                    transform: scale(40, 40);
                    opacity: 0;
                }
            }
            .link-alternative {
                background: #ffffff;
                border: 1px solid #e2e8f0;
                border-radius: 10px;
                padding: 20px;
                margin: 25px 0;
                word-break: break-all;
                font-family: 'SF Mono', Monaco, 'Cascadia Code', monospace;
            }
            .verification-link {
                color: #2F2CD8;
                text-decoration: none;
                font-size: 14px;
                font-weight: 500;
                word-break: break-all;
            }
            .info-section {
                margin: 40px 0;
            }
            .notice-box {
                background: #f0f9ff;
                border: 1px solid #bae6fd;
                border-radius: 10px;
                padding: 20px;
                margin-bottom: 20px;
            }
            .notice-box.security {
                background: #fef3c7;
                border-color: #fcd34d;
            }
            .notice-box.expiry {
                background: #f0fdf4;
                border-color: #86efac;
            }
            .notice-title {
                color: #0369a1;
                font-weight: 600;
                margin-bottom: 10px;
                font-size: 15px;
                display: flex;
                align-items: center;
                gap: 8px;
            }
            .notice-title.security {
                color: #92400e;
            }
            .notice-title.expiry {
                color: #065f46;
            }
            .notice-text {
                color: #0c4a6e;
                font-size: 14px;
                line-height: 1.6;
            }
            .notice-text.security {
                color: #78350f;
            }
            .notice-text.expiry {
                color: #064e3b;
            }
            .support-section {
                text-align: center;
                margin: 45px 0 30px;
                padding: 30px;
                background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
                border-radius: 12px;
                border: 1px dashed #cbd5e1;
            }
            .support-text {
                color: #64748b;
                font-size: 15px;
                margin-bottom: 15px;
            }
            .support-link {
                color: #2F2CD8;
                text-decoration: none;
                font-weight: 600;
                transition: color 0.2s ease;
            }
            .support-link:hover {
                color: #2521c7;
                text-decoration: underline;
            }
            .email-footer {
                background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
                padding: 40px;
                text-align: center;
                border-top: 4px solid #2F2CD8;
            }
            .footer-logo {
                max-width: 120px;
                margin-bottom: 25px;
                filter: brightness(0) invert(1);
                opacity: 0.8;
            }
            .footer-links {
                display: flex;
                justify-content: center;
                gap: 25px;
                margin-bottom: 25px;
                flex-wrap: wrap;
            }
            .footer-link {
                color: #cbd5e1;
                text-decoration: none;
                font-size: 14px;
                font-weight: 500;
                transition: color 0.2s ease;
            }
            .footer-link:hover {
                color: #ffffff;
            }
            .social-links {
                display: flex;
                justify-content: center;
                gap: 15px;
                margin-bottom: 25px;
            }
            .social-icon {
                display: inline-flex;
                align-items: center;
                justify-content: center;
                width: 36px;
                height: 36px;
                background: rgba(255, 255, 255, 0.1);
                border-radius: 50%;
                color: white;
                text-decoration: none;
                transition: all 0.2s ease;
            }
            .social-icon:hover {
                background: #2F2CD8;
                transform: translateY(-2px);
            }
            .copyright {
                color: #94a3b8;
                font-size: 12px;
                line-height: 1.6;
                margin-top: 20px;
                padding-top: 20px;
                border-top: 1px solid rgba(255, 255, 255, 0.1);
            }
            .unsubscribe {
                font-size: 11px;
                color: #94a3b8;
                margin-top: 10px;
            }
            .unsubscribe-link {
                color: #94a3b8;
                text-decoration: none;
            }
            @media only screen and (max-width: 600px) {
                .email-wrapper {
                    padding: 10px;
                }
                .email-header {
                    padding: 40px 25px 30px;
                }
                .email-content {
                    padding: 40px 25px;
                }
                .email-title {
                    font-size: 26px;
                }
                .email-subtitle {
                    font-size: 15px;
                }
                .action-button {
                    padding: 16px 35px;
                    font-size: 16px;
                    width: 100%;
                }
                .footer-links {
                    flex-direction: column;
                    gap: 15px;
                }
            }
        </style>
    </head>
    <body>
        <div class='email-wrapper'>
            <div class='email-container'>
                <!-- Header Section -->
                <div class='email-header'>
                    <div class='logo-container'>
                        <img src='" . $myUrl . "/images/" . $sitelogo . "' alt='" . $sitename . "' class='logo' />
                    </div>
                    <h1 class='email-title'>" . $mail_subject . "</h1>
                    <p class='email-subtitle'>Important notification from " . $sitename . "</p>
                    <div class='email-badge'>Notification</div>
                </div>

                " . $mail_message . "

                <!-- Footer Section -->
                <div class='email-footer'>
                    <img src='" . $myUrl . "/images/" . $sitelogo . "' alt='" . $sitename . "' class='footer-logo' />
                    
                    <div class='footer-links'>
                        <a href='" . $myUrl . "' class='footer-link'>Home</a>
                        <a href='" . $myUrl . "/about' class='footer-link'>About Us</a>
                        <a href='" . $myUrl . "/contact' class='footer-link'>Contact</a>
                        <a href='" . $myUrl . "/privacy.php' class='footer-link'>Privacy Policy</a>
                        <a href='" . $myUrl . "/terms.php' class='footer-link'>Terms of Service</a>
                    </div>
                    
                    <div class='social-links'>
                        <a href='#' class='social-icon'>𝕏</a>
                        <a href='#' class='social-icon'>f</a>
                        <a href='#' class='social-icon'>in</a>
                        <a href='#' class='social-icon'>ig</a>
                    </div>
                    
                    <p class='copyright'>
                        &copy; " . date('Y') . " " . $sitename . ". All rights reserved.<br>
                        This email was sent to " . $user_email . " as part of your account notifications.<br>
                        This is an automated message, please do not reply directly to this email.
                    </p>
                    
                    <p class='unsubscribe'>
                        <a href='" . $myUrl . "/unsubscribe?email=" . $user_email . "' class='unsubscribe-link'>Unsubscribe from these emails</a>
                    </p>
                </div>
            </div>
        </div>
    </body>
    </html>";


    $mail->send();
    
}
?>