<?php session_start();

?>
<!DOCTYPE html>
<html lang="en">


<?php include("includes/head.php")?>


<body>

    <!--==========================   Preloader Start  ==========================-->
    
    <!--==========================  Preloader End  ==========================-->

    <div class="wrapper">
        <!--==========================   Header Start  ==========================-->
            <?php include("includes/header.php") ?>

        <!--==========================  Header End  ==========================-->
        <main>
    <!-- ==================== Breadcrumb Start Here ==================== -->
    <section class="breadcrumb">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="breadcrumb__wrapper">
                        <h2 class="breadcrumb__title">About AI Trading Platform</h2>
                        <ul class="breadcrumb__list">
                            <li class="breadcrumb__item"><a href="index.php" class="breadcrumb__link"> 
                                <i class="las la-home"></i> Home</a> 
                            </li>
                            <li class="breadcrumb__item"><i class="fa-solid fa-minus"></i></li>
                            <li class="breadcrumb__item"> 
                                <span class="breadcrumb__item-text"> About AI Trading</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ==================== Breadcrumb End Here ==================== -->
    
    <!--==========================  About AI Trading Section Start  ==========================-->
    <section class="about-section bg--black-two py-120">
        <div class="container position-relative">
            <div class="about-shape d-none d-lg-block">
                <img src="assets/svg/twostar.svg" alt="star">
                <img src="assets/svg/star-1.svg" alt="star">
            </div>
            <div class="row row-gap-5">
                <div class="col-xl-6 align-self-center">
                    <div class="about-img pe-xl-4 scaleUp">
                        <img src="assets/images/about/about1.png" alt="AI Trading Platform" class="img-fluid">
                    </div>
                </div>
                <div class="col-xl-6 align-self-center">
                    <div class="section-content">
                        <h6 class="right-reveal">Revolutionizing Trading</h6>
                        <h2 class="right-reveal">Democratizing Trading with AI Technology</h2>
                        <p class="right-reveal">We believe everyone deserves access to profitable trading, regardless of experience. Our AI trading platform eliminates the need for trading knowledge by using advanced machine learning algorithms that analyze markets 24/7 and execute trades automatically. Powered by Polygon Network for fast, secure, and low-cost transactions.</p>
                    </div>
                    <div class="d-flex flex-wrap gap-4 my-4 my-lg-5">
                        <div class="info-box right-reveal">
                            <div class="fs-40 text--base fw-bold">
                                <span class="odometer" data-odometer-final="5">3</span>+
                                Years
                            </div>
                            <p>AI Trading Excellence</p>
                        </div>
                        <div class="info-box right-reveal">
                            <div class="fs-40 text--base fw-bold">
                                <span class="odometer" data-odometer-final="25">10</span>k+
                            </div>
                            <p>Active AI Traders</p>
                        </div>
                        <div class="info-box right-reveal">
                            <div class="fs-40 text--base fw-bold">
                                <span class="odometer" data-odometer-final="99">95</span>%
                            </div>
                            <p>Uptime on Polygon</p>
                        </div>
                    </div>
                    <div class="powered-by mb-4">
                        <span class="badge bg-purple px-3 py-2">
                            <i class="fas fa-bolt me-2"></i>
                            Powered by Polygon Network
                        </span>
                        <p class="small mt-2">Fast transactions • Low fees • Secure infrastructure</p>
                    </div>
                    <a href="how-it-works.php" class="btn btn--base-two right-reveal">
                        <i class="fa-solid fa-robot me-2"></i>
                        How AI Trading Works
                    </a>
                </div>
            </div>
        </div>
    </section>
    <!--==========================  About AI Trading Section End  ==========================-->
    
    <!--==========================  AI Trading FAQs Section Start  ==========================-->
    <section class="faq-section bg--black py-120">
        <div class="container position-relative">
            <div class="faq-shape d-none d-lg-block">
                <img src="assets/svg/bank.svg" alt="bank">
                <img src="assets/svg/balance-5.svg" alt="balance">
            </div>
            <div class="row justify-content-center">
                <div class="col-xl-7 col-lg-8">
                    <div class="section-content text-center">
                        <h6 class="top-reveal">AI Trading FAQs</h6>
                        <h2 class="top-reveal">Common Questions About AI Trading</h2>
                        <p class="top-reveal">Get answers to frequently asked questions about how our AI trading bots work, Polygon Network integration, and getting started without trading knowledge.</p>
                    </div>
                </div>
            </div>
            <div class="row mt-60 row-gap-5">
                <div class="col-lg-6 align-self-center">
                    <img src="assets/images/faq/faq.png" alt="AI Trading FAQs" class="img-fluid scaleUp">
                </div>
                <div class="col-lg-6 align-self-center">
                    <?php
                    // Fetch FAQ items from database
                    $faq_query = mysqli_query($conn, "
                        SELECT fi.* 
                        FROM faq_items fi 
                        WHERE fi.is_active = 1 
                        AND fi.id IN (36, 37, 38, 39, 40, 46, 47, 48)
                        ORDER BY FIELD(fi.id, 36, 37, 38, 39, 40)
                        LIMIT 5
                    ");
                    $faq_count = 0;
                    ?>
                    <div class="accordion custom--accordion" id="faqExample">
                        <?php while($faq = mysqli_fetch_assoc($faq_query)): 
                            $faq_count++;
                            $active = $faq_count == 1 ? 'show' : '';
                            $collapsed = $faq_count == 1 ? '' : 'collapsed';
                        ?>
                        <div class="accordion-item bottom-reveal">
                            <h2 class="accordion-header">
                                <button class="accordion-button <?php echo $collapsed; ?>" type="button"
                                    data-bs-toggle="collapse" data-bs-target="#faq<?php echo $faq_count; ?>" 
                                    aria-expanded="<?php echo $faq_count == 1 ? 'true' : 'false'; ?>">
                                    <?php echo htmlspecialchars($faq['question']); ?>
                                </button>
                            </h2>
                            <div id="faq<?php echo $faq_count; ?>" class="accordion-collapse collapse <?php echo $active; ?>" data-bs-parent="#faqExample">
                                <div class="accordion-body">
                                    <?php echo $faq['answer']; ?>
                                </div>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                    <div class="text-center mt-4">
                        <a href="faq.php" class="btn btn--base-two">
                            View All FAQs <i class="flaticon-arrow-upper-right"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--==========================  AI Trading FAQs Section End  ==========================-->
    
    <!--==========================   Text-slide Start  ==========================-->
    <div class="text-slide-section py-3 bg--base">
        <div class="text-slide swiper">
            <div class="swiper-wrapper slide-transition">
                <div class="swiper-slide inner-slide-element">
                    <div class="slide-text-black">
                        POWERED BY POLYGON
                    </div>
                </div>
                <div class="swiper-slide inner-slide-element">
                    <div class="slide-icon">
                        <img src="assets/svg/star-2.svg" alt="star">
                    </div>
                </div>
                <div class="swiper-slide inner-slide-element">
                    <div class="slide-text-black">
                        NO TRADING KNOWLEDGE NEEDED
                    </div>
                </div>
                <div class="swiper-slide inner-slide-element">
                    <div class="slide-icon">
                        <img src="assets/svg/star-2.svg" alt="star">
                    </div>
                </div>
                <div class="swiper-slide inner-slide-element">
                    <div class="slide-text-black">
                        AI-POWERED TRADING
                    </div>
                </div>
                <div class="swiper-slide inner-slide-element">
                    <div class="slide-icon">
                        <img src="assets/svg/star-2.svg" alt="star">
                    </div>
                </div>
                <div class="swiper-slide inner-slide-element">
                    <div class="slide-text-black">
                        24/7 AUTOMATED
                    </div>
                </div>
                <div class="swiper-slide inner-slide-element">
                    <div class="slide-icon">
                        <img src="assets/svg/star-2.svg" alt="star">
                    </div>
                </div>
                <div class="swiper-slide inner-slide-element">
                    <div class="slide-text-black">
                        INSTANT WITHDRAWALS
                    </div>
                </div>
                <div class="swiper-slide inner-slide-element">
                    <div class="slide-icon">
                        <img src="assets/svg/star-2.svg" alt="star">
                    </div>
                </div>
                <div class="swiper-slide inner-slide-element">
                    <div class="slide-text-black">
                        LOW POLYGON FEES
                    </div>
                </div>
                <div class="swiper-slide inner-slide-element">
                    <div class="slide-icon">
                        <img src="assets/svg/star-2.svg" alt="star">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--==========================  Text-slide End  ==========================-->
    
    <!--==========================  AI Development Team Section Start  ==========================-->
    <section class="team-section bg--black py-120">
        <div class="container position-relative">
            <div class="services-two-shape d-none d-lg-block">
                <img src="assets/svg/bank.svg" alt="balance">
                <img src="assets/svg/balance-5.svg" alt="balance">
            </div>
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-8">
                    <div class="section-content text-center">
                        <h6 class="top-reveal">AI Development Team</h6>
                        <h2 class="top-reveal">Meet Our AI & Blockchain Experts</h2>
                        <p class="top-reveal">Our team combines expertise in artificial intelligence, machine learning, and blockchain technology to create the most advanced AI trading platform on Polygon Network.</p>
                    </div>
                </div>
            </div>
            <div class="row mt-60 row-gap-4 justify-content-center">
                <div class="col-12">
                    <div class="team-slide swiper">
                        <div class="swiper-wrapper">
                            <div class="swiper-slide">
                                <div class="team-item">
                                    <a href="team-details.php" class="team-img">
                                        <img src="assets/images/team/team1.jpg" alt="AI Developer" class="img-fluid w-100">
                                    </a>
                                    <div class="team-content">
                                        <h4 class="mb-1"><a href="team-details.php">Dr. Sarah Chen</a></h4>
                                        <p>Chief AI Scientist</p>
                                        <p class="small text-muted">PhD in Machine Learning, Ex-Google AI</p>
                                        <ul class="social-icon">
                                            <li><a href="https://www.linkedin.com/" target="_blank" title="LinkedIn">
                                                <i class="fa-brands fa-linkedin-in"></i></a>
                                            </li>
                                            <li><a href="https://github.com/" target="_blank" title="GitHub">
                                                <i class="fa-brands fa-github"></i></a>
                                            </li>
                                            <li><a href="https://twitter.com/" target="_blank" title="Twitter">
                                                <i class="fa-brands fa-x-twitter"></i></a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="team-item">
                                    <a href="team-details.php" class="team-img">
                                        <img src="assets/images/team/team2.jpg" alt="Blockchain Expert" class="img-fluid w-100">
                                    </a>
                                    <div class="team-content">
                                        <h4 class="mb-1"><a href="team-details.php">Michael Rodriguez</a></h4>
                                        <p>Blockchain Architect</p>
                                        <p class="small text-muted">Polygon Network Specialist</p>
                                        <ul class="social-icon">
                                            <li><a href="https://www.linkedin.com/" target="_blank" title="LinkedIn">
                                                <i class="fa-brands fa-linkedin-in"></i></a>
                                            </li>
                                            <li><a href="https://github.com/" target="_blank" title="GitHub">
                                                <i class="fa-brands fa-github"></i></a>
                                            </li>
                                            <li><a href="https://twitter.com/" target="_blank" title="Twitter">
                                                <i class="fa-brands fa-x-twitter"></i></a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="team-item">
                                    <a href="team-details.php" class="team-img">
                                        <img src="assets/images/team/team3.jpg" alt="Quantitative Analyst" class="img-fluid w-100">
                                    </a>
                                    <div class="team-content">
                                        <h4 class="mb-1"><a href="team-details.php">James Wilson</a></h4>
                                        <p>Quantitative Analyst</p>
                                        <p class="small text-muted">Algorithmic Trading Expert</p>
                                        <ul class="social-icon">
                                            <li><a href="https://www.linkedin.com/" target="_blank" title="LinkedIn">
                                                <i class="fa-brands fa-linkedin-in"></i></a>
                                            </li>
                                            <li><a href="https://github.com/" target="_blank" title="GitHub">
                                                <i class="fa-brands fa-github"></i></a>
                                            </li>
                                            <li><a href="https://twitter.com/" target="_blank" title="Twitter">
                                                <i class="fa-brands fa-x-twitter"></i></a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="team-item">
                                    <a href="team-details.php" class="team-img">
                                        <img src="assets/images/team/team4.jpg" alt="Security Engineer" class="img-fluid w-100">
                                    </a>
                                    <div class="team-content">
                                        <h4 class="mb-1"><a href="team-details.php">Lisa Thompson</a></h4>
                                        <p>Security Engineer</p>
                                        <p class="small text-muted">Cybersecurity & Blockchain Security</p>
                                        <ul class="social-icon">
                                            <li><a href="https://www.linkedin.com/" target="_blank" title="LinkedIn">
                                                <i class="fa-brands fa-linkedin-in"></i></a>
                                            </li>
                                            <li><a href="https://github.com/" target="_blank" title="GitHub">
                                                <i class="fa-brands fa-github"></i></a>
                                            </li>
                                            <li><a href="https://twitter.com/" target="_blank" title="Twitter">
                                                <i class="fa-brands fa-x-twitter"></i></a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
            </div>
            <div class="row mt-60">
                <div class="col-lg-12">
                    <div class="text-center">
                        <a href="careers.php" class="btn btn--base-two bottom-reveal">
                            <i class="fa-solid fa-user-plus me-2"></i>
                            Join Our AI Team
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--==========================  AI Development Team Section End  ==========================-->
    
    <!--==========================  Testimonial Section Start  ==========================-->
    <section class="testimonial-section bg--black-two py-120">
        <div class="container position-relative">
            <div class="testimonial-shape d-none d-lg-block">
                <img src="assets/svg/twostar.svg" alt="star">
                <img src="assets/svg/maneyPlant.svg" alt="money Plant">
            </div>
            <div class="row row-gap-2">
                <div class="col-lg-6 align-self-end">
                    <div class="section-content">
                        <h6 class="right-reveal">AI Trading Success</h6>
                        <h2 class="mb-2 right-reveal">Real Traders, Zero Experience</h2>
                    </div>
                </div>
                <div class="col-lg-6 align-self-end">
                    <div class="section-content">
                        <p class="right-reveal">People with no trading background are earning consistent profits using our AI bots. The system works automatically on Polygon Network.</p>
                    </div>
                </div>
            </div>
            <div class="row mt-60">
                <div class="col-12 position-relative bottom-reveal">
                    <div class="testimonial-slide swiper">
                        <div class="swiper-wrapper">
                            <?php
                            // Fetch testimonials from database
                            $testimonials_query = mysqli_query($conn, "
                                SELECT * FROM testimonials 
                                WHERE is_active = 1 
                                ORDER BY sort_order ASC
                                LIMIT 5
                            ");
                            
                            while($testimonial = mysqli_fetch_assoc($testimonials_query)):
                                // Generate star rating
                                $stars = '';
                                for($i = 1; $i <= 5; $i++) {
                                    $stars .= $i <= $testimonial['rating'] 
                                        ? '<i class="fas fa-star text-warning"></i>' 
                                        : '<i class="far fa-star text-warning"></i>';
                                }
                            ?>
                            <div class="swiper-slide">
                                <div class="testimonial-item">
                                    <div class="start-client">
                                        <div class="star-rating mb-2">
                                            <?php echo $stars; ?>
                                        </div>
                                    </div>
                                    <div class="client-body">
                                        <img src="assets/svg/quite.svg" alt="quote">
                                        <p class="client-text">
                                            "<?php echo htmlspecialchars($testimonial['testimonial_text']); ?>"
                                        </p>
                                        <div class="client-info d-flex gap-3 align-self-center">
                                            <img src="assets/images/client/<?php echo htmlspecialchars($testimonial['avatar']); ?>" alt="<?php echo htmlspecialchars($testimonial['full_name']); ?>">
                                            <div class="text">
                                                <h4 class="mb-2"><?php echo htmlspecialchars($testimonial['full_name']); ?></h4>
                                                <p><?php echo htmlspecialchars($testimonial['profession']); ?></p>
                                                <?php if($testimonial['bot_plan']): ?>
                                                <small class="text-muted">
                                                    <i class="fas fa-robot me-1"></i>
                                                    <?php echo htmlspecialchars($testimonial['bot_plan']); ?>
                                                </small>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endwhile; ?>
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                    <div class="slider-btn">
                        <div class="btn-slider-prev testi-prev">
                            <i class="fa-solid fa-chevron-left"></i>
                        </div>
                        <div class="btn-slider-next testi-next">
                            <i class="fa-solid fa-chevron-right"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--==========================  Testimonial Section End  ==========================-->
    
    <!--==========================  Call-to-action Section Start  ==========================-->
    <section class="call-to-action-section bg--black-two">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="call-action-box">
                        <div class="call-shape">
                            <img src="assets/svg/twostar.svg" alt="star">
                        </div>
                        <div class="row row-gap-5">
                            <div class="col-lg-6 align-self-center order-1 order-lg-0">
                                <div class="call-text text-center text-lg-start">
                                    <span class="text--base pb-3 right-reveal">Powered by Polygon Network</span>
                                    <h2 class="mb-4 right-reveal">Start AI Trading Today - No Experience Needed</h2>
                                    <p class="mb-4">Fast transactions • Low fees • Secure Polygon infrastructure</p>
                                    <a href="register.php" class="btn btn--base-two right-reveal">
                                        <i class="fa-solid fa-robot me-2"></i>
                                        Start Free AI Trial
                                    </a>
                                    <p class="mt-3 small">
                                        <i class="fa-solid fa-bolt text-warning me-1"></i>
                                        Polygon Network ensures instant deposits & withdrawals
                                    </p>
                                </div>
                            </div>
                            <div class="col-lg-6 align-self-center">
                                <div class="call-img text-lg-end text-center scaleUp">
                                    <img src="assets/images/call/call-img.png" alt="Polygon AI Trading" class="img-fluid m-auto">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--==========================  Call-to-action Section End  ==========================-->
</main>
   
        <!-- ==================== Footer Start Here ==================== -->
       <?php include("includes/footer.php") ?>
        <!-- ==================== Footer End Here ==================== -->
    </div>
    <div class="progress-wrap">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>



<style>
    /* Polygon Network Styling */
.bg-purple {
    background-color: #8247e5 !important;
    color: white;
}

.powered-by .badge {
    font-size: 16px;
    font-weight: 600;
}

/* Team member enhancements */
.team-content .text-muted {
    font-size: 12px;
    margin-top: -5px;
    margin-bottom: 10px;
}

.team-content .social-icon {
    margin-top: 10px;
}

/* Polygon Network text in slider */
.slide-text-black {
    font-weight: 600;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .powered-by {
        text-align: center;
    }
    
    .team-content {
        text-align: center;
    }
}
</style>
    <!-- Jquery js -->
    <script data-cfasync="false" src="../../../cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script><script src="assets/js/jquery-3.7.1.min.js"></script>
    <!-- gsap Js -->
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.js"></script>
    <!-- Bootstrap Bundle Js -->
    <script src="assets/js/boostrap.bundle.min.js"></script>
    <!-- Scroll Reveal Js -->
    <script src="assets/js/scrollreveal.min.js"></script>
    <!-- Swiper Bundle Js -->
    <script src="assets/js/swiper-bundle.min.js"></script>
    <!-- Fancy Box js -->
    <script src="assets/js/fancybox.umd.js"></script>
    <!-- Odometer js -->
    <script src="assets/js/odometer.min.js"></script>

    <!-- main js -->
    <script src="assets/js/main.js"></script>
<script defer src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015" integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ==" data-cf-beacon='{"version":"2024.11.0","token":"3c29d7bffb424472bfac70b0302e98df","r":1,"server_timing":{"name":{"cfCacheStatus":true,"cfEdge":true,"cfExtPri":true,"cfL4":true,"cfOrigin":true,"cfSpeedBrain":true},"location_startswith":null}}' crossorigin="anonymous"></script>
</body>


<!-- Mirrored from photoclerks.com/html/xtrady-update/xtrady/support.html by HTTrack Website Copier/3.x [XR&CO'2014], Sat, 31 Jan 2026 19:52:33 GMT -->
</html>