<?php session_start();?>
<!DOCTYPE html>
<html lang="en">
  	<?php 
  	include('includes/head.php');
  	include('includes/config.php');
  	?>
	
	<body class="hold-transition dark-skin sidebar-mini theme-primary fixed">
		
		<div class="wrapper">
		  	<div id="loader"></div>
		  	
		  <?php include('includes/header.php') ?>

		  <?php include('includes/sidebar.php') ?>

		  	<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<div class="container-full">
					<!-- Main content -->
					<section class="content">
						<div class="row">
							<div class="col-12">
								<div class="box">
									<div class="box-header">
										<h4 class="box-title"><i class="fas fa-history me-2"></i>Admin Activities Log</h4>
										<div class="box-controls pull-right">
											<div class="dropdown">
												<button class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
													<i class="fas fa-download me-1"></i> Export
												</button>
												<div class="dropdown-menu">
													<a class="dropdown-item" href="javascript:void(0)" onclick="exportActivities('csv')"><i class="fas fa-file-csv"></i> CSV</a>
													<a class="dropdown-item" href="javascript:void(0)" onclick="exportActivities('pdf')"><i class="fas fa-file-pdf"></i> PDF</a>
													<a class="dropdown-item" href="javascript:void(0)" onclick="exportActivities('excel')"><i class="fas fa-file-excel"></i> Excel</a>
												</div>
											</div>
										</div>
									</div>
									<div class="box-body">
										<!-- Filters -->
										<div class="row mb-20">
											<div class="col-md-3">
												<div class="form-group">
													<label>Date Range</label>
													<div class="input-group">
														<input type="date" class="form-control" id="dateFrom">
														<span class="input-group-text">to</span>
														<input type="date" class="form-control" id="dateTo">
													</div>
												</div>
											</div>
											<div class="col-md-2">
												<div class="form-group">
													<label>Admin Role</label>
													<select class="form-control" id="roleFilter">
														<option value="">All Roles</option>
														<option value="super_admin">Super Admin</option>
														<option value="admin">Admin</option>
														<option value="support">Support</option>
													</select>
												</div>
											</div>
											<div class="col-md-2">
												<div class="form-group">
													<label>Module</label>
													<select class="form-control" id="moduleFilter">
														<option value="">All Modules</option>
														<?php
														$module_sql = "SELECT DISTINCT module FROM admin_activities WHERE module IS NOT NULL ORDER BY module";
														$module_result = mysqli_query($conn, $module_sql);
														while ($module = mysqli_fetch_assoc($module_result)) {
															echo "<option value='{$module['module']}'>{$module['module']}</option>";
														}
														?>
													</select>
												</div>
											</div>
											<div class="col-md-2">
												<div class="form-group">
													<label>Admin Name</label>
													<input type="text" class="form-control" id="adminFilter" placeholder="Search admin...">
												</div>
											</div>
											<div class="col-md-3">
												<div class="form-group">
													<label>Actions</label>
													<div class="d-flex">
														<button class="btn btn-primary me-2" onclick="filterActivities()"><i class="fas fa-filter me-1"></i> Filter</button>
														<button class="btn btn-secondary" onclick="resetFilters()"><i class="fas fa-redo me-1"></i> Reset</button>
													</div>
												</div>
											</div>
										</div>
										
										<!-- Activities Table -->
										<div class="table-responsive">
											<table class="table table-hover table-bordered" id="activitiesTable">
												<thead class="bg-light">
													<tr>
														<th>ID</th>
														<th>Admin</th>
														<th>Role</th>
														<th>Action</th>
														<th>Description</th>
														<th>Module</th>
														<th>Affected ID</th>
														<th>IP Address</th>
														<th>Date & Time</th>
													</tr>
												</thead>
												<tbody id="activitiesBody">
													<!-- Activities will be loaded via AJAX -->
												</tbody>
											</table>
										</div>
										
										<!-- Pagination -->
										<div class="row mt-20">
											<div class="col-sm-12 col-md-5">
												<div class="dataTables_info" id="activitiesInfo" role="status" aria-live="polite"></div>
											</div>
											<div class="col-sm-12 col-md-7">
												<div class="dataTables_paginate paging_simple_numbers" id="activitiesPagination">
													<!-- Pagination will be loaded via AJAX -->
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</section>
					<!-- /.content -->
				</div>
			</div>
		  	
		  <?php include('includes/footer.php') ?>

		  <?php include('includes/control_sidebar.php') ?>
			
		</div>
		<!-- ./wrapper -->
		
		  
    
		
		
		  <?php include('includes/scripts.php') ?>
		
		<!-- DataTables -->
		<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
		<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
		<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
		
		<script>
		$(document).ready(function() {
			// Load activities
			loadActivities();
			
			// Initialize DataTable
			$('#activitiesTable').DataTable({
				"pageLength": 25,
				"order": [[0, 'desc']],
				"language": {
					"search": "Search:",
					"lengthMenu": "Show _MENU_ entries",
					"info": "Showing _START_ to _END_ of _TOTAL_ entries",
					"paginate": {
						"first": "First",
						"last": "Last",
						"next": "Next",
						"previous": "Previous"
					}
				}
			});
		});
		
		// Load Activities with filters
		function loadActivities(page = 1) {
			var dateFrom = $('#dateFrom').val();
			var dateTo = $('#dateTo').val();
			var role = $('#roleFilter').val();
			var module = $('#moduleFilter').val();
			var admin = $('#adminFilter').val();
			
			$.ajax({
				url: 'ajax/get_all_activities.php',
				type: 'GET',
				data: {
					page: page,
					date_from: dateFrom,
					date_to: dateTo,
					role: role,
					module: module,
					admin: admin
				},
				success: function(response) {
					var data = JSON.parse(response);
					
					if (data.success) {
						// Update table body
						$('#activitiesBody').html(data.html);
						
						// Update pagination
						$('#activitiesPagination').html(data.pagination);
						
						// Update info
						$('#activitiesInfo').html(data.info);
					}
				}
			});
		}
		
		// Apply Filters
		function filterActivities() {
			loadActivities(1);
		}
		
		// Reset Filters
		function resetFilters() {
			$('#dateFrom').val('');
			$('#dateTo').val('');
			$('#roleFilter').val('');
			$('#moduleFilter').val('');
			$('#adminFilter').val('');
			loadActivities(1);
		}
		
		// Export Activities
		function exportActivities(format) {
			var dateFrom = $('#dateFrom').val();
			var dateTo = $('#dateTo').val();
			var role = $('#roleFilter').val();
			var module = $('#moduleFilter').val();
			var admin = $('#adminFilter').val();
			
			var url = 'ajax/export_activities.php?format=' + format +
					 '&date_from=' + dateFrom +
					 '&date_to=' + dateTo +
					 '&role=' + role +
					 '&module=' + module +
					 '&admin=' + admin;
			
			window.open(url, '_blank');
		}
		
		// Change Page
		function changePage(page) {
			loadActivities(page);
		}
		</script>
		
		<style>
		.table-hover tbody tr:hover {
			background-color: rgba(0,0,0,0.02);
			cursor: pointer;
		}
		.badge-role {
			padding: 4px 8px;
			border-radius: 4px;
			font-size: 11px;
			font-weight: 600;
		}
		.badge-super_admin {
			background-color: #dc3545;
			color: white;
		}
		.badge-admin {
			background-color: #0d6efd;
			color: white;
		}
		.badge-support {
			background-color: #6c757d;
			color: white;
		}
		</style>
		
	</body>
</html>