<?php
session_start();
include('../includes/config.php');

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$sql = "SELECT * FROM admin_activities WHERE id = $id";
$result = mysqli_query($conn, $sql);

if ($row = mysqli_fetch_assoc($result)) {
    // Role badge colors
    $role_colors = array(
        'super_admin' => 'danger',
        'admin' => 'primary',
        'support' => 'info'
    );
    
    $role_color = isset($role_colors[$row['admin_role']]) ? $role_colors[$row['admin_role']] : 'secondary';
    $timestamp = date('Y-m-d H:i:s', strtotime($row['created_at']));
    
    echo '<div class="row">';
    echo '<div class="col-md-6">';
    echo '<h6>Admin Information</h6>';
    echo '<table class="table table-sm">';
    echo '<tr><td width="40%"><strong>Admin ID:</strong></td><td>' . $row['admin_id'] . '</td></tr>';
    echo '<tr><td><strong>Admin Name:</strong></td><td>' . htmlspecialchars($row['admin_name']) . '</td></tr>';
    echo '<tr><td><strong>Admin Role:</strong></td><td><span class="badge bg-' . $role_color . '">' . ucfirst(str_replace('_', ' ', $row['admin_role'])) . '</span></td></tr>';
    echo '<tr><td><strong>IP Address:</strong></td><td><code>' . htmlspecialchars($row['ip_address']) . '</code></td></tr>';
    echo '</table>';
    echo '</div>';
    
    echo '<div class="col-md-6">';
    echo '<h6>Activity Details</h6>';
    echo '<table class="table table-sm">';
    echo '<tr><td width="40%"><strong>Action:</strong></td><td>' . htmlspecialchars($row['action']) . '</td></tr>';
    echo '<tr><td><strong>Module:</strong></td><td>' . ($row['module'] ? htmlspecialchars($row['module']) : '-') . '</td></tr>';
    echo '<tr><td><strong>Affected ID:</strong></td><td>' . ($row['affected_id'] ? '#' . $row['affected_id'] : '-') . '</td></tr>';
    echo '<tr><td><strong>Affected Table:</strong></td><td>' . ($row['affected_table'] ? htmlspecialchars($row['affected_table']) : '-') . '</td></tr>';
    echo '<tr><td><strong>Timestamp:</strong></td><td>' . $timestamp . '</td></tr>';
    echo '</table>';
    echo '</div>';
    echo '</div>';
    
    echo '<div class="row mt-3">';
    echo '<div class="col-12">';
    echo '<h6>Description</h6>';
    echo '<div class="card">';
    echo '<div class="card-body">';
    echo '<p class="mb-0">' . nl2br(htmlspecialchars($row['description'])) . '</p>';
    echo '</div>';
    echo '</div>';
    echo '</div>';
    echo '</div>';
    
    if ($row['user_agent']) {
        echo '<div class="row mt-3">';
        echo '<div class="col-12">';
        echo '<h6>User Agent</h6>';
        echo '<div class="card">';
        echo '<div class="card-body">';
        echo '<code>' . htmlspecialchars($row['user_agent']) . '</code>';
        echo '</div>';
        echo '</div>';
        echo '</div>';
        echo '</div>';
    }
} else {
    echo '<div class="alert alert-danger">Activity not found</div>';
}
?>