<?php
session_start();
include('../includes/config.php');

$admin_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($admin_id > 0) {
    $sql = "SELECT * FROM admins WHERE id = $admin_id";
    $result = mysqli_query($conn, $sql);
    
    if ($admin = mysqli_fetch_assoc($result)) {
        // Role colors
        $role_colors = array(
            'super_admin' => 'danger',
            'admin' => 'primary',
            'support' => 'info'
        );
        
        $role_color = isset($role_colors[$admin['role']]) ? $role_colors[$admin['role']] : 'secondary';
        $status_color = $admin['is_active'] ? 'success' : 'danger';
        $last_login = $admin['last_login'] ? date('F d, Y H:i:s', strtotime($admin['last_login'])) : 'Never';
        $created_at = date('F d, Y H:i:s', strtotime($admin['created_at']));
        
        // Get recent activities
        $activity_sql = "SELECT COUNT(*) as total FROM admin_activities WHERE admin_id = $admin_id";
        $activity_result = mysqli_query($conn, $activity_sql);
        $activity_count = mysqli_fetch_assoc($activity_result)['total'];
        
        echo '<div class="row">';
        echo '<div class="col-md-12">';
        echo '<table class="table table-sm">';
        echo '<tr><td width="40%"><strong>ID:</strong></td><td>' . $admin['id'] . '</td></tr>';
        echo '<tr><td><strong>Name:</strong></td><td>' . htmlspecialchars($admin['name']) . '</td></tr>';
        echo '<tr><td><strong>Email:</strong></td><td>' . htmlspecialchars($admin['email']) . '</td></tr>';
        echo '<tr><td><strong>Role:</strong></td><td><span class="badge bg-' . $role_color . '">' . ucfirst(str_replace('_', ' ', $admin['role'])) . '</span></td></tr>';
        echo '<tr><td><strong>Status:</strong></td><td><span class="badge bg-' . $status_color . '">' . ($admin['is_active'] ? 'Active' : 'Inactive') . '</span></td></tr>';
        echo '<tr><td><strong>Last Login:</strong></td><td>' . $last_login . '</td></tr>';
        echo '<tr><td><strong>Created:</strong></td><td>' . $created_at . '</td></tr>';
        echo '<tr><td><strong>Total Activities:</strong></td><td>' . $activity_count . ' actions logged</td></tr>';
        echo '</table>';
        echo '</div>';
        echo '</div>';
    } else {
        echo '<div class="alert alert-danger">Admin not found.</div>';
    }
} else {
    echo '<div class="alert alert-danger">Invalid admin ID.</div>';
}
?>