<?php
session_start();
include('../includes/config.php');

// Get total admins
$total_sql = "SELECT COUNT(*) as total FROM admins";
$total_result = mysqli_query($conn, $total_sql);
$total = mysqli_fetch_assoc($total_result)['total'];

// Get super admins
$super_sql = "SELECT COUNT(*) as total FROM admins WHERE role = 'super_admin'";
$super_result = mysqli_query($conn, $super_sql);
$super_admins = mysqli_fetch_assoc($super_result)['total'];

// Get active admins
$active_sql = "SELECT COUNT(*) as total FROM admins WHERE is_active = 1";
$active_result = mysqli_query($conn, $active_sql);
$active = mysqli_fetch_assoc($active_result)['total'];

// Get today's activities
$today = date('Y-m-d');
$today_sql = "SELECT COUNT(*) as total FROM admin_activities WHERE DATE(created_at) = '$today'";
$today_result = mysqli_query($conn, $today_sql);
$today_activities = mysqli_fetch_assoc($today_result)['total'];

echo json_encode(array(
    'success' => true,
    'total' => $total,
    'super_admins' => $super_admins,
    'active' => $active,
    'today_activities' => $today_activities
));
?>