<?php
session_start();
include('../includes/config.php');

// Get filter parameters
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$limit = 25;
$offset = ($page - 1) * $limit;

$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : '';
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : '';
$role = isset($_GET['role']) ? $_GET['role'] : '';
$module = isset($_GET['module']) ? $_GET['module'] : '';
$admin = isset($_GET['admin']) ? $_GET['admin'] : '';

// Build query
$sql = "SELECT * FROM admin_activities WHERE 1=1";
$count_sql = "SELECT COUNT(*) as total FROM admin_activities WHERE 1=1";

// Apply filters
if (!empty($date_from) && !empty($date_to)) {
    $sql .= " AND DATE(created_at) BETWEEN '$date_from' AND '$date_to'";
    $count_sql .= " AND DATE(created_at) BETWEEN '$date_from' AND '$date_to'";
} elseif (!empty($date_from)) {
    $sql .= " AND DATE(created_at) >= '$date_from'";
    $count_sql .= " AND DATE(created_at) >= '$date_from'";
} elseif (!empty($date_to)) {
    $sql .= " AND DATE(created_at) <= '$date_to'";
    $count_sql .= " AND DATE(created_at) <= '$date_to'";
}

if (!empty($role)) {
    $sql .= " AND admin_role = '$role'";
    $count_sql .= " AND admin_role = '$role'";
}

if (!empty($module)) {
    $sql .= " AND module = '$module'";
    $count_sql .= " AND module = '$module'";
}

if (!empty($admin)) {
    $sql .= " AND admin_name LIKE '%$admin%'";
    $count_sql .= " AND admin_name LIKE '%$admin%'";
}

// Get total count
$count_result = mysqli_query($conn, $count_sql);
$count_row = mysqli_fetch_assoc($count_result);
$total_records = $count_row['total'];
$total_pages = ceil($total_records / $limit);

// Add pagination
$sql .= " ORDER BY created_at DESC LIMIT $limit OFFSET $offset";

// Execute query
$result = mysqli_query($conn, $sql);

$html = '';
if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $id = $row['id'];
        $admin_name = htmlspecialchars($row['admin_name']);
        $admin_role = $row['admin_role'];
        $action = htmlspecialchars($row['action']);
        $description = htmlspecialchars($row['description']);
        $module = $row['module'] ? htmlspecialchars($row['module']) : '-';
        $affected_id = $row['affected_id'] ? $row['affected_id'] : '-';
        $ip_address = $row['ip_address'] ? htmlspecialchars($row['ip_address']) : '-';
        $created_at = date('Y-m-d H:i:s', strtotime($row['created_at']));
        
        // Role badge class
        $role_class = '';
        switch ($admin_role) {
            case 'super_admin': $role_class = 'badge-super_admin'; break;
            case 'admin': $role_class = 'badge-admin'; break;
            case 'support': $role_class = 'badge-support'; break;
        }
        
        $html .= "<tr>";
        $html .= "<td>$id</td>";
        $html .= "<td>$admin_name</td>";
        $html .= "<td><span class='badge-role $role_class'>$admin_role</span></td>";
        $html .= "<td><strong>$action</strong></td>";
        $html .= "<td><small>$description</small></td>";
        $html .= "<td>$module</td>";
        $html .= "<td>$affected_id</td>";
        $html .= "<td><code>$ip_address</code></td>";
        $html .= "<td>$created_at</td>";
        $html .= "</tr>";
    }
} else {
    $html = "<tr><td colspan='9' class='text-center py-20'>No activities found</td></tr>";
}

// Generate pagination HTML
$pagination = '';
if ($total_pages > 1) {
    $pagination .= '<ul class="pagination justify-content-end">';
    
    // Previous button
    if ($page > 1) {
        $pagination .= '<li class="page-item"><a class="page-link" href="javascript:void(0)" onclick="changePage(' . ($page - 1) . ')">Previous</a></li>';
    }
    
    // Page numbers
    for ($i = 1; $i <= $total_pages; $i++) {
        if ($i == $page) {
            $pagination .= '<li class="page-item active"><span class="page-link">' . $i . '</span></li>';
        } elseif ($i >= $page - 2 && $i <= $page + 2) {
            $pagination .= '<li class="page-item"><a class="page-link" href="javascript:void(0)" onclick="changePage(' . $i . ')">' . $i . '</a></li>';
        }
    }
    
    // Next button
    if ($page < $total_pages) {
        $pagination .= '<li class="page-item"><a class="page-link" href="javascript:void(0)" onclick="changePage(' . ($page + 1) . ')">Next</a></li>';
    }
    
    $pagination .= '</ul>';
}

// Info text
$start = $offset + 1;
$end = min($offset + $limit, $total_records);
$info = "Showing $start to $end of $total_records entries";

echo json_encode(array(
    'success' => true,
    'html' => $html,
    'pagination' => $pagination,
    'info' => $info,
    'total_pages' => $total_pages,
    'current_page' => $page
));
?>