<?php
session_start();
include('../includes/config.php');

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$sql = "SELECT bt.*, 
               u.username, 
               u.email,
               u.phone,
               p.plan_name,
               p.subscription_fee,
               s.trading_balance,
               s.status as subscription_status,
               s.subscription_start,
               s.subscription_end
        FROM bot_transactions bt
        LEFT JOIN user_bot_subscriptions s ON bt.subscription_id = s.id
        LEFT JOIN users u ON s.user_id = u.id
        LEFT JOIN trading_bot_plans p ON s.bot_plan_id = p.id
        WHERE bt.id = $id";

$result = mysqli_query($conn, $sql);

if ($row = mysqli_fetch_assoc($result)) {
    $type_colors = array(
        'profit' => 'success',
        'loss' => 'danger',
        'fee' => 'warning'
    );
    $type_color = $type_colors[$row['transaction_type']] ?: 'secondary';
    
    echo '<div class="row">';
    echo '<div class="col-md-6">';
    echo '<h6>Transaction Details</h6>';
    echo '<table class="table table-sm">';
    echo '<tr><td width="40%"><strong>ID:</strong></td><td>#' . $row['id'] . '</td></tr>';
    echo '<tr><td><strong>Type:</strong></td><td><span class="badge bg-' . $type_color . '">' . ucfirst($row['transaction_type']) . '</span></td></tr>';
    echo '<tr><td><strong>Amount:</strong></td><td class="fw-500">$' . number_format($row['amount'], 2) . '</td></tr>';
    echo '<tr><td><strong>Date:</strong></td><td>' . date('F d, Y', strtotime($row['transaction_date'])) . '</td></tr>';
    echo '<tr><td><strong>Created:</strong></td><td>' . date('F d, Y H:i:s', strtotime($row['created_at'])) . '</td></tr>';
    echo '<tr><td><strong>Description:</strong></td><td>' . htmlspecialchars($row['description']) . '</td></tr>';
    echo '</table>';
    echo '</div>';
    
    echo '<div class="col-md-6">';
    echo '<h6>Subscription Details</h6>';
    echo '<table class="table table-sm">';
    echo '<tr><td width="40%"><strong>Subscription ID:</strong></td><td>#' . $row['subscription_id'] . '</td></tr>';
    echo '<tr><td><strong>Bot Plan:</strong></td><td>' . htmlspecialchars($row['plan_name']) . '</td></tr>';
    echo '<tr><td><strong>Monthly Fee:</strong></td><td>$' . number_format($row['subscription_fee'], 2) . '</td></tr>';
    echo '<tr><td><strong>Trading Balance:</strong></td><td>$' . number_format($row['trading_balance'], 2) . '</td></tr>';
    echo '<tr><td><strong>Status:</strong></td><td><span class="badge bg-' . ($row['subscription_status'] == 'active' ? 'success' : 'secondary') . '">' . ucfirst($row['subscription_status']) . '</span></td></tr>';
    echo '<tr><td><strong>Period:</strong></td><td>' . date('M d, Y', strtotime($row['subscription_start'])) . ' to ' . date('M d, Y', strtotime($row['subscription_end'])) . '</td></tr>';
    echo '</table>';
    echo '</div>';
    echo '</div>';
    
    echo '<div class="row mt-3">';
    echo '<div class="col-12">';
    echo '<h6>User Details</h6>';
    echo '<table class="table table-sm">';
    echo '<tr><td width="40%"><strong>Username:</strong></td><td>' . htmlspecialchars($row['username']) . '</td></tr>';
    echo '<tr><td><strong>Email:</strong></td><td>' . htmlspecialchars($row['email']) . '</td></tr>';
    echo '<tr><td><strong>Phone:</strong></td><td>' . htmlspecialchars($row['phone']) . '</td></tr>';
    echo '</table>';
    echo '</div>';
    echo '</div>';
} else {
    echo '<div class="alert alert-danger">Transaction not found</div>';
}
?>