<?php
session_start();
include('../includes/config.php');

$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : date('Y-m-d', strtotime('-30 days'));
$end_date = isset($_GET['end_date']) ? $_GET['end_date'] : date('Y-m-d');

$sql = "SELECT DATE(created_at) as date, 
               SUM(amount) as total_profit
        FROM bot_transactions 
        WHERE transaction_type = 'profit' 
        AND DATE(created_at) BETWEEN '$start_date' AND '$end_date'
        GROUP BY DATE(created_at)
        ORDER BY date";

$result = mysqli_query($conn, $sql);

$labels = [];
$profits = [];

while ($row = mysqli_fetch_assoc($result)) {
    $labels[] = date('M d', strtotime($row['date']));
    $profits[] = floatval($row['total_profit']);
}

echo json_encode([
    'success' => true,
    'labels' => $labels,
    'profits' => $profits
]);
?>