<?php
session_start();
include('../includes/config.php');

$category_id = isset($_GET['category_id']) ? intval($_GET['category_id']) : 0;

if ($category_id > 0) {
    $sql = "SELECT * FROM faq_items WHERE category_id = $category_id ORDER BY sort_order ASC, created_at ASC";
    $result = mysqli_query($conn, $sql);
    
    $faqs = array();
    while ($row = mysqli_fetch_assoc($result)) {
        $faqs[] = array(
            'id' => $row['id'],
            'question' => htmlspecialchars($row['question']),
            'is_active' => $row['is_active']
        );
    }
    
    if (count($faqs) > 0) {
        echo json_encode(array(
            'success' => true,
            'faqs' => $faqs
        ));
    } else {
        echo json_encode(array(
            'success' => false,
            'message' => 'No FAQs found in this category'
        ));
    }
} else {
    echo json_encode(array(
        'success' => false,
        'message' => 'Invalid category ID'
    ));
}
?>