<?php
session_start();
include('../includes/config.php');

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Get feedback details
$sql = "SELECT f.*, u.username, u.email, u.phone 
        FROM feedback f 
        LEFT JOIN users u ON f.user_id = u.id 
        WHERE f.id = $id";
$result = mysqli_query($conn, $sql);

if ($row = mysqli_fetch_assoc($result)) {
    $status_colors = array('new' => 'warning', 'reviewed' => 'info', 'actioned' => 'success');
    $type_colors = array('general' => 'primary', 'complaint' => 'danger', 'suggestion' => 'info', 'dispute' => 'warning');
    $rating_colors = array(1 => 'danger', 2 => 'warning', 3 => 'info', 4 => 'primary', 5 => 'success');
    $rating_stars = array(1 => '★☆☆☆☆', 2 => '★★☆☆☆', 3 => '★★★☆☆', 4 => '★★★★☆', 5 => '★★★★★');
    
    $status_color = isset($status_colors[$row['status']]) ? $status_colors[$row['status']] : 'secondary';
    $type_color = isset($type_colors[$row['type']]) ? $type_colors[$row['type']] : 'secondary';
    $rating_color = isset($rating_colors[$row['rating']]) ? $rating_colors[$row['rating']] : 'secondary';
    $rating_star = isset($rating_stars[$row['rating']]) ? $rating_stars[$row['rating']] : 'N/A';
    $created_date = date('F d, Y H:i:s', strtotime($row['created_at']));
    
    echo '<div class="row">';
    echo '<div class="col-md-8">';
    echo '<h5>' . htmlspecialchars($row['subject']) . '</h5>';
    echo '</div>';
    echo '<div class="col-md-4 text-end">';
    echo '<span class="badge bg-' . $status_color . '">' . ucfirst($row['status']) . '</span> ';
    echo '<span class="badge bg-' . $type_color . '">' . ucfirst($row['type']) . '</span>';
    if ($row['rating']) {
        echo '<div class="mt-2 text-' . $rating_color . '">' . $rating_star . ' (' . $row['rating'] . '/5)</div>';
    }
    echo '</div>';
    echo '</div>';
    
    echo '<div class="mt-3">';
    echo '<div class="feedback-message">';
    echo nl2br(htmlspecialchars($row['message']));
    echo '</div>';
    echo '</div>';
    
    echo '<div class="row mt-4">';
    echo '<div class="col-md-6">';
    echo '<h6>User Information</h6>';
    echo '<table class="table table-sm">';
    if ($row['username']) {
        echo '<tr><td><strong>Username:</strong></td><td>' . htmlspecialchars($row['username']) . '</td></tr>';
        echo '<tr><td><strong>Email:</strong></td><td>' . htmlspecialchars($row['email']) . '</td></tr>';
        if ($row['phone']) {
            echo '<tr><td><strong>Phone:</strong></td><td>' . htmlspecialchars($row['phone']) . '</td></tr>';
        }
    } else {
        echo '<tr><td><strong>Name:</strong></td><td>' . htmlspecialchars($row['name']) . '</td></tr>';
        echo '<tr><td><strong>Email:</strong></td><td>' . htmlspecialchars($row['email']) . '</td></tr>';
    }
    echo '</table>';
    echo '</div>';
    
    echo '<div class="col-md-6">';
    echo '<h6>Feedback Information</h6>';
    echo '<table class="table table-sm">';
    echo '<tr><td><strong>Submitted:</strong></td><td>' . $created_date . '</td></tr>';
    echo '<tr><td><strong>Status:</strong></td><td><span class="badge bg-' . $status_color . '">' . ucfirst($row['status']) . '</span></td></tr>';
    echo '<tr><td><strong>Type:</strong></td><td><span class="badge bg-' . $type_color . '">' . ucfirst($row['type']) . '</span></td></tr>';
    if ($row['rating']) {
        echo '<tr><td><strong>Rating:</strong></td><td><span class="text-' . $rating_color . '">' . $rating_star . '</span></td></tr>';
    }
    echo '</table>';
    echo '</div>';
    echo '</div>';
    
    // Get responses
    $response_sql = "SELECT * FROM feedback_responses WHERE feedback_id = $id ORDER BY created_at DESC";
    $response_result = mysqli_query($conn, $response_sql);
    
    if (mysqli_num_rows($response_result) > 0) {
        echo '<div class="mt-4">';
        echo '<h6>Admin Responses</h6>';
        echo '<div class="responses">';
        while ($response = mysqli_fetch_assoc($response_result)) {
            $response_date = date('M d, Y H:i', strtotime($response['created_at']));
            echo '<div class="response-bubble">';
            echo '<div class="d-flex justify-content-between">';
            echo '<strong>' . htmlspecialchars($response['admin_name']) . '</strong>';
            echo '<small class="text-mute">' . $response_date . '</small>';
            echo '</div>';
            echo '<div class="mt-2">' . nl2br(htmlspecialchars($response['response'])) . '</div>';
            if ($response['send_email']) {
                echo '<small class="text-success"><i class="fas fa-envelope me-1"></i> Sent via email</small>';
            }
            echo '</div>';
        }
        echo '</div>';
        echo '</div>';
    }
} else {
    echo '<div class="alert alert-danger">Feedback not found.</div>';
}
?>