<?php
session_start();
include('../includes/config.php');

// Get feedback statistics
$sql = "SELECT 
    SUM(CASE WHEN status = 'new' THEN 1 ELSE 0 END) as new_count,
    SUM(CASE WHEN status = 'reviewed' THEN 1 ELSE 0 END) as reviewed_count,
    SUM(CASE WHEN status = 'actioned' THEN 1 ELSE 0 END) as actioned_count,
    COUNT(*) as total_count,
    AVG(rating) as avg_rating
    FROM feedback";

$result = mysqli_query($conn, $sql);

if ($row = mysqli_fetch_assoc($result)) {
    echo json_encode(array(
        'success' => true,
        'new_count' => $row['new_count'] ?: 0,
        'reviewed_count' => $row['reviewed_count'] ?: 0,
        'actioned_count' => $row['actioned_count'] ?: 0,
        'avg_rating' => number_format($row['avg_rating'] ?: 0, 1)
    ));
} else {
    echo json_encode(array(
        'success' => false,
        'new_count' => 0,
        'reviewed_count' => 0,
        'actioned_count' => 0,
        'avg_rating' => '0.0'
    ));
}
?>