<?php
session_start();
include('../includes/config.php');

// Get counts for stats
$count_result = mysqli_query($conn, "SELECT verification_status, COUNT(*) as count FROM kyc_documents GROUP BY verification_status");
$status_counts = array('pending' => 0, 'verified' => 0, 'rejected' => 0, 'total' => 0);
while ($row = mysqli_fetch_assoc($count_result)) {
    $status_counts[$row['verification_status']] = $row['count'];
}
$status_counts['total'] = array_sum($status_counts);

// Get new pending documents in last 5 minutes
$five_min_ago = date('Y-m-d H:i:s', strtotime('-5 minutes'));
$new_result = mysqli_query($conn, "SELECT COUNT(*) as count FROM kyc_documents WHERE verification_status = 'pending' AND upload_date >= '$five_min_ago'");
$new_row = mysqli_fetch_assoc($new_result);
$new_pending = $new_row['count'];

echo json_encode(array(
    'success' => true,
    'total' => $status_counts['total'],
    'pending' => $status_counts['pending'],
    'verified' => $status_counts['verified'],
    'rejected' => $status_counts['rejected'],
    'new_pending' => $new_pending
));
?>