<?php
session_start();
include('../includes/config.php');

header('Content-Type: application/json');

$today = date('Y-m-d');

// Get active users count
$active_users_sql = "SELECT COUNT(*) as total FROM users WHERE status = 'verified'";
$active_users_result = mysqli_query($conn, $active_users_sql);
$active_users_row = mysqli_fetch_assoc($active_users_result);
$active_users = $active_users_row['total'];

// Get trades today (transactions count)
$trades_sql = "SELECT COUNT(*) as total FROM transactions WHERE DATE(date) = '$today' AND type IN ('profit', 'loss')";
$trades_result = mysqli_query($conn, $trades_sql);
$trades_row = mysqli_fetch_assoc($trades_result);
$trades_today = $trades_row['total'];

// Get 24h volume
$volume_sql = "SELECT COALESCE(SUM(amount), 0) as total FROM transactions 
               WHERE DATE(date) = '$today' AND status = 'completed' 
               AND type IN ('deposit', 'withdrawal', 'profit')";
$volume_result = mysqli_query($conn, $volume_sql);
$volume_row = mysqli_fetch_assoc($volume_result);
$volume_24h = number_format($volume_row['total'], 2);

// Get open tickets
$tickets_sql = "SELECT COUNT(*) as total FROM support_tickets WHERE status IN ('open', 'in_progress')";
$tickets_result = mysqli_query($conn, $tickets_sql);
$tickets_row = mysqli_fetch_assoc($tickets_result);
$open_tickets = $tickets_row['total'];

// Get profit today
$profit_sql = "SELECT COALESCE(SUM(amount), 0) as total FROM transactions 
               WHERE type = 'profit' AND status = 'completed' AND DATE(date) = '$today'";
$profit_result = mysqli_query($conn, $profit_sql);
$profit_row = mysqli_fetch_assoc($profit_result);
$profit_today = floatval($profit_row['total']);

// Get system load (active subscriptions percentage)
$total_users_sql = "SELECT COUNT(*) as total FROM users";
$total_users_result = mysqli_query($conn, $total_users_sql);
$total_users_row = mysqli_fetch_assoc($total_users_result);
$total_users = $total_users_row['total'] ?: 1;

$active_subs_sql = "SELECT COUNT(*) as total FROM user_bot_subscriptions WHERE status = 'active'";
$active_subs_result = mysqli_query($conn, $active_subs_sql);
$active_subs_row = mysqli_fetch_assoc($active_subs_result);
$active_subs = $active_subs_row['total'];

// Calculate system load percentage
$system_load = $total_users > 0 ? round(($active_subs / $total_users) * 100) : 0;
$system_load = min($system_load, 100);

// Add some random fluctuation for live effect (optional)
$random_factor = 0.95 + (rand(0, 10) / 100); // 95% to 105%
$active_users = round($active_users * $random_factor);
$trades_today = round($trades_today * $random_factor);
$volume_24h = number_format(floatval($volume_24h) * $random_factor, 2);
$profit_today = $profit_today * $random_factor;

echo json_encode(array(
    'success' => true,
    'active_users' => $active_users,
    'trades_today' => $trades_today,
    'volume_24h' => $volume_24h,
    'open_tickets' => $open_tickets,
    'profit_today' => $profit_today,
    'system_load' => $system_load
));
?>