<?php
session_start();
require_once '../includes/config.php';

$query = "SELECT al.*, u.first_name, u.last_name 
          FROM activity_logs al 
          LEFT JOIN users u ON al.user_id = u.id 
          ORDER BY al.created_at DESC 
          LIMIT 10";

$result = mysqli_query($conn, $query);

while($row = mysqli_fetch_assoc($result)) {
    $time = date('Y-m-d H:i:s', strtotime($row['created_at']));
    $user = $row['first_name'] . ' ' . $row['last_name'];
    if(empty($row['first_name'])) {
        $user = 'System';
    }
    
    echo "<tr>
            <td>$time</td>
            <td>$user</td>
            <td>{$row['action']}</td>
            <td>{$row['description']}</td>
            <td>{$row['ip_address']}</td>
          </tr>";
}

if(mysqli_num_rows($result) == 0) {
    echo "<tr><td colspan='5' class='text-center'>No recent activity</td></tr>";
}
?>