<?php
session_start();
include('../includes/config.php');

// Get overall referral stats
$stats_sql = "SELECT 
                COUNT(DISTINCT r.user_id) as total_referrers,
                COUNT(DISTINCT r.referred_id) as total_referred_users,
                COUNT(DISTINCT CASE WHEN u.status = 'verified' THEN r.referred_id END) as verified_referred,
                COALESCE(SUM(rt.amount), 0) as total_paid_out
              FROM referrals r
              LEFT JOIN users u ON r.referred_id = u.id
              LEFT JOIN referral_transactions rt ON r.user_id = rt.referrer_id";
$stats_result = mysqli_query($conn, $stats_sql);
$stats = mysqli_fetch_assoc($stats_result);

echo json_encode(array(
    'success' => true,
    'total_referrers' => $stats['total_referrers'],
    'total_referred_users' => $stats['total_referred_users'],
    'verified_referred' => $stats['verified_referred'],
    'total_paid_out' => number_format($stats['total_paid_out'], 2)
));
?>