<?php
session_start();
include('../includes/config.php');

$sql = "SELECT p.plan_name,
               COUNT(s.id) as subscription_count,
               AVG(s.success_rate) as avg_success_rate
        FROM user_bot_subscriptions s
        LEFT JOIN trading_bot_plans p ON s.bot_plan_id = p.id
        WHERE s.status IN ('active', 'expired')
        AND s.success_rate > 0
        GROUP BY p.id
        ORDER BY p.sort_order";

$result = mysqli_query($conn, $sql);

$labels = [];
$success_rates = [];

while ($row = mysqli_fetch_assoc($result)) {
    $labels[] = $row['plan_name'] . ' (' . $row['subscription_count'] . ')';
    $success_rates[] = floatval($row['avg_success_rate']);
}

echo json_encode([
    'success' => true,
    'labels' => $labels,
    'success_rates' => $success_rates
]);
?>