<?php
session_start();
include('../includes/config.php');

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$sql = "SELECT t.*, u.username, u.email, u.phone, u.first_name, u.last_name 
        FROM transactions t 
        LEFT JOIN users u ON t.user_id = u.id 
        WHERE t.id = $id";
$result = mysqli_query($conn, $sql);

if ($row = mysqli_fetch_assoc($result)) {
    // Type colors
    $type_colors = array(
        'deposit' => 'success',
        'withdrawal' => 'danger',
        'profit' => 'info',
        'loss' => 'warning',
        'fee' => 'secondary',
        'bonus' => 'primary',
        'referral' => 'dark'
    );
    
    // Status colors
    $status_colors = array(
        'pending' => 'warning',
        'processing' => 'info',
        'completed' => 'success',
        'failed' => 'danger',
        'cancelled' => 'secondary',
        'rejected' => 'dark'
    );
    
    $type_color = isset($type_colors[$row['type']]) ? $type_colors[$row['type']] : 'secondary';
    $status_color = isset($status_colors[$row['status']]) ? $status_colors[$row['status']] : 'secondary';
    
    echo '<div class="row">';
    echo '<div class="col-md-6">';
    echo '<h6>Transaction Information</h6>';
    echo '<table class="table table-sm">';
    echo '<tr><td width="40%"><strong>Transaction ID:</strong></td><td>' . $row['id'] . '</td></tr>';
    echo '<tr><td><strong>Type:</strong></td><td><span class="badge bg-' . $type_color . '">' . ucfirst($row['type']) . '</span></td></tr>';
    echo '<tr><td><strong>Amount:</strong></td><td><strong>$' . number_format($row['amount'], 2) . '</strong></td></tr>';
    echo '<tr><td><strong>Fee:</strong></td><td>$' . number_format($row['fee'], 2) . '</td></tr>';
    echo '<tr><td><strong>Net Amount:</strong></td><td>$' . number_format($row['net_amount'], 2) . '</td></tr>';
    echo '<tr><td><strong>Status:</strong></td><td><span class="badge bg-' . $status_color . '">' . ucfirst($row['status']) . '</span></td></tr>';
    echo '<tr><td><strong>Currency:</strong></td><td>' . $row['currency'] . '</td></tr>';
    echo '<tr><td><strong>Date:</strong></td><td>' . date('F d, Y H:i:s', strtotime($row['date'])) . '</td></tr>';
    echo '<tr><td><strong>Created:</strong></td><td>' . date('F d, Y H:i:s', strtotime($row['created_at'])) . '</td></tr>';
    echo '<tr><td><strong>Updated:</strong></td><td>' . date('F d, Y H:i:s', strtotime($row['updated_at'])) . '</td></tr>';
    echo '</table>';
    echo '</div>';
    
    echo '<div class="col-md-6">';
    echo '<h6>User Information</h6>';
    echo '<table class="table table-sm">';
    echo '<tr><td width="40%"><strong>User ID:</strong></td><td>' . $row['user_id'] . '</td></tr>';
    echo '<tr><td><strong>Username:</strong></td><td>' . htmlspecialchars($row['username']) . '</td></tr>';
    echo '<tr><td><strong>Email:</strong></td><td>' . htmlspecialchars($row['email']) . '</td></tr>';
    echo '<tr><td><strong>Name:</strong></td><td>' . htmlspecialchars($row['first_name'] . ' ' . $row['last_name']) . '</td></tr>';
    echo '<tr><td><strong>Phone:</strong></td><td>' . htmlspecialchars($row['phone']) . '</td></tr>';
    echo '</table>';
    echo '</div>';
    echo '</div>';
    
    echo '<div class="row mt-3">';
    echo '<div class="col-12">';
    echo '<h6>Additional Information</h6>';
    echo '<table class="table table-sm">';
    echo '<tr><td width="20%"><strong>Description:</strong></td><td>' . htmlspecialchars($row['description']) . '</td></tr>';
    echo '<tr><td><strong>Reference ID:</strong></td><td>' . htmlspecialchars($row['reference_id']) . '</td></tr>';
    echo '<tr><td><strong>Related ID:</strong></td><td>' . $row['related_id'] . '</td></tr>';
    echo '<tr><td><strong>Related Type:</strong></td><td>' . $row['related_type'] . '</td></tr>';
    echo '<tr><td><strong>Balance Before:</strong></td><td>$' . number_format($row['balance_before'], 2) . '</td></tr>';
    echo '<tr><td><strong>Balance After:</strong></td><td>$' . number_format($row['balance_after'], 2) . '</td></tr>';
    echo '</table>';
    echo '</div>';
    echo '</div>';
} else {
    echo '<div class="alert alert-danger">Transaction not found</div>';
}
?>