<?php
session_start();
include('includes/config.php');

// Get filter parameters
$format = isset($_GET['format']) ? $_GET['format'] : 'csv';
$type = isset($_GET['type']) ? $_GET['type'] : '';
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : '';
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : '';
$subscription_id = isset($_GET['subscription_id']) ? intval($_GET['subscription_id']) : 0;
$search = isset($_GET['search']) ? $_GET['search'] : '';

// Build query
$sql = "SELECT bt.*, 
               u.username, 
               u.email,
               p.plan_name,
               s.trading_balance
        FROM bot_transactions bt
        LEFT JOIN user_bot_subscriptions s ON bt.subscription_id = s.id
        LEFT JOIN users u ON s.user_id = u.id
        LEFT JOIN trading_bot_plans p ON s.bot_plan_id = p.id
        WHERE 1=1";

if ($type) {
    $sql .= " AND bt.transaction_type = '$type'";
}

if ($date_from && $date_to) {
    $sql .= " AND bt.transaction_date BETWEEN '$date_from' AND '$date_to'";
} elseif ($date_from) {
    $sql .= " AND bt.transaction_date >= '$date_from'";
} elseif ($date_to) {
    $sql .= " AND bt.transaction_date <= '$date_to'";
}

if ($subscription_id > 0) {
    $sql .= " AND bt.subscription_id = $subscription_id";
}

if ($search) {
    $sql .= " AND (u.username LIKE '%$search%' OR u.email LIKE '%$search%' OR p.plan_name LIKE '%$search%')";
}

$sql .= " ORDER BY bt.transaction_date DESC";
$result = mysqli_query($conn, $sql);

if ($format == 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="bot_transactions_' . date('Y-m-d') . '.csv"');
    
    $output = fopen('php://output', 'w');
    
    // Add headers
    fputcsv($output, array('ID', 'Subscription ID', 'User', 'Email', 'Bot Plan', 'Type', 'Amount', 'Date', 'Description', 'Created At'));
    
    // Add data
    while ($row = mysqli_fetch_assoc($result)) {
        fputcsv($output, array(
            $row['id'],
            $row['subscription_id'],
            $row['username'],
            $row['email'],
            $row['plan_name'],
            $row['transaction_type'],
            $row['amount'],
            $row['transaction_date'],
            $row['description'],
            $row['created_at']
        ));
    }
    
    fclose($output);
    
} elseif ($format == 'excel') {
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="bot_transactions_' . date('Y-m-d') . '.xls"');
    
    echo '<table border="1">';
    echo '<tr>';
    echo '<th>ID</th>';
    echo '<th>Subscription ID</th>';
    echo '<th>User</th>';
    echo '<th>Email</th>';
    echo '<th>Bot Plan</th>';
    echo '<th>Type</th>';
    echo '<th>Amount</th>';
    echo '<th>Date</th>';
    echo '<th>Description</th>';
    echo '<th>Created At</th>';
    echo '</tr>';
    
    while ($row = mysqli_fetch_assoc($result)) {
        echo '<tr>';
        echo '<td>' . $row['id'] . '</td>';
        echo '<td>' . $row['subscription_id'] . '</td>';
        echo '<td>' . $row['username'] . '</td>';
        echo '<td>' . $row['email'] . '</td>';
        echo '<td>' . $row['plan_name'] . '</td>';
        echo '<td>' . $row['transaction_type'] . '</td>';
        echo '<td>' . $row['amount'] . '</td>';
        echo '<td>' . $row['transaction_date'] . '</td>';
        echo '<td>' . $row['description'] . '</td>';
        echo '<td>' . $row['created_at'] . '</td>';
        echo '</tr>';
    }
    
    echo '</table>';
    
} elseif ($format == 'pdf') {
    header('Content-Type: application/pdf');
    header('Content-Disposition: attachment; filename="bot_transactions_' . date('Y-m-d') . '.pdf"');
    
    $html = '<h1>Bot Transactions Report</h1>';
    $html .= '<p>Generated on: ' . date('Y-m-d H:i:s') . '</p>';
    $html .= '<table border="1" cellpadding="5" cellspacing="0">';
    $html .= '<tr>';
    $html .= '<th>ID</th>';
    $html .= '<th>User</th>';
    $html .= '<th>Bot Plan</th>';
    $html .= '<th>Type</th>';
    $html .= '<th>Amount</th>';
    $html .= '<th>Date</th>';
    $html .= '</tr>';
    
    while ($row = mysqli_fetch_assoc($result)) {
        $html .= '<tr>';
        $html .= '<td>' . $row['id'] . '</td>';
        $html .= '<td>' . $row['username'] . '</td>';
        $html .= '<td>' . $row['plan_name'] . '</td>';
        $html .= '<td>' . $row['transaction_type'] . '</td>';
        $html .= '<td>$' . $row['amount'] . '</td>';
        $html .= '<td>' . $row['transaction_date'] . '</td>';
        $html .= '</tr>';
    }
    
    $html .= '</table>';
    
    echo $html;
}
?>